/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonPostProcessable;
import org.apache.doris.persist.gson.GsonUtils;

public class TempPartitions
implements Writable,
GsonPostProcessable {
    @SerializedName(value="idToPartition")
    private Map<Long, Partition> idToPartition = Maps.newHashMap();
    private Map<String, Partition> nameToPartition = Maps.newHashMap();
    @Deprecated
    private RangePartitionInfo partitionInfo = null;

    public void addPartition(Partition partition) {
        this.idToPartition.put(partition.getId(), partition);
        this.nameToPartition.put(partition.getName(), partition);
    }

    public long getUpdateTime() {
        long updateTime = -1L;
        for (Partition p : this.idToPartition.values()) {
            if (p.getVisibleVersionTime() <= updateTime) continue;
            updateTime = p.getVisibleVersionTime();
        }
        return updateTime;
    }

    public void dropPartition(String partitionName, boolean needDropTablet) {
        Partition partition = this.nameToPartition.get(partitionName);
        if (partition != null) {
            this.idToPartition.remove(partition.getId());
            this.nameToPartition.remove(partitionName);
            if (!Catalog.isCheckpointThread() && needDropTablet) {
                TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                    for (Tablet tablet : index.getTablets()) {
                        invertedIndex.deleteTablet(tablet.getId());
                    }
                }
            }
        }
    }

    public Partition getPartition(long partitionId) {
        return this.idToPartition.get(partitionId);
    }

    public Partition getPartition(String partitionName) {
        return this.nameToPartition.get(partitionName);
    }

    public List<Partition> getAllPartitions() {
        return Lists.newArrayList(this.idToPartition.values());
    }

    public boolean hasPartition(String partName) {
        return this.nameToPartition.containsKey(partName);
    }

    public boolean isEmpty() {
        return this.idToPartition.isEmpty();
    }

    @Deprecated
    public RangePartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    @Deprecated
    public void unsetPartitionInfo() {
        this.partitionInfo = null;
    }

    public void dropAll() {
        HashSet partNames = Sets.newHashSet(this.nameToPartition.keySet());
        for (String partName : partNames) {
            this.dropPartition(partName, true);
        }
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static TempPartitions read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (TempPartitions)GsonUtils.GSON.fromJson(json, TempPartitions.class);
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Partition partition = Partition.read(in);
            this.idToPartition.put(partition.getId(), partition);
            this.nameToPartition.put(partition.getName(), partition);
        }
        if (in.readBoolean()) {
            this.partitionInfo = (RangePartitionInfo)RangePartitionInfo.read(in);
        }
    }

    @Override
    public void gsonPostProcess() {
        for (Partition partition : this.idToPartition.values()) {
            this.nameToPartition.put(partition.getName(), partition);
        }
    }
}

