/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TTabletStat;
import org.apache.doris.thrift.TTabletStatResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabletStatMgr
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(TabletStatMgr.class);

    public TabletStatMgr() {
        super("tablet stat mgr", Config.tablet_stat_update_interval_second * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runAfterCatalogReady() {
        ImmutableMap<Long, Backend> backends = Catalog.getCurrentSystemInfo().getIdToBackend();
        long start = System.currentTimeMillis();
        backends.values().parallelStream().forEach(backend -> {
            BackendService.Client client = null;
            TNetworkAddress address = null;
            boolean ok = false;
            try {
                address = new TNetworkAddress(backend.getHost(), backend.getBePort());
                client = ClientPool.backendPool.borrowObject(address);
                TTabletStatResult result = client.getTabletStat();
                LOG.debug("get tablet stat from backend: {}, num: {}", (Object)backend.getId(), (Object)result.getTabletsStatsSize());
                this.updateTabletStat(backend.getId(), result);
                ok = true;
                if (ok) {
                    ClientPool.backendPool.returnObject(address, client);
                } else {
                    ClientPool.backendPool.invalidateObject(address, client);
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn("task exec error. backend[{}]", (Object)backend.getId(), (Object)e);
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                    } else {
                        ClientPool.backendPool.invalidateObject(address, client);
                    }
                }
                catch (Throwable throwable) {
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                    } else {
                        ClientPool.backendPool.invalidateObject(address, client);
                    }
                    throw throwable;
                }
            }
        });
        LOG.debug("finished to get tablet stat of all backends. cost: {} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List<Long> dbIds = Catalog.getCurrentCatalog().getDbIds();
        for (Long dbId : dbIds) {
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) continue;
            List<Table> tableList = db.getTables();
            for (Table table : tableList) {
                if (table.getType() != Table.TableType.OLAP) continue;
                OlapTable olapTable = (OlapTable)table;
                if (!table.writeLockIfExist()) continue;
                try {
                    for (Partition partition : olapTable.getAllPartitions()) {
                        long version = partition.getVisibleVersion();
                        for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                            long indexRowCount = 0L;
                            for (Tablet tablet : index.getTablets()) {
                                long tabletRowCount = 0L;
                                for (Replica replica : tablet.getReplicas()) {
                                    if (!replica.checkVersionCatchUp(version, false) || replica.getRowCount() <= tabletRowCount) continue;
                                    tabletRowCount = replica.getRowCount();
                                }
                                indexRowCount += tabletRowCount;
                            }
                            index.setRowCount(indexRowCount);
                        }
                    }
                    LOG.debug("finished to set row num for table: {} in database: {}", (Object)table.getName(), (Object)db.getFullName());
                }
                finally {
                    table.writeUnlock();
                }
            }
        }
        LOG.info("finished to update index row num of all databases. cost: {} ms", (Object)(System.currentTimeMillis() - start));
    }

    private void updateTabletStat(Long beId, TTabletStatResult result) {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        if (result.isSetTabletStatList()) {
            for (TTabletStat stat : result.getTabletStatList()) {
                Replica replica;
                if (invertedIndex.getTabletMeta(stat.getTabletId()) == null || (replica = invertedIndex.getReplica(stat.getTabletId(), beId)) == null) continue;
                replica.updateStat(stat.getDataSize(), stat.getRowNum(), stat.getVersionCount());
            }
        } else {
            for (Map.Entry entry : result.getTabletsStats().entrySet()) {
                Replica replica;
                if (invertedIndex.getTabletMeta((Long)entry.getKey()) == null || (replica = invertedIndex.getReplica((Long)entry.getKey(), beId)) == null) continue;
                replica.updateStat(((TTabletStat)entry.getValue()).getDataSize(), ((TTabletStat)entry.getValue()).getRowNum());
            }
        }
    }
}

