/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabletMeta {
    private static final Logger LOG = LogManager.getLogger(TabletMeta.class);
    private final long dbId;
    private final long tableId;
    private final long partitionId;
    private final long indexId;
    private int oldSchemaHash;
    private int newSchemaHash;
    private TStorageMedium storageMedium;
    private ReentrantReadWriteLock lock;

    public TabletMeta(long dbId, long tableId, long partitionId, long indexId, int schemaHash, TStorageMedium storageMedium) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.indexId = indexId;
        this.oldSchemaHash = schemaHash;
        this.newSchemaHash = -1;
        this.storageMedium = storageMedium;
        this.lock = new ReentrantReadWriteLock();
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public TStorageMedium getStorageMedium() {
        return this.storageMedium;
    }

    public void setStorageMedium(TStorageMedium storageMedium) {
        this.storageMedium = storageMedium;
    }

    public void setNewSchemaHash(int newSchemaHash) {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((this.newSchemaHash == -1 ? 1 : 0) != 0);
            this.newSchemaHash = newSchemaHash;
            LOG.debug("setNewSchemaHash: {}", (Object)this.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updateToNewSchemaHash() {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((this.newSchemaHash != -1 ? 1 : 0) != 0);
            int tmp = this.oldSchemaHash;
            this.oldSchemaHash = this.newSchemaHash;
            this.newSchemaHash = tmp;
            LOG.debug("updateToNewSchemaHash: " + this.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteNewSchemaHash() {
        this.lock.writeLock().lock();
        try {
            LOG.debug("deleteNewSchemaHash: " + this.toString());
            this.newSchemaHash = -1;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getOldSchemaHash() {
        this.lock.readLock().lock();
        try {
            int n = this.oldSchemaHash;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsSchemaHash(int schemaHash) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.oldSchemaHash == schemaHash || this.newSchemaHash == schemaHash;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("dbId=").append(this.dbId);
            sb.append(" tableId=").append(this.tableId);
            sb.append(" partitionId=").append(this.partitionId);
            sb.append(" indexId=").append(this.indexId);
            sb.append(" oldSchemaHash=").append(this.oldSchemaHash);
            sb.append(" newSchemaHash=").append(this.newSchemaHash);
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

