/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.Config;
import org.apache.doris.thrift.TPartitionVersionInfo;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TTablet;
import org.apache.doris.thrift.TTabletInfo;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.PartitionCommitInfo;
import org.apache.doris.transaction.TableCommitInfo;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabletInvertedIndex {
    private static final Logger LOG = LogManager.getLogger(TabletInvertedIndex.class);
    public static final int NOT_EXIST_VALUE = -1;
    public static final TabletMeta NOT_EXIST_TABLET_META = new TabletMeta(-1L, -1L, -1L, -1L, -1, TStorageMedium.HDD);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<Long, TabletMeta> tabletMetaMap = Maps.newHashMap();
    private Map<Long, Long> replicaToTabletMap = Maps.newHashMap();
    private Table<Long, Long, TabletMeta> tabletMetaTable = HashBasedTable.create();
    private Table<Long, Long, Replica> replicaMetaTable = HashBasedTable.create();
    private Table<Long, Long, Replica> backingReplicaMetaTable = HashBasedTable.create();
    private volatile ImmutableSet<Long> partitionIdInMemorySet = ImmutableSet.of();

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tabletReport(long backendId, Map<Long, TTablet> backendTablets, HashMap<Long, TStorageMedium> storageMediumMap, ListMultimap<Long, Long> tabletSyncMap, ListMultimap<Long, Long> tabletDeleteFromMeta, Set<Long> foundTabletsWithValidSchema, Map<Long, TTabletInfo> foundTabletsWithInvalidSchema, ListMultimap<TStorageMedium, Long> tabletMigrationMap, Map<Long, ListMultimap<Long, TPartitionVersionInfo>> transactionsToPublish, ListMultimap<Long, Long> transactionsToClear, ListMultimap<Long, Long> tabletRecoveryMap, List<Triple<Long, Integer, Boolean>> tabletToInMemory) {
        this.readLock();
        long start = System.currentTimeMillis();
        try {
            LOG.info("begin to do tablet diff with backend[{}]. num: {}", (Object)backendId, (Object)backendTablets.size());
            Map replicaMetaWithBackend = this.backingReplicaMetaTable.row((Object)backendId);
            if (replicaMetaWithBackend != null) {
                replicaMetaWithBackend.entrySet().parallelStream().forEach(entry -> {
                    long tabletId = (Long)entry.getKey();
                    Preconditions.checkState((boolean)this.tabletMetaMap.containsKey(tabletId));
                    TabletMeta tabletMeta = this.tabletMetaMap.get(tabletId);
                    if (backendTablets.containsKey(tabletId)) {
                        TTablet backendTablet = (TTablet)backendTablets.get(tabletId);
                        Replica replica = (Replica)entry.getValue();
                        for (TTabletInfo backendTabletInfo : backendTablet.getTabletInfos()) {
                            if (tabletMeta.containsSchemaHash(backendTabletInfo.getSchemaHash())) {
                                TStorageMedium storageMedium;
                                List list;
                                foundTabletsWithValidSchema.add(tabletId);
                                if (this.partitionIdInMemorySet.contains((Object)backendTabletInfo.getPartitionId()) != backendTabletInfo.isIsInMemory()) {
                                    list = tabletToInMemory;
                                    synchronized (list) {
                                        tabletToInMemory.add((Triple<Long, Integer, Boolean>)new ImmutableTriple((Object)tabletId, (Object)backendTabletInfo.getSchemaHash(), (Object)(!backendTabletInfo.isIsInMemory() ? 1 : 0)));
                                    }
                                }
                                if (this.needSync(replica, backendTabletInfo)) {
                                    list = tabletSyncMap;
                                    synchronized (list) {
                                        tabletSyncMap.put((Object)tabletMeta.getDbId(), (Object)tabletId);
                                    }
                                }
                                if (backendTabletInfo.isSetPathHash() && replica.getPathHash() != backendTabletInfo.getPathHash()) {
                                    replica.setPathHash(backendTabletInfo.getPathHash());
                                }
                                if (backendTabletInfo.isSetSchemaHash() && replica.getState() == Replica.ReplicaState.NORMAL && replica.getSchemaHash() != backendTabletInfo.getSchemaHash()) {
                                    replica.setSchemaHash(backendTabletInfo.getSchemaHash());
                                }
                                if (this.needRecover(replica, tabletMeta.getOldSchemaHash(), backendTabletInfo)) {
                                    LOG.warn("replica {} of tablet {} on backend {} need recovery. replica in FE: {}, report version {}, report schema hash: {}, is bad: {}, is version missing: {}", (Object)replica.getId(), (Object)tabletId, (Object)backendId, (Object)replica, (Object)backendTabletInfo.getVersion(), (Object)backendTabletInfo.getSchemaHash(), backendTabletInfo.isSetUsed() ? Boolean.valueOf(!backendTabletInfo.isUsed()) : "false", backendTabletInfo.isSetVersionMiss() ? Boolean.valueOf(backendTabletInfo.isVersionMiss()) : "unset");
                                    list = tabletRecoveryMap;
                                    synchronized (list) {
                                        tabletRecoveryMap.put((Object)tabletMeta.getDbId(), (Object)tabletId);
                                    }
                                }
                                long partitionId = tabletMeta.getPartitionId();
                                if (!Config.disable_storage_medium_check && (storageMedium = (TStorageMedium)storageMediumMap.get(partitionId)) != null && backendTabletInfo.isSetStorageMedium()) {
                                    if (storageMedium != backendTabletInfo.getStorageMedium()) {
                                        ListMultimap listMultimap = tabletMigrationMap;
                                        synchronized (listMultimap) {
                                            tabletMigrationMap.put((Object)storageMedium, (Object)tabletId);
                                        }
                                    }
                                    if (storageMedium != tabletMeta.getStorageMedium()) {
                                        tabletMeta.setStorageMedium(storageMedium);
                                    }
                                }
                                if (backendTabletInfo.isSetTransactionIds()) {
                                    List transactionIds = backendTabletInfo.getTransactionIds();
                                    GlobalTransactionMgr transactionMgr = Catalog.getCurrentGlobalTransactionMgr();
                                    for (Long transactionId : transactionIds) {
                                        TableCommitInfo tableCommitInfo;
                                        PartitionCommitInfo partitionCommitInfo;
                                        TransactionState transactionState = transactionMgr.getTransactionState(tabletMeta.getDbId(), transactionId);
                                        if (transactionState == null || transactionState.getTransactionStatus() == TransactionStatus.ABORTED) {
                                            ListMultimap listMultimap = transactionsToClear;
                                            synchronized (listMultimap) {
                                                transactionsToClear.put((Object)transactionId, (Object)tabletMeta.getPartitionId());
                                            }
                                            LOG.debug("transaction id [{}] is not valid any more, clear it from backend [{}]", (Object)transactionId, (Object)backendId);
                                            continue;
                                        }
                                        if (transactionState.getTransactionStatus() != TransactionStatus.VISIBLE || (partitionCommitInfo = (tableCommitInfo = transactionState.getTableCommitInfo(tabletMeta.getTableId())) == null ? null : tableCommitInfo.getPartitionCommitInfo(partitionId)) == null) continue;
                                        TPartitionVersionInfo versionInfo = new TPartitionVersionInfo(tabletMeta.getPartitionId(), partitionCommitInfo.getVersion(), 0L);
                                        Map map = transactionsToPublish;
                                        synchronized (map) {
                                            ListMultimap map2 = (ListMultimap)transactionsToPublish.get(transactionState.getDbId());
                                            if (map2 == null) {
                                                map2 = ArrayListMultimap.create();
                                                transactionsToPublish.put(transactionState.getDbId(), map2);
                                            }
                                            map2.put((Object)transactionId, (Object)versionInfo);
                                        }
                                    }
                                }
                                if (!backendTabletInfo.isSetVersionCount()) continue;
                                replica.setVersionCount(backendTabletInfo.getVersionCount());
                                continue;
                            }
                            foundTabletsWithInvalidSchema.put(tabletId, backendTabletInfo);
                        }
                    } else {
                        LOG.debug("backend[{}] does not report tablet[{}-{}]", (Object)backendId, (Object)tabletId, (Object)tabletMeta);
                        ListMultimap listMultimap = tabletDeleteFromMeta;
                        synchronized (listMultimap) {
                            tabletDeleteFromMeta.put((Object)tabletMeta.getDbId(), (Object)tabletId);
                        }
                    }
                });
            }
        }
        finally {
            this.readUnlock();
        }
        long end = System.currentTimeMillis();
        LOG.info("finished to do tablet diff with backend[{}]. sync: {}. metaDel: {}. foundValid: {}. foundInvalid: {}. migration: {}. found invalid transactions {}. found republish transactions {}. tabletInMemorySync: {}. need recovery: {}. cost: {} ms", new Object[]{backendId, tabletSyncMap.size(), tabletDeleteFromMeta.size(), foundTabletsWithValidSchema.size(), foundTabletsWithInvalidSchema.size(), tabletMigrationMap.size(), transactionsToClear.size(), transactionsToPublish.size(), tabletToInMemory.size(), tabletRecoveryMap.size(), end - start});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTabletIdByReplica(long replicaId) {
        this.readLock();
        try {
            Long l = this.replicaToTabletMap.get(replicaId);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabletMeta getTabletMeta(long tabletId) {
        this.readLock();
        try {
            TabletMeta tabletMeta = this.tabletMetaMap.get(tabletId);
            return tabletMeta;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TabletMeta> getTabletMetaList(List<Long> tabletIdList) {
        ArrayList<TabletMeta> tabletMetaList = new ArrayList<TabletMeta>(tabletIdList.size());
        this.readLock();
        try {
            for (Long tabletId : tabletIdList) {
                tabletMetaList.add(this.tabletMetaMap.getOrDefault(tabletId, NOT_EXIST_TABLET_META));
            }
            ArrayList<TabletMeta> arrayList = tabletMetaList;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private boolean needSync(Replica replicaInFe, TTabletInfo backendTabletInfo) {
        if (backendTabletInfo.isSetUsed() && !backendTabletInfo.isUsed()) {
            return false;
        }
        if (replicaInFe.getState() == Replica.ReplicaState.ALTER) {
            return false;
        }
        long versionInFe = replicaInFe.getVersion();
        if (backendTabletInfo.getVersion() > versionInFe) {
            return true;
        }
        return versionInFe == backendTabletInfo.getVersion() && replicaInFe.isBad();
    }

    private boolean needRecover(Replica replicaInFe, int schemaHashInFe, TTabletInfo backendTabletInfo) {
        if (replicaInFe.getState() != Replica.ReplicaState.NORMAL) {
            return false;
        }
        if (backendTabletInfo.isSetUsed() && !backendTabletInfo.isUsed()) {
            return true;
        }
        if (schemaHashInFe != backendTabletInfo.getSchemaHash() || backendTabletInfo.getVersion() == -1L) {
            return false;
        }
        return backendTabletInfo.isSetVersionMiss() && backendTabletInfo.isVersionMiss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTablet(long tabletId, TabletMeta tabletMeta) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.writeLock();
        try {
            if (this.tabletMetaMap.containsKey(tabletId)) {
                return;
            }
            this.tabletMetaMap.put(tabletId, tabletMeta);
            if (!this.tabletMetaTable.contains((Object)tabletMeta.getPartitionId(), (Object)tabletMeta.getIndexId())) {
                this.tabletMetaTable.put((Object)tabletMeta.getPartitionId(), (Object)tabletMeta.getIndexId(), (Object)tabletMeta);
                LOG.debug("add tablet meta: {}", (Object)tabletId);
            }
            LOG.debug("add tablet: {}", (Object)tabletId);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTablet(long tabletId) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.writeLock();
        try {
            TabletMeta tabletMeta;
            Map replicas = (Map)this.replicaMetaTable.rowMap().remove(tabletId);
            if (replicas != null) {
                for (Replica replica : replicas.values()) {
                    this.replicaToTabletMap.remove(replica.getId());
                }
                Iterator<Object> iterator = replicas.keySet().iterator();
                while (iterator.hasNext()) {
                    long backendId = (Long)iterator.next();
                    this.backingReplicaMetaTable.remove((Object)backendId, (Object)tabletId);
                }
            }
            if ((tabletMeta = this.tabletMetaMap.remove(tabletId)) != null) {
                this.tabletMetaTable.remove((Object)tabletMeta.getPartitionId(), (Object)tabletMeta.getIndexId());
                LOG.debug("delete tablet meta: {}", (Object)tabletId);
            }
            LOG.debug("delete tablet: {}", (Object)tabletId);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplica(long tabletId, Replica replica) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.writeLock();
        try {
            Preconditions.checkState((boolean)this.tabletMetaMap.containsKey(tabletId));
            this.replicaMetaTable.put((Object)tabletId, (Object)replica.getBackendId(), (Object)replica);
            this.replicaToTabletMap.put(replica.getId(), tabletId);
            this.backingReplicaMetaTable.put((Object)replica.getBackendId(), (Object)tabletId, (Object)replica);
            LOG.debug("add replica {} of tablet {} in backend {}", (Object)replica.getId(), (Object)tabletId, (Object)replica.getBackendId());
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReplica(long tabletId, long backendId) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.writeLock();
        try {
            Preconditions.checkState((boolean)this.tabletMetaMap.containsKey(tabletId));
            if (this.replicaMetaTable.containsRow((Object)tabletId)) {
                Replica replica = (Replica)this.replicaMetaTable.remove((Object)tabletId, (Object)backendId);
                this.replicaToTabletMap.remove(replica.getId());
                this.replicaMetaTable.remove((Object)tabletId, (Object)backendId);
                this.backingReplicaMetaTable.remove((Object)backendId, (Object)tabletId);
                LOG.debug("delete replica {} of tablet {} in backend {}", (Object)replica.getId(), (Object)tabletId, (Object)backendId);
            } else {
                LOG.error("tablet[{}] contains no replica in inverted index", (Object)tabletId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Replica getReplica(long tabletId, long backendId) {
        this.readLock();
        try {
            Preconditions.checkState((boolean)this.tabletMetaMap.containsKey(tabletId), (Object)tabletId);
            Replica replica = (Replica)this.replicaMetaTable.get((Object)tabletId, (Object)backendId);
            return replica;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Replica> getReplicasByTabletId(long tabletId) {
        this.readLock();
        try {
            if (this.replicaMetaTable.containsRow((Object)tabletId)) {
                ArrayList arrayList = Lists.newArrayList(this.replicaMetaTable.row((Object)tabletId).values());
                return arrayList;
            }
            ArrayList arrayList = Lists.newArrayList();
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewSchemaHash(long partitionId, long indexId, int newSchemaHash) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.readLock();
        try {
            Preconditions.checkState((boolean)this.tabletMetaTable.contains((Object)partitionId, (Object)indexId));
            ((TabletMeta)this.tabletMetaTable.get((Object)partitionId, (Object)indexId)).setNewSchemaHash(newSchemaHash);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToNewSchemaHash(long partitionId, long indexId) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.readLock();
        try {
            Preconditions.checkState((boolean)this.tabletMetaTable.contains((Object)partitionId, (Object)indexId));
            ((TabletMeta)this.tabletMetaTable.get((Object)partitionId, (Object)indexId)).updateToNewSchemaHash();
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNewSchemaHash(long partitionId, long indexId) {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        this.readLock();
        try {
            TabletMeta tabletMeta = (TabletMeta)this.tabletMetaTable.get((Object)partitionId, (Object)indexId);
            if (tabletMeta != null) {
                tabletMeta.deleteNewSchemaHash();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getTabletIdsByBackendId(long backendId) {
        ArrayList tabletIds = Lists.newArrayList();
        this.readLock();
        try {
            Map replicaMetaWithBackend = this.backingReplicaMetaTable.row((Object)backendId);
            if (replicaMetaWithBackend != null) {
                tabletIds.addAll(replicaMetaWithBackend.keySet());
            }
        }
        finally {
            this.readUnlock();
        }
        return tabletIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getTabletIdsByBackendIdAndStorageMedium(long backendId, TStorageMedium storageMedium) {
        List<Object> tabletIds = Lists.newArrayList();
        this.readLock();
        try {
            Map replicaMetaWithBackend = this.backingReplicaMetaTable.row((Object)backendId);
            if (replicaMetaWithBackend != null) {
                tabletIds = replicaMetaWithBackend.keySet().stream().filter(id -> this.tabletMetaMap.get(id).getStorageMedium() == storageMedium).collect(Collectors.toList());
            }
        }
        finally {
            this.readUnlock();
        }
        return tabletIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTabletNumByBackendId(long backendId) {
        this.readLock();
        try {
            Map replicaMetaWithBackend = this.backingReplicaMetaTable.row((Object)backendId);
            if (replicaMetaWithBackend != null) {
                int n = replicaMetaWithBackend.size();
                return n;
            }
        }
        finally {
            this.readUnlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TStorageMedium, Long> getReplicaNumByBeIdAndStorageMedium(long backendId) {
        HashMap replicaNumMap = Maps.newHashMap();
        long hddNum = 0L;
        long ssdNum = 0L;
        this.readLock();
        try {
            Map replicaMetaWithBackend = this.backingReplicaMetaTable.row((Object)backendId);
            if (replicaMetaWithBackend != null) {
                Iterator iterator = replicaMetaWithBackend.keySet().iterator();
                while (iterator.hasNext()) {
                    long tabletId = (Long)iterator.next();
                    if (this.tabletMetaMap.get(tabletId).getStorageMedium() == TStorageMedium.HDD) {
                        ++hddNum;
                        continue;
                    }
                    ++ssdNum;
                }
            }
        }
        finally {
            this.readUnlock();
        }
        replicaNumMap.put(TStorageMedium.HDD, hddNum);
        replicaNumMap.put(TStorageMedium.SSD, ssdNum);
        return replicaNumMap;
    }

    public void clear() {
        this.writeLock();
        try {
            this.tabletMetaMap.clear();
            this.replicaToTabletMap.clear();
            this.tabletMetaTable.clear();
            this.replicaMetaTable.clear();
            this.backingReplicaMetaTable.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setPartitionIdInMemorySet(ImmutableSet<Long> partitionIdInMemorySet) {
        this.partitionIdInMemorySet = partitionIdInMemorySet;
    }

    public Map<Long, Long> getReplicaToTabletMap() {
        return this.replicaToTabletMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TStorageMedium, TreeMultimap<Long, PartitionBalanceInfo>> buildPartitionInfoBySkew(List<Long> availableBeIds) {
        this.readLock();
        HashMap partitionReplicasInfoMaps = Maps.newHashMap();
        for (TStorageMedium medium : TStorageMedium.values()) {
            partitionReplicasInfoMaps.put(medium, HashBasedTable.create());
        }
        try {
            Set cells = this.replicaMetaTable.cellSet();
            for (Table.Cell cell : cells) {
                Long tabletId = (Long)cell.getRowKey();
                Long beId = (Long)cell.getColumnKey();
                try {
                    Preconditions.checkState((boolean)availableBeIds.contains(beId), (Object)("dead be " + beId));
                    TabletMeta tabletMeta = this.tabletMetaMap.get(tabletId);
                    Preconditions.checkNotNull((Object)tabletMeta, (Object)("invalid tablet " + tabletId));
                    Preconditions.checkState((!Catalog.getCurrentColocateIndex().isColocateTable(tabletMeta.getTableId()) ? 1 : 0) != 0, (Object)"should not be the colocate table");
                    TStorageMedium medium = tabletMeta.getStorageMedium();
                    Table partitionReplicasInfo = (Table)partitionReplicasInfoMaps.get(medium);
                    Map<Long, Long> countMap = (Map<Long, Long>)partitionReplicasInfo.get((Object)tabletMeta.getPartitionId(), (Object)tabletMeta.getIndexId());
                    if (countMap == null) {
                        countMap = availableBeIds.stream().collect(Collectors.toMap(i -> i, i -> 0L));
                    }
                    Long count = (Long)countMap.get(beId);
                    countMap.put(beId, count + 1L);
                    partitionReplicasInfo.put((Object)tabletMeta.getPartitionId(), (Object)tabletMeta.getIndexId(), countMap);
                    partitionReplicasInfoMaps.put(medium, partitionReplicasInfo);
                }
                catch (IllegalStateException | NullPointerException e) {
                    LOG.debug(e.getMessage());
                }
            }
        }
        finally {
            this.readUnlock();
        }
        HashMap skewMaps = Maps.newHashMap();
        for (TStorageMedium medium : TStorageMedium.values()) {
            TreeMultimap partitionInfoBySkew = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.arbitrary());
            Set mapCells = ((Table)partitionReplicasInfoMaps.getOrDefault(medium, HashBasedTable.create())).cellSet();
            for (Table.Cell cell : mapCells) {
                Map countMap = (Map)cell.getValue();
                Preconditions.checkNotNull((Object)countMap);
                PartitionBalanceInfo pbi = new PartitionBalanceInfo((Long)cell.getRowKey(), (Long)cell.getColumnKey());
                for (Map.Entry entry : countMap.entrySet()) {
                    Long beID = (Long)entry.getKey();
                    Long replicaCount = (Long)entry.getValue();
                    pbi.beByReplicaCount.put((Object)replicaCount, (Object)beID);
                }
                long minCount = (Long)pbi.beByReplicaCount.keySet().first();
                long maxCount = (Long)pbi.beByReplicaCount.keySet().last();
                partitionInfoBySkew.put((Object)(maxCount - minCount), (Object)pbi);
            }
            skewMaps.put(medium, partitionInfoBySkew);
        }
        return skewMaps;
    }

    public Table<Long, Long, Replica> getReplicaMetaTable() {
        return this.replicaMetaTable;
    }

    public Table<Long, Long, Replica> getBackingReplicaMetaTable() {
        return this.backingReplicaMetaTable;
    }

    public Table<Long, Long, TabletMeta> getTabletMetaTable() {
        return this.tabletMetaTable;
    }

    public Map<Long, TabletMeta> getTabletMetaMap() {
        return this.tabletMetaMap;
    }

    public static class PartitionBalanceInfo {
        public Long partitionId;
        public Long indexId;
        public TreeMultimap<Long, Long> beByReplicaCount = TreeMultimap.create();

        public PartitionBalanceInfo(Long partitionId, Long indexId) {
            this.partitionId = partitionId;
            this.indexId = indexId;
        }

        public PartitionBalanceInfo(PartitionBalanceInfo info) {
            this.partitionId = info.partitionId;
            this.indexId = info.indexId;
            this.beByReplicaCount = TreeMultimap.create(info.beByReplicaCount);
        }
    }
}

