/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.analysis.DataSortInfo;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.DynamicPartitionProperty;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.thrift.TCompressionType;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TableProperty
implements Writable {
    private static final Logger LOG = LogManager.getLogger(TableProperty.class);
    public static final String DYNAMIC_PARTITION_PROPERTY_PREFIX = "dynamic_partition";
    @SerializedName(value="properties")
    private Map<String, String> properties;
    private DynamicPartitionProperty dynamicPartitionProperty = new DynamicPartitionProperty(Maps.newHashMap());
    private ReplicaAllocation replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
    private boolean isInMemory = false;
    private TStorageFormat storageFormat = TStorageFormat.DEFAULT;
    private TCompressionType compressionType = TCompressionType.LZ4F;
    private DataSortInfo dataSortInfo = new DataSortInfo();

    public TableProperty(Map<String, String> properties) {
        this.properties = properties;
    }

    public static boolean isSamePrefixProperties(Map<String, String> properties, String prefix) {
        for (String value : properties.keySet()) {
            if (value.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public TableProperty buildProperty(short opCode) {
        switch (opCode) {
            case 261: {
                this.executeBuildDynamicProperty();
                break;
            }
            case 266: {
                this.buildReplicaAllocation();
                break;
            }
            case 267: {
                this.buildInMemory();
                break;
            }
        }
        return this;
    }

    public TableProperty resetPropertiesForRestore() {
        if (this.properties.containsKey("dynamic_partition.enable")) {
            this.properties.put("dynamic_partition.enable", "false");
            this.executeBuildDynamicProperty();
        }
        return this;
    }

    public TableProperty buildDynamicProperty() {
        this.executeBuildDynamicProperty();
        return this;
    }

    private TableProperty executeBuildDynamicProperty() {
        HashMap<String, String> dynamicPartitionProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(DYNAMIC_PARTITION_PROPERTY_PREFIX)) continue;
            dynamicPartitionProperties.put(entry.getKey(), entry.getValue());
        }
        this.dynamicPartitionProperty = new DynamicPartitionProperty(dynamicPartitionProperties);
        return this;
    }

    public TableProperty buildInMemory() {
        this.isInMemory = Boolean.parseBoolean(this.properties.getOrDefault("in_memory", "false"));
        return this;
    }

    public TableProperty buildDataSortInfo() {
        HashMap<String, String> dataSortInfoProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith("data_sort")) continue;
            dataSortInfoProperties.put(entry.getKey(), entry.getValue());
        }
        this.dataSortInfo = new DataSortInfo(dataSortInfoProperties);
        return this;
    }

    public TableProperty buildCompressionType() {
        this.compressionType = TCompressionType.valueOf((String)this.properties.getOrDefault("compression", TCompressionType.LZ4F.name()));
        return this;
    }

    public TableProperty buildStorageFormat() {
        this.storageFormat = TStorageFormat.valueOf((String)this.properties.getOrDefault("storage_format", TStorageFormat.DEFAULT.name()));
        return this;
    }

    public void modifyTableProperties(Map<String, String> modifyProperties) {
        this.properties.putAll(modifyProperties);
        this.removeDuplicateReplicaNumProperty();
    }

    public void modifyDataSortInfoProperties(DataSortInfo dataSortInfo) {
        this.properties.put("data_sort.sort_type", String.valueOf(dataSortInfo.getSortType()));
        this.properties.put("data_sort.col_num", String.valueOf(dataSortInfo.getColNum()));
    }

    public void setReplicaAlloc(ReplicaAllocation replicaAlloc) {
        this.replicaAlloc = replicaAlloc;
        this.properties.put("default.replication_allocation", replicaAlloc.toCreateStmt());
    }

    public ReplicaAllocation getReplicaAllocation() {
        return this.replicaAlloc;
    }

    public void modifyTableProperties(String key, String value) {
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DynamicPartitionProperty getDynamicPartitionProperty() {
        return this.dynamicPartitionProperty;
    }

    public Map<String, String> getOriginDynamicPartitionProperty() {
        HashMap origProp = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith("dynamic_partition.")) continue;
            origProp.put(entry.getKey(), entry.getValue());
        }
        return origProp;
    }

    public boolean isInMemory() {
        return this.isInMemory;
    }

    public TStorageFormat getStorageFormat() {
        if (TStorageFormat.V1 == this.storageFormat) {
            return TStorageFormat.V2;
        }
        return this.storageFormat;
    }

    public DataSortInfo getDataSortInfo() {
        return this.dataSortInfo;
    }

    public TCompressionType getCompressionType() {
        return this.compressionType;
    }

    public void buildReplicaAllocation() {
        try {
            HashMap copiedProperties = Maps.newHashMap(this.properties);
            this.replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(copiedProperties, "default");
        }
        catch (AnalysisException e) {
            LOG.error("should not happen when build replica allocation", (Throwable)e);
            this.replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static TableProperty read(DataInput in) throws IOException {
        TableProperty tableProperty = ((TableProperty)GsonUtils.GSON.fromJson(Text.readString((DataInput)in), TableProperty.class)).executeBuildDynamicProperty().buildInMemory().buildStorageFormat().buildDataSortInfo().buildCompressionType();
        if (Catalog.getCurrentCatalogJournalVersion() < 105) {
            String repNum = tableProperty.properties.remove("replication_num");
            if (!Strings.isNullOrEmpty((String)repNum)) {
                ReplicaAllocation replicaAlloc = new ReplicaAllocation(Short.valueOf(repNum));
                tableProperty.properties.put("default.replication_allocation", replicaAlloc.toCreateStmt());
            } else {
                tableProperty.properties.put("default.replication_allocation", ReplicaAllocation.DEFAULT_ALLOCATION.toCreateStmt());
            }
        }
        tableProperty.removeDuplicateReplicaNumProperty();
        tableProperty.buildReplicaAllocation();
        return tableProperty;
    }

    private void removeDuplicateReplicaNumProperty() {
        if (this.properties.containsKey("dynamic_partition.replication_num") && this.properties.containsKey("dynamic_partition.replication_allocation")) {
            this.properties.remove("dynamic_partition.replication_num");
        }
    }
}

