/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Index;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class TableIndexes
implements Writable {
    @SerializedName(value="indexes")
    private List<Index> indexes;
    @SerializedName(value="properties")
    private Map<String, String> properties;

    public TableIndexes() {
        this.indexes = Lists.newArrayList();
        this.properties = Maps.newHashMap();
    }

    public TableIndexes(List<Index> indexes) {
        this.indexes = indexes;
        this.properties = Maps.newHashMap();
    }

    public TableIndexes(List<Index> indexes, Map<String, String> properties) {
        this.indexes = indexes;
        this.properties = properties;
    }

    public List<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = Lists.newArrayList();
        }
        return this.indexes;
    }

    public List<Index> getCopiedIndexes() {
        if (this.indexes == null || this.indexes.size() == 0) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(this.indexes);
    }

    public void setIndexes(List<Index> indexes) {
        this.indexes = indexes;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        return this.properties;
    }

    public Map<String, String> getCopiedProperties() {
        if (this.properties == null || this.properties.size() == 0) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.properties);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static TableIndexes read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (TableIndexes)GsonUtils.GSON.fromJson(json, TableIndexes.class);
    }
}

