/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.alter.AlterCancelException;
import org.apache.doris.analysis.CreateTableStmt;
import org.apache.doris.catalog.BrokerTable;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.HiveTable;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.catalog.MetaObject;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.View;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SqlUtils;
import org.apache.doris.common.util.Util;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Table
extends MetaObject
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Table.class);
    public static final long TRY_LOCK_TIMEOUT_MS = 100L;
    public volatile boolean isDropped = false;
    protected long id;
    protected volatile String name;
    protected TableType type;
    protected long createTime;
    protected ReentrantReadWriteLock rwLock;
    protected List<Column> fullSchema;
    protected Map<String, Column> nameToColumn;
    protected boolean isTypeRead = false;
    protected String comment = "";
    protected String ddlSql = "";

    public Table(TableType type) {
        this.type = type;
        this.fullSchema = Lists.newArrayList();
        this.nameToColumn = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.rwLock = new ReentrantReadWriteLock(true);
    }

    public Table(long id, String tableName, TableType type, List<Column> fullSchema) {
        this.id = id;
        this.name = tableName;
        this.type = type;
        if (fullSchema != null) {
            this.fullSchema = Lists.newArrayList(fullSchema);
        }
        this.nameToColumn = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        if (this.fullSchema != null) {
            for (Column col : this.fullSchema) {
                this.nameToColumn.put(col.getName(), col);
            }
        } else {
            Preconditions.checkArgument((type == TableType.VIEW ? 1 : 0) != 0, (Object)"Table has no columns");
        }
        this.rwLock = new ReentrantReadWriteLock();
        this.createTime = Instant.now().getEpochSecond();
    }

    public void markDropped() {
        this.isDropped = true;
    }

    public void unmarkDropped() {
        this.isDropped = false;
    }

    public void readLock() {
        this.rwLock.readLock().lock();
    }

    public boolean tryReadLock(long timeout, TimeUnit unit) {
        try {
            return this.rwLock.readLock().tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            LOG.warn("failed to try read lock at table[" + this.name + "]", (Throwable)e);
            return false;
        }
    }

    public void readUnlock() {
        this.rwLock.readLock().unlock();
    }

    public void writeLock() {
        this.rwLock.writeLock().lock();
    }

    public boolean writeLockIfExist() {
        this.rwLock.writeLock().lock();
        if (this.isDropped) {
            this.rwLock.writeLock().unlock();
            return false;
        }
        return true;
    }

    public boolean tryWriteLock(long timeout, TimeUnit unit) {
        try {
            return this.rwLock.writeLock().tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            LOG.warn("failed to try write lock at table[" + this.name + "]", (Throwable)e);
            return false;
        }
    }

    public void writeUnlock() {
        this.rwLock.writeLock().unlock();
    }

    public boolean isWriteLockHeldByCurrentThread() {
        return this.rwLock.writeLock().isHeldByCurrentThread();
    }

    public <E extends Exception> void writeLockOrException(E e) throws E {
        this.writeLock();
        if (this.isDropped) {
            this.writeUnlock();
            throw e;
        }
    }

    public void writeLockOrDdlException() throws DdlException {
        this.writeLockOrException(new DdlException("unknown table, tableName=" + this.name));
    }

    public void writeLockOrMetaException() throws MetaNotFoundException {
        this.writeLockOrException(new MetaNotFoundException("unknown table, tableName=" + this.name));
    }

    public void writeLockOrAlterCancelException() throws AlterCancelException {
        this.writeLockOrException(new AlterCancelException("unknown table, tableName=" + this.name));
    }

    public boolean tryWriteLockOrMetaException(long timeout, TimeUnit unit) throws MetaNotFoundException {
        return this.tryWriteLockOrException(timeout, unit, new MetaNotFoundException("unknown table, tableName=" + this.name));
    }

    public <E extends Exception> boolean tryWriteLockOrException(long timeout, TimeUnit unit, E e) throws E {
        if (this.tryWriteLock(timeout, unit)) {
            if (this.isDropped) {
                this.writeUnlock();
                throw e;
            }
            return true;
        }
        return false;
    }

    public boolean tryWriteLockIfExist(long timeout, TimeUnit unit) {
        if (this.tryWriteLock(timeout, unit)) {
            if (this.isDropped) {
                this.writeUnlock();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isTypeRead() {
        return this.isTypeRead;
    }

    public void setTypeRead(boolean isTypeRead) {
        this.isTypeRead = isTypeRead;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public TableType getType() {
        return this.type;
    }

    public List<Column> getFullSchema() {
        return this.fullSchema;
    }

    public String getDdlSql() {
        return this.ddlSql;
    }

    public List<Column> getBaseSchema() {
        return this.getBaseSchema(Util.showHiddenColumns());
    }

    public List<Column> getBaseSchema(boolean full) {
        if (full) {
            return this.fullSchema;
        }
        return this.fullSchema.stream().filter(column -> column.isVisible()).collect(Collectors.toList());
    }

    public void setNewFullSchema(List<Column> newSchema) {
        this.fullSchema = newSchema;
        this.nameToColumn.clear();
        for (Column col : this.fullSchema) {
            this.nameToColumn.put(col.getName(), col);
        }
    }

    public Column getColumn(String name) {
        return this.nameToColumn.get(name);
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return -1L;
    }

    public long getRowCount() {
        return 0L;
    }

    public long getAvgRowLength() {
        return 0L;
    }

    public long getDataLength() {
        return 0L;
    }

    public TTableDescriptor toThrift() {
        return null;
    }

    public static Table read(DataInput in) throws IOException {
        Table table = null;
        TableType type = TableType.valueOf(Text.readString((DataInput)in));
        if (type == TableType.OLAP) {
            table = new OlapTable();
        } else if (type == TableType.ODBC) {
            table = new OdbcTable();
        } else if (type == TableType.MYSQL) {
            table = new MysqlTable();
        } else if (type == TableType.VIEW) {
            table = new View();
        } else if (type == TableType.BROKER) {
            table = new BrokerTable();
        } else if (type == TableType.ELASTICSEARCH) {
            table = new EsTable();
        } else if (type == TableType.HIVE) {
            table = new HiveTable();
        } else if (type == TableType.ICEBERG) {
            table = new IcebergTable();
        } else {
            throw new IOException("Unknown table type: " + type.name());
        }
        table.setTypeRead(true);
        ((Table)table).readFields(in);
        return table;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.type.name());
        super.write(out);
        out.writeLong(this.id);
        Text.writeString((DataOutput)out, (String)this.name);
        int columnCount = this.fullSchema.size();
        out.writeInt(columnCount);
        for (Column column : this.fullSchema) {
            column.write(out);
        }
        Text.writeString((DataOutput)out, (String)this.comment);
        out.writeLong(this.createTime);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        if (!this.isTypeRead) {
            this.type = TableType.valueOf(Text.readString((DataInput)in));
            this.isTypeRead = true;
        }
        super.readFields(in);
        this.id = in.readLong();
        this.name = Text.readString((DataInput)in);
        int columnCount = in.readInt();
        for (int i = 0; i < columnCount; ++i) {
            Column column = Column.read(in);
            this.fullSchema.add(column);
            this.nameToColumn.put(column.getName(), column);
        }
        this.comment = Text.readString((DataInput)in);
        this.createTime = in.readLong();
    }

    public boolean equals(Table table) {
        return true;
    }

    public boolean isPartitioned() {
        return false;
    }

    public Partition getPartition(String partitionName) {
        return null;
    }

    public String getEngine() {
        switch (this.type) {
            case MYSQL: {
                return "MySQL";
            }
            case ODBC: {
                return "Odbc";
            }
            case OLAP: {
                return "Doris";
            }
            case SCHEMA: {
                return "MEMORY";
            }
            case INLINE_VIEW: {
                return "InlineView";
            }
            case VIEW: {
                return "View";
            }
            case BROKER: {
                return "Broker";
            }
            case ELASTICSEARCH: {
                return "ElasticSearch";
            }
            case HIVE: {
                return "Hive";
            }
        }
        return null;
    }

    public String getMysqlType() {
        switch (this.type) {
            case OLAP: {
                return "BASE TABLE";
            }
            case SCHEMA: {
                return "SYSTEM VIEW";
            }
            case INLINE_VIEW: 
            case VIEW: {
                return "VIEW";
            }
            case MYSQL: 
            case ODBC: 
            case BROKER: 
            case ELASTICSEARCH: 
            case HIVE: {
                return "EXTERNAL TABLE";
            }
        }
        return null;
    }

    public String getComment() {
        return this.getComment(false);
    }

    public String getComment(boolean escapeQuota) {
        if (!Strings.isNullOrEmpty((String)this.comment)) {
            if (!escapeQuota) {
                return this.comment;
            }
            return SqlUtils.escapeQuota(this.comment);
        }
        return this.type.name();
    }

    public void setComment(String comment) {
        this.comment = Strings.nullToEmpty((String)comment);
    }

    public CreateTableStmt toCreateTableStmt(String dbName) {
        throw new NotImplementedException();
    }

    public String toString() {
        return "Table [id=" + this.id + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + "]";
    }

    public boolean needSchedule() {
        if (this.type != TableType.OLAP) {
            return false;
        }
        OlapTable olapTable = (OlapTable)this;
        if (Catalog.getCurrentColocateIndex().isColocateTable(olapTable.getId())) {
            LOG.debug("table {} is a colocate table, skip tablet checker.", (Object)this.name);
            return false;
        }
        return true;
    }

    public static enum TableType {
        MYSQL,
        ODBC,
        OLAP,
        SCHEMA,
        INLINE_VIEW,
        VIEW,
        BROKER,
        ELASTICSEARCH,
        HIVE,
        ICEBERG;

    }
}

