/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;

public class StructType
extends Type {
    private final HashMap<String, StructField> fieldMap = Maps.newHashMap();
    private final ArrayList<StructField> fields;

    public StructType(ArrayList<StructField> fields) {
        Preconditions.checkNotNull(fields);
        this.fields = fields;
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).setPosition(i);
            this.fieldMap.put(this.fields.get(i).getName().toLowerCase(), this.fields.get(i));
        }
    }

    public StructType() {
        this.fields = Lists.newArrayList();
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "STRUCT<...>";
        }
        ArrayList fieldsSql = Lists.newArrayList();
        for (StructField f : this.fields) {
            fieldsSql.add(f.toSql(depth + 1));
        }
        return String.format("STRUCT<%s>", Joiner.on((String)",").join((Iterable)fieldsSql));
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        ArrayList fieldsSql = Lists.newArrayList();
        for (StructField f : this.fields) {
            fieldsSql.add(f.prettyPrint(lpad + 2));
        }
        return String.format("%sSTRUCT<\n%s\n%s>", leftPadding, Joiner.on((String)",\n").join((Iterable)fieldsSql), leftPadding);
    }

    public void addField(StructField field) {
        field.setPosition(this.fields.size());
        this.fields.add(field);
        this.fieldMap.put(field.getName().toLowerCase(), field);
    }

    public ArrayList<StructField> getFields() {
        return this.fields;
    }

    public StructField getField(String fieldName) {
        return this.fieldMap.get(fieldName.toLowerCase());
    }

    public void clearFields() {
        this.fields.clear();
        this.fieldMap.clear();
    }

    public boolean equals(Object other) {
        if (!(other instanceof StructType)) {
            return false;
        }
        StructType otherStructType = (StructType)other;
        return otherStructType.getFields().equals(this.fields);
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull(this.fields);
        Preconditions.checkNotNull((Object)(!this.fields.isEmpty() ? 1 : 0));
        node.setType(TTypeNodeType.STRUCT);
        node.setStructFields(new ArrayList());
        for (StructField field : this.fields) {
            field.toThrift(container, node);
        }
    }

    public String toString() {
        return this.toSql(0);
    }
}

