/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TStructField;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;

public class StructField {
    protected final String name;
    protected final Type type;
    protected final String comment;
    protected int position;

    public StructField(String name, Type type, String comment) {
        this.name = name;
        this.type = type;
        this.comment = comment;
    }

    public StructField(String name, Type type) {
        this(name, type, null);
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String toSql(int depth) {
        String typeSql = depth < Type.MAX_NESTING_DEPTH ? this.type.toSql(depth) : "...";
        StringBuilder sb = new StringBuilder(this.name);
        if (this.type != null) {
            sb.append(":" + typeSql);
        }
        if (this.comment != null) {
            sb.append(String.format(" COMMENT '%s'", this.comment));
        }
        return sb.toString();
    }

    public String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        StringBuilder sb = new StringBuilder(leftPadding + this.name);
        if (this.type != null) {
            String typeStr = this.type.prettyPrint(lpad);
            typeStr = typeStr.substring(lpad);
            sb.append(":" + typeStr);
        }
        if (this.comment != null) {
            sb.append(String.format(" COMMENT '%s'", this.comment));
        }
        return sb.toString();
    }

    public void toThrift(TTypeDesc container, TTypeNode node) {
        TStructField field = new TStructField();
        field.setName(this.name);
        if (this.comment != null) {
            field.setComment(this.comment);
        }
        node.struct_fields.add(field);
        this.type.toThrift(container);
    }

    public boolean equals(Object other) {
        if (!(other instanceof StructField)) {
            return false;
        }
        StructField otherStructField = (StructField)other;
        return otherStructField.name.equals(this.name) && otherStructField.type.equals(this.type);
    }
}

