/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.ResourceDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Resource;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.load.loadv2.SparkRepository;
import org.apache.doris.load.loadv2.SparkYarnConfigFiles;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SparkResource
extends Resource {
    private static final Logger LOG = LogManager.getLogger(SparkResource.class);
    private static final String SPARK_MASTER = "spark.master";
    private static final String SPARK_SUBMIT_DEPLOY_MODE = "spark.submit.deployMode";
    private static final String WORKING_DIR = "working_dir";
    private static final String BROKER = "broker";
    private static final String YARN_MASTER = "yarn";
    private static final String SPARK_CONFIG_PREFIX = "spark.";
    private static final String BROKER_PROPERTY_PREFIX = "broker.";
    private static final String SPARK_HADOOP_CONFIG_PREFIX = "spark.hadoop.";
    private static final String SPARK_YARN_RESOURCE_MANAGER_ADDRESS = "spark.hadoop.yarn.resourcemanager.address";
    private static final String SPARK_FS_DEFAULT_FS = "spark.hadoop.fs.defaultFS";
    private static final String YARN_RESOURCE_MANAGER_ADDRESS = "yarn.resourcemanager.address";
    @SerializedName(value="sparkConfigs")
    private Map<String, String> sparkConfigs;
    @SerializedName(value="workingDir")
    private String workingDir;
    @SerializedName(value="broker")
    private String broker;
    @SerializedName(value="brokerProperties")
    private Map<String, String> brokerProperties;

    public SparkResource(String name) {
        this(name, Maps.newHashMap(), null, null, Maps.newHashMap());
    }

    public SparkResource(String name, Map<String, String> sparkConfigs, String workingDir, String broker, Map<String, String> brokerProperties) {
        super(name, Resource.ResourceType.SPARK);
        this.sparkConfigs = sparkConfigs;
        this.workingDir = workingDir;
        this.broker = broker;
        this.brokerProperties = brokerProperties;
    }

    public String getMaster() {
        return this.sparkConfigs.get(SPARK_MASTER);
    }

    public DeployMode getDeployMode() {
        return DeployMode.fromString(this.sparkConfigs.get(SPARK_SUBMIT_DEPLOY_MODE));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getBroker() {
        return this.broker;
    }

    public Map<String, String> getBrokerPropertiesWithoutPrefix() {
        HashMap properties = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.brokerProperties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(BROKER_PROPERTY_PREFIX)) continue;
            properties.put(key.substring(key.indexOf(".") + 1), entry.getValue());
        }
        return properties;
    }

    public Map<String, String> getSparkConfigs() {
        return this.sparkConfigs;
    }

    public Pair<String, String> getYarnResourcemanagerAddressPair() {
        return Pair.create(YARN_RESOURCE_MANAGER_ADDRESS, this.sparkConfigs.get(SPARK_YARN_RESOURCE_MANAGER_ADDRESS));
    }

    public SparkResource getCopiedResource() {
        return new SparkResource(this.name, Maps.newHashMap(this.sparkConfigs), this.workingDir, this.broker, this.brokerProperties);
    }

    public synchronized SparkRepository.SparkArchive prepareArchive() throws LoadException {
        String remoteRepositoryPath = this.workingDir + "/" + Catalog.getCurrentCatalog().getClusterId() + "/" + "__spark_repository__" + this.name;
        BrokerDesc brokerDesc = new BrokerDesc(this.broker, this.getBrokerPropertiesWithoutPrefix());
        SparkRepository repository = new SparkRepository(remoteRepositoryPath, brokerDesc);
        repository.prepare();
        SparkRepository.SparkArchive archive = repository.getCurrentArchive();
        Preconditions.checkState((archive.libraries.size() == 2 ? 1 : 0) != 0);
        SparkRepository.SparkLibrary dppLibrary = archive.getDppLibrary();
        SparkRepository.SparkLibrary spark2xLibrary = archive.getSpark2xLibrary();
        if (dppLibrary == null || spark2xLibrary == null) {
            throw new LoadException("failed to get libraries from remote archive");
        }
        return archive;
    }

    public synchronized String prepareYarnConfig() throws LoadException {
        SparkYarnConfigFiles yarnConfigFiles = new SparkYarnConfigFiles(this.name, this.getSparkHadoopConfig(this.sparkConfigs));
        yarnConfigFiles.prepare();
        return yarnConfigFiles.getConfigDir();
    }

    public String getYarnClientPath() throws LoadException {
        String yarnClientPath = Config.yarn_client_path;
        File file = new File(yarnClientPath);
        if (!file.exists() || !file.isFile()) {
            throw new LoadException("yarn client does not exist in path: " + yarnClientPath);
        }
        return yarnClientPath;
    }

    public boolean isYarnMaster() {
        return this.getMaster().equalsIgnoreCase(YARN_MASTER);
    }

    public void update(ResourceDesc resourceDesc) throws DdlException {
        Preconditions.checkState((boolean)this.name.equals(resourceDesc.getName()));
        Map<String, String> properties = resourceDesc.getProperties();
        if (properties == null) {
            return;
        }
        if (properties.containsKey(SPARK_MASTER)) {
            throw new DdlException("Cannot change spark master");
        }
        this.sparkConfigs.putAll(this.getSparkConfig(properties));
        if (properties.containsKey(WORKING_DIR)) {
            this.workingDir = properties.get(WORKING_DIR);
        }
        if (properties.containsKey(BROKER)) {
            this.broker = properties.get(BROKER);
        }
        this.brokerProperties.putAll(this.getBrokerProperties(properties));
    }

    @Override
    protected void setProperties(Map<String, String> properties) throws DdlException {
        Preconditions.checkState((properties != null ? 1 : 0) != 0);
        this.sparkConfigs = this.getSparkConfig(properties);
        if (this.getMaster() == null) {
            throw new DdlException("Missing spark.master in properties");
        }
        String deployModeStr = this.sparkConfigs.get(SPARK_SUBMIT_DEPLOY_MODE);
        if (deployModeStr != null) {
            DeployMode deployMode = DeployMode.fromString(deployModeStr);
            if (deployMode == null) {
                throw new DdlException("Unknown deploy mode: " + deployModeStr);
            }
        } else {
            throw new DdlException("Missing spark.submit.deployMode in properties");
        }
        if (!(this.sparkConfigs.containsKey(SPARK_YARN_RESOURCE_MANAGER_ADDRESS) && this.sparkConfigs.containsKey(SPARK_FS_DEFAULT_FS) || !this.isYarnMaster())) {
            throw new DdlException("Missing (spark.hadoop.yarn.resourcemanager.address and spark.hadoop.fs.defaultFS) in yarn master");
        }
        this.workingDir = properties.get(WORKING_DIR);
        this.broker = properties.get(BROKER);
        if (this.workingDir == null && this.broker != null || this.workingDir != null && this.broker == null) {
            throw new DdlException("working_dir and broker should be assigned at the same time");
        }
        if (this.broker != null && !Catalog.getCurrentCatalog().getBrokerMgr().containsBroker(this.broker)) {
            throw new DdlException("Unknown broker name(" + this.broker + ")");
        }
        this.brokerProperties = this.getBrokerProperties(properties);
    }

    private Map<String, String> getSparkConfig(Map<String, String> properties) {
        HashMap sparkConfig = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(SPARK_CONFIG_PREFIX)) continue;
            sparkConfig.put(entry.getKey(), entry.getValue());
        }
        return sparkConfig;
    }

    private Map<String, String> getSparkHadoopConfig(Map<String, String> properties) {
        HashMap sparkConfig = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(SPARK_HADOOP_CONFIG_PREFIX)) continue;
            sparkConfig.put(entry.getKey(), entry.getValue());
        }
        return sparkConfig;
    }

    private Map<String, String> getBrokerProperties(Map<String, String> properties) {
        HashMap brokerProperties = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(BROKER_PROPERTY_PREFIX)) continue;
            brokerProperties.put(entry.getKey(), entry.getValue());
        }
        return brokerProperties;
    }

    @Override
    protected void getProcNodeData(BaseProcResult result) {
        String lowerCaseType = this.type.name().toLowerCase();
        for (Map.Entry<String, String> entry : this.sparkConfigs.entrySet()) {
            result.addRow(Lists.newArrayList((Object[])new String[]{this.name, lowerCaseType, entry.getKey(), entry.getValue()}));
        }
        if (this.workingDir != null) {
            result.addRow(Lists.newArrayList((Object[])new String[]{this.name, lowerCaseType, WORKING_DIR, this.workingDir}));
        }
        if (this.broker != null) {
            result.addRow(Lists.newArrayList((Object[])new String[]{this.name, lowerCaseType, BROKER, this.broker}));
        }
        for (Map.Entry<String, String> entry : this.brokerProperties.entrySet()) {
            result.addRow(Lists.newArrayList((Object[])new String[]{this.name, lowerCaseType, entry.getKey(), entry.getValue()}));
        }
    }

    public static enum DeployMode {
        CLUSTER,
        CLIENT;


        public static DeployMode fromString(String deployMode) {
            for (DeployMode mode : DeployMode.values()) {
                if (!mode.name().equalsIgnoreCase(deployMode)) continue;
                return mode;
            }
            return null;
        }
    }
}

