/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.SchemaTableType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.SystemIdGenerator;
import org.apache.doris.thrift.TSchemaTable;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;

public class SchemaTable
extends Table {
    private static final int FN_REFLEN = 512;
    private static final int NAME_CHAR_LEN = 64;
    private static final int MY_CS_NAME_SIZE = 32;
    private static final int GRANTEE_len = 81;
    private static final int PRIVILEGE_TYPE_LEN = 64;
    private static final int IS_GRANTABLE_LEN = 3;
    private SchemaTableType schemaTableType;
    public static Map<String, Table> TABLE_MAP = ImmutableMap.builder().put((Object)"tables", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "tables", Table.TableType.SCHEMA, SchemaTable.builder().column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("TABLE_TYPE", ScalarType.createVarchar(64)).column("ENGINE", ScalarType.createVarchar(64)).column("VERSION", ScalarType.createType(PrimitiveType.BIGINT)).column("ROW_FORMAT", ScalarType.createVarchar(10)).column("TABLE_ROWS", ScalarType.createType(PrimitiveType.BIGINT)).column("AVG_ROW_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("DATA_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("MAX_DATA_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("INDEX_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("DATA_FREE", ScalarType.createType(PrimitiveType.BIGINT)).column("AUTO_INCREMENT", ScalarType.createType(PrimitiveType.BIGINT)).column("CREATE_TIME", ScalarType.createType(PrimitiveType.DATETIME)).column("UPDATE_TIME", ScalarType.createType(PrimitiveType.DATETIME)).column("CHECK_TIME", ScalarType.createType(PrimitiveType.DATETIME)).column("TABLE_COLLATION", ScalarType.createVarchar(32)).column("CHECKSUM", ScalarType.createType(PrimitiveType.BIGINT)).column("CREATE_OPTIONS", ScalarType.createVarchar(255)).column("TABLE_COMMENT", ScalarType.createVarchar(2048)).build())).put((Object)"table_privileges", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "table_privileges", Table.TableType.SCHEMA, SchemaTable.builder().column("GRANTEE", ScalarType.createVarchar(81)).column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("PRIVILEGE_TYPE", ScalarType.createVarchar(64)).column("IS_GRANTABLE", ScalarType.createVarchar(3)).build())).put((Object)"schema_privileges", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "schema_privileges", Table.TableType.SCHEMA, SchemaTable.builder().column("GRANTEE", ScalarType.createVarchar(81)).column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("PRIVILEGE_TYPE", ScalarType.createVarchar(64)).column("IS_GRANTABLE", ScalarType.createVarchar(3)).build())).put((Object)"user_privileges", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "user_privileges", Table.TableType.SCHEMA, SchemaTable.builder().column("GRANTEE", ScalarType.createVarchar(81)).column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("PRIVILEGE_TYPE", ScalarType.createVarchar(64)).column("IS_GRANTABLE", ScalarType.createVarchar(3)).build())).put((Object)"referential_constraints", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "referential_constraints", Table.TableType.SCHEMA, SchemaTable.builder().column("CONSTRAINT_CATALOG", ScalarType.createVarchar(64)).column("CONSTRAINT_SCHEMA", ScalarType.createVarchar(64)).column("CONSTRAINT_NAME", ScalarType.createVarchar(64)).column("UNIQUE_CONSTRAINT_CATALOG", ScalarType.createVarchar(64)).column("UNIQUE_CONSTRAINT_SCHEMA", ScalarType.createVarchar(64)).column("UNIQUE_CONSTRAINT_NAME", ScalarType.createVarchar(64)).column("MATCH_OPTION", ScalarType.createVarchar(64)).column("UPDATE_RULE", ScalarType.createVarchar(64)).column("DELETE_RULE", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("REFERENCED_TABLE_NAME", ScalarType.createVarchar(64)).build())).put((Object)"key_column_usage", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "key_column_usage", Table.TableType.SCHEMA, SchemaTable.builder().column("CONSTRAINT_CATALOG", ScalarType.createVarchar(64)).column("CONSTRAINT_SCHEMA", ScalarType.createVarchar(64)).column("CONSTRAINT_NAME", ScalarType.createVarchar(64)).column("TABLE_CATALOG", ScalarType.createVarchar(64)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("COLUMN_NAME", ScalarType.createVarchar(64)).column("ORDINAL_POSITION", ScalarType.createType(PrimitiveType.BIGINT)).column("POSITION_IN_UNIQUE_CONSTRAINT", ScalarType.createType(PrimitiveType.BIGINT)).column("REFERENCED_TABLE_SCHEMA", ScalarType.createVarchar(64)).column("REFERENCED_TABLE_NAME", ScalarType.createVarchar(64)).column("REFERENCED_COLUMN_NAME", ScalarType.createVarchar(64)).build())).put((Object)"routines", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "routines", Table.TableType.SCHEMA, SchemaTable.builder().column("SPECIFIC_NAME", ScalarType.createVarchar(64)).column("ROUTINE_CATALOG", ScalarType.createVarchar(64)).column("ROUTINE_SCHEMA", ScalarType.createVarchar(64)).column("ROUTINE_NAME", ScalarType.createVarchar(64)).column("ROUTINE_TYPE", ScalarType.createVarchar(64)).column("DTD_IDENTIFIER", ScalarType.createVarchar(64)).column("ROUTINE_BODY", ScalarType.createVarchar(64)).column("ROUTINE_DEFINITION", ScalarType.createVarchar(64)).column("EXTERNAL_NAME", ScalarType.createVarchar(64)).column("EXTERNAL_LANGUAGE", ScalarType.createVarchar(64)).column("PARAMETER_STYLE", ScalarType.createVarchar(64)).column("IS_DETERMINISTIC", ScalarType.createVarchar(64)).column("SQL_DATA_ACCESS", ScalarType.createVarchar(64)).column("SQL_PATH", ScalarType.createVarchar(64)).column("SECURITY_TYPE", ScalarType.createVarchar(64)).column("CREATED", ScalarType.createType(PrimitiveType.DATETIME)).column("LAST_ALTERED", ScalarType.createType(PrimitiveType.DATETIME)).column("SQL_MODE", ScalarType.createVarchar(64)).column("ROUTINE_COMMENT", ScalarType.createVarchar(64)).column("DEFINER", ScalarType.createVarchar(64)).column("CHARACTER_SET_CLIENT", ScalarType.createVarchar(64)).column("COLLATION_CONNECTION", ScalarType.createVarchar(64)).column("DATABASE_COLLATION", ScalarType.createVarchar(64)).build())).put((Object)"schemata", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "schemata", Table.TableType.SCHEMA, SchemaTable.builder().column("CATALOG_NAME", ScalarType.createVarchar(512)).column("SCHEMA_NAME", ScalarType.createVarchar(32)).column("DEFAULT_CHARACTER_SET_NAME", ScalarType.createVarchar(32)).column("DEFAULT_COLLATION_NAME", ScalarType.createVarchar(32)).column("SQL_PATH", ScalarType.createVarchar(512)).build())).put((Object)"session_variables", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "session_variables", Table.TableType.SCHEMA, SchemaTable.builder().column("VARIABLE_NAME", ScalarType.createVarchar(64)).column("VARIABLE_VALUE", ScalarType.createVarchar(1024)).build())).put((Object)"global_variables", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "global_variables", Table.TableType.SCHEMA, SchemaTable.builder().column("VARIABLE_NAME", ScalarType.createVarchar(64)).column("VARIABLE_VALUE", ScalarType.createVarchar(1024)).build())).put((Object)"columns", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "columns", Table.TableType.SCHEMA, SchemaTable.builder().column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("COLUMN_NAME", ScalarType.createVarchar(64)).column("ORDINAL_POSITION", ScalarType.createType(PrimitiveType.BIGINT)).column("COLUMN_DEFAULT", ScalarType.createVarchar(1024)).column("IS_NULLABLE", ScalarType.createVarchar(3)).column("DATA_TYPE", ScalarType.createVarchar(64)).column("CHARACTER_MAXIMUM_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("CHARACTER_OCTET_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("NUMERIC_PRECISION", ScalarType.createType(PrimitiveType.BIGINT)).column("NUMERIC_SCALE", ScalarType.createType(PrimitiveType.BIGINT)).column("DATETIME_PRECISION", ScalarType.createType(PrimitiveType.BIGINT)).column("CHARACTER_SET_NAME", ScalarType.createVarchar(32)).column("COLLATION_NAME", ScalarType.createVarchar(32)).column("COLUMN_TYPE", ScalarType.createVarchar(32)).column("COLUMN_KEY", ScalarType.createVarchar(3)).column("EXTRA", ScalarType.createVarchar(27)).column("PRIVILEGES", ScalarType.createVarchar(80)).column("COLUMN_COMMENT", ScalarType.createVarchar(255)).column("COLUMN_SIZE", ScalarType.createType(PrimitiveType.BIGINT)).column("DECIMAL_DIGITS", ScalarType.createType(PrimitiveType.BIGINT)).column("GENERATION_EXPRESSION", ScalarType.createVarchar(64)).column("SRS_ID", ScalarType.createType(PrimitiveType.BIGINT)).build())).put((Object)"character_sets", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "character_sets", Table.TableType.SCHEMA, SchemaTable.builder().column("CHARACTER_SET_NAME", ScalarType.createVarchar(512)).column("DEFAULT_COLLATE_NAME", ScalarType.createVarchar(64)).column("DESCRIPTION", ScalarType.createVarchar(64)).column("MAXLEN", ScalarType.createType(PrimitiveType.BIGINT)).build())).put((Object)"collations", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "collations", Table.TableType.SCHEMA, SchemaTable.builder().column("COLLATION_NAME", ScalarType.createVarchar(512)).column("CHARACTER_SET_NAME", ScalarType.createVarchar(64)).column("ID", ScalarType.createType(PrimitiveType.BIGINT)).column("IS_DEFAULT", ScalarType.createVarchar(64)).column("IS_COMPILED", ScalarType.createVarchar(64)).column("SORTLEN", ScalarType.createType(PrimitiveType.BIGINT)).build())).put((Object)"table_constraints", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "table_constraints", Table.TableType.SCHEMA, SchemaTable.builder().column("CONSTRAINT_CATALOG", ScalarType.createVarchar(512)).column("CONSTRAINT_SCHEMA", ScalarType.createVarchar(64)).column("CONSTRAINT_NAME", ScalarType.createVarchar(64)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("CONSTRAINT_TYPE", ScalarType.createVarchar(64)).build())).put((Object)"engines", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "engines", Table.TableType.SCHEMA, SchemaTable.builder().column("ENGINE", ScalarType.createVarchar(64)).column("SUPPORT", ScalarType.createVarchar(8)).column("COMMENT", ScalarType.createVarchar(80)).column("TRANSACTIONS", ScalarType.createVarchar(3)).column("XA", ScalarType.createVarchar(3)).column("SAVEPOINTS", ScalarType.createVarchar(3)).build())).put((Object)"views", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "views", Table.TableType.SCHEMA, SchemaTable.builder().column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("VIEW_DEFINITION", ScalarType.createVarchar(8096)).column("CHECK_OPTION", ScalarType.createVarchar(8)).column("IS_UPDATABLE", ScalarType.createVarchar(3)).column("DEFINER", ScalarType.createVarchar(77)).column("SECURITY_TYPE", ScalarType.createVarchar(7)).column("CHARACTER_SET_CLIENT", ScalarType.createVarchar(32)).column("COLLATION_CONNECTION", ScalarType.createVarchar(32)).build())).put((Object)"statistics", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "statistics", Table.TableType.SCHEMA, SchemaTable.builder().column("TABLE_CATALOG", ScalarType.createVarchar(512)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("NON_UNIQUE", ScalarType.createType(PrimitiveType.BIGINT)).column("INDEX_SCHEMA", ScalarType.createVarchar(64)).column("INDEX_NAME", ScalarType.createVarchar(64)).column("SEQ_IN_INDEX", ScalarType.createType(PrimitiveType.BIGINT)).column("COLUMN_NAME", ScalarType.createVarchar(64)).column("COLLATION", ScalarType.createVarchar(1)).column("CARDINALITY", ScalarType.createType(PrimitiveType.BIGINT)).column("SUB_PART", ScalarType.createType(PrimitiveType.BIGINT)).column("PACKED", ScalarType.createVarchar(10)).column("NULLABLE", ScalarType.createVarchar(3)).column("INDEX_TYPE", ScalarType.createVarchar(16)).column("COMMENT", ScalarType.createVarchar(16)).build())).put((Object)"files", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "files", Table.TableType.SCHEMA, SchemaTable.builder().column("FILE_ID", ScalarType.createType(PrimitiveType.BIGINT)).column("FILE_NAME", ScalarType.createStringType()).column("FILE_TYPE", ScalarType.createVarchar(256)).column("TABLESPACE_NAME", ScalarType.createVarchar(256)).column("TABLE_CATALOG", ScalarType.createCharType(16)).column("TABLE_SCHEMA", ScalarType.createStringType()).column("TABLE_NAME", ScalarType.createStringType()).column("LOGFILE_GROUP_NAME", ScalarType.createVarchar(256)).column("LOGFILE_GROUP_NUMBER", ScalarType.createType(PrimitiveType.BIGINT)).column("ENGINE", ScalarType.createVarchar(64)).column("FULLTEXT_KEYS", ScalarType.createStringType()).column("DELETED_ROWS", ScalarType.createStringType()).column("UPDATE_COUNT", ScalarType.createStringType()).column("FREE_EXTENTS", ScalarType.createType(PrimitiveType.BIGINT)).column("TOTAL_EXTENTS", ScalarType.createType(PrimitiveType.BIGINT)).column("EXTENT_SIZE", ScalarType.createType(PrimitiveType.BIGINT)).column("INITIAL_SIZE", ScalarType.createType(PrimitiveType.BIGINT)).column("MAXIMUM_SIZE", ScalarType.createType(PrimitiveType.BIGINT)).column("AUTOEXTEND_SIZE", ScalarType.createType(PrimitiveType.BIGINT)).column("CREATION_TIME", ScalarType.createStringType()).column("LAST_UPDATE_TIME", ScalarType.createStringType()).column("LAST_ACCESS_TIME", ScalarType.createStringType()).column("RECOVER_TIME", ScalarType.createStringType()).column("TRANSACTION_COUNTER", ScalarType.createStringType()).column("VERSION", ScalarType.createType(PrimitiveType.BIGINT)).column("ROW_FORMAT", ScalarType.createVarchar(256)).column("TABLE_ROWS", ScalarType.createStringType()).column("AVG_ROW_LENGTH", ScalarType.createStringType()).column("DATA_LENGTH", ScalarType.createStringType()).column("MAX_DATA_LENGTH", ScalarType.createStringType()).column("INDEX_LENGTH", ScalarType.createStringType()).column("DATA_FREE", ScalarType.createType(PrimitiveType.BIGINT)).column("CREATE_TIME", ScalarType.createStringType()).column("UPDATE_TIME", ScalarType.createStringType()).column("CHECK_TIME", ScalarType.createStringType()).column("CHECKSUM", ScalarType.createStringType()).column("STATUS", ScalarType.createVarchar(256)).column("EXTRA", ScalarType.createVarchar(256)).build())).put((Object)"partitions", (Object)new SchemaTable(SystemIdGenerator.getNextId(), "partitions", Table.TableType.SCHEMA, SchemaTable.builder().column("TABLE_CATALOG", ScalarType.createVarchar(64)).column("TABLE_SCHEMA", ScalarType.createVarchar(64)).column("TABLE_NAME", ScalarType.createVarchar(64)).column("PARTITION_NAME", ScalarType.createVarchar(64)).column("SUBPARTITION_NAME", ScalarType.createVarchar(64)).column("PARTITION_ORDINAL_POSITION", ScalarType.createType(PrimitiveType.INT)).column("SUBPARTITION_ORDINAL_POSITION", ScalarType.createType(PrimitiveType.INT)).column("PARTITION_METHOD", ScalarType.createVarchar(13)).column("SUBPARTITION_METHOD", ScalarType.createVarchar(13)).column("PARTITION_EXPRESSION", ScalarType.createVarchar(2048)).column("SUBPARTITION_EXPRESSION", ScalarType.createVarchar(2048)).column("PARTITION_DESCRIPTION", ScalarType.createStringType()).column("TABLE_ROWS", ScalarType.createType(PrimitiveType.BIGINT)).column("AVG_ROW_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("DATA_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("MAX_DATA_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("INDEX_LENGTH", ScalarType.createType(PrimitiveType.BIGINT)).column("DATA_FREE", ScalarType.createType(PrimitiveType.BIGINT)).column("CREATE_TIME", ScalarType.createType(PrimitiveType.BIGINT)).column("UPDATE_TIME", ScalarType.createType(PrimitiveType.DATETIME)).column("CHECK_TIME", ScalarType.createType(PrimitiveType.DATETIME)).column("CHECKSUM", ScalarType.createType(PrimitiveType.BIGINT)).column("PARTITION_COMMENT", ScalarType.createStringType()).column("NODEGROUP", ScalarType.createVarchar(256)).column("TABLESPACE_NAME", ScalarType.createVarchar(268)).build())).build();

    protected SchemaTable(long id, String name, Table.TableType type, List<Column> baseSchema) {
        super(id, name, type, baseSchema);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("Do not allow to write SchemaTable to image.");
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException("Do not allow read SchemaTable from image.");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TTableDescriptor toThrift() {
        TSchemaTable tSchemaTable = new TSchemaTable(SchemaTableType.getThriftType(this.name));
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.SCHEMA_TABLE, TABLE_MAP.get(this.name).getBaseSchema().size(), 0, this.name, "");
        tTableDescriptor.setSchemaTable(tSchemaTable);
        return tTableDescriptor;
    }

    public static class Builder {
        List<Column> columns = Lists.newArrayList();

        public Builder column(String name, ScalarType type) {
            this.columns.add(new Column(name, type.getPrimitiveType(), true));
            return this;
        }

        public List<Column> build() {
            return this.columns;
        }
    }
}

