/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.io.Text;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TScalarType;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScalarType
extends Type {
    private static final Logger LOG = LogManager.getLogger(ScalarType.class);
    public static final int DEFAULT_PRECISION = 9;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAX_VARCHAR_LENGTH = 65533;
    public static final int MAX_CHAR_LENGTH = 255;
    public static final int MAX_HLL_LENGTH = 16385;
    public static final int CHAR_INLINE_LENGTH = 128;
    public static final int MAX_STRING_LENGTH = 0x7FFFFFFB;
    public static final int MAX_PRECISION = 38;
    @SerializedName(value="type")
    private final PrimitiveType type;
    @SerializedName(value="len")
    private int len = -1;
    private boolean isAssignedStrLenInColDefinition = false;
    @SerializedName(value="precision")
    private int precision;
    @SerializedName(value="scale")
    private int scale;
    @SerializedName(value="precisionStr")
    private String precisionStr;
    @SerializedName(value="scaleStr")
    private String scaleStr;
    @SerializedName(value="lenStr")
    private String lenStr;

    protected ScalarType(PrimitiveType type) {
        this.type = type;
    }

    public static ScalarType createType(PrimitiveType type, int len, int precision, int scale) {
        switch (type) {
            case CHAR: {
                return ScalarType.createCharType(len);
            }
            case VARCHAR: {
                return ScalarType.createVarcharType(len);
            }
            case STRING: {
                return ScalarType.createStringType();
            }
            case DECIMALV2: {
                return ScalarType.createDecimalV2Type(precision, scale);
            }
        }
        return ScalarType.createType(type);
    }

    public static ScalarType createType(PrimitiveType type) {
        switch (type) {
            case INVALID_TYPE: {
                return INVALID;
            }
            case NULL_TYPE: {
                return NULL;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case TINYINT: {
                return TINYINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case CHAR: {
                return CHAR;
            }
            case VARCHAR: {
                return ScalarType.createVarcharType();
            }
            case STRING: {
                return ScalarType.createStringType();
            }
            case HLL: {
                return ScalarType.createHllType();
            }
            case BITMAP: {
                return BITMAP;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case TIME: {
                return TIME;
            }
            case DECIMALV2: {
                return DEFAULT_DECIMALV2;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case ALL: {
                return ALL;
            }
        }
        LOG.warn("type={}", (Object)type);
        Preconditions.checkState((boolean)false);
        return NULL;
    }

    public static ScalarType createType(String type) {
        switch (type) {
            case "INVALID_TYPE": {
                return INVALID;
            }
            case "NULL_TYPE": {
                return NULL;
            }
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "SMALLINT": {
                return SMALLINT;
            }
            case "TINYINT": {
                return TINYINT;
            }
            case "INT": {
                return INT;
            }
            case "BIGINT": {
                return BIGINT;
            }
            case "FLOAT": {
                return FLOAT;
            }
            case "DOUBLE": {
                return DOUBLE;
            }
            case "CHAR": {
                return CHAR;
            }
            case "VARCHAR": {
                return ScalarType.createVarcharType();
            }
            case "STRING": 
            case "TEXT": {
                return ScalarType.createStringType();
            }
            case "HLL": {
                return ScalarType.createHllType();
            }
            case "BITMAP": {
                return BITMAP;
            }
            case "DATE": {
                return DATE;
            }
            case "DATETIME": {
                return DATETIME;
            }
            case "TIME": {
                return TIME;
            }
            case "DECIMAL": 
            case "DECIMALV2": {
                return ScalarType.createDecimalV2Type();
            }
            case "LARGEINT": {
                return LARGEINT;
            }
        }
        LOG.warn("type={}", (Object)type);
        Preconditions.checkState((boolean)false);
        return NULL;
    }

    public static ScalarType createCharType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createCharType(String lenStr) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.lenStr = lenStr;
        return type;
    }

    public static ScalarType createChar(int len) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createDecimalV2Type() {
        return DEFAULT_DECIMALV2;
    }

    public static ScalarType createDecimalV2Type(int precision) {
        return ScalarType.createDecimalV2Type(precision, 0);
    }

    public static ScalarType createDecimalV2Type(int precision, int scale) {
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precision = precision;
        type.scale = scale;
        return type;
    }

    public static ScalarType createDecimalV2Type(String precisionStr) {
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precisionStr = precisionStr;
        type.scaleStr = null;
        return type;
    }

    public static ScalarType createDecimalV2Type(String precisionStr, String scaleStr) {
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precisionStr = precisionStr;
        type.scaleStr = scaleStr;
        return type;
    }

    public static ScalarType createDecimalV2TypeInternal(int precision, int scale) {
        ScalarType type = new ScalarType(PrimitiveType.DECIMALV2);
        type.precision = Math.min(precision, 38);
        type.scale = Math.min(type.precision, scale);
        return type;
    }

    public static ScalarType createVarcharType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createVarcharType(String lenStr) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.lenStr = lenStr;
        return type;
    }

    public static ScalarType createStringType() {
        ScalarType type = new ScalarType(PrimitiveType.STRING);
        type.len = 0x7FFFFFFB;
        return type;
    }

    public static ScalarType createVarchar(int len) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.len = len;
        return type;
    }

    public static ScalarType createVarcharType() {
        return DEFAULT_VARCHAR;
    }

    public static ScalarType createHllType() {
        ScalarType type = new ScalarType(PrimitiveType.HLL);
        type.len = 16385;
        return type;
    }

    public String toString() {
        if (this.type == PrimitiveType.CHAR) {
            if (this.isWildcardChar()) {
                return "CHAR(*)";
            }
            return "CHAR(" + this.len + ")";
        }
        if (this.type == PrimitiveType.DECIMALV2) {
            if (this.isWildcardDecimal()) {
                return "DECIMAL(*,*)";
            }
            return "DECIMAL(" + this.precision + "," + this.scale + ")";
        }
        if (this.type == PrimitiveType.VARCHAR) {
            if (this.isWildcardVarchar()) {
                return "VARCHAR(*)";
            }
            return "VARCHAR(" + this.len + ")";
        }
        if (this.type == PrimitiveType.STRING) {
            return "TEXT";
        }
        return this.type.toString();
    }

    @Override
    public String toSql(int depth) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case CHAR: {
                if (Strings.isNullOrEmpty((String)this.lenStr)) {
                    stringBuilder.append("char").append("(").append(this.len).append(")");
                    break;
                }
                stringBuilder.append("char").append("(`").append(this.lenStr).append("`)");
                break;
            }
            case VARCHAR: {
                if (Strings.isNullOrEmpty((String)this.lenStr)) {
                    stringBuilder.append("varchar").append("(").append(this.len).append(")");
                    break;
                }
                stringBuilder.append("varchar").append("(`").append(this.lenStr).append("`)");
                break;
            }
            case DECIMALV2: {
                if (Strings.isNullOrEmpty((String)this.precisionStr)) {
                    stringBuilder.append("decimal").append("(").append(this.precision).append(", ").append(this.scale).append(")");
                    break;
                }
                if (!Strings.isNullOrEmpty((String)this.precisionStr) && !Strings.isNullOrEmpty((String)this.scaleStr)) {
                    stringBuilder.append("decimal").append("(`").append(this.precisionStr).append("`, `").append(this.scaleStr).append("`)");
                    break;
                }
                stringBuilder.append("decimal").append("(`").append(this.precisionStr).append("`)");
                break;
            }
            case BOOLEAN: {
                return "boolean";
            }
            case TINYINT: {
                return "tinyint(4)";
            }
            case SMALLINT: {
                return "smallint(6)";
            }
            case INT: {
                return "int(11)";
            }
            case BIGINT: {
                return "bigint(20)";
            }
            case LARGEINT: {
                return "largeint(40)";
            }
            case FLOAT: 
            case DOUBLE: 
            case HLL: 
            case BITMAP: 
            case DATE: 
            case DATETIME: {
                stringBuilder.append(this.type.toString().toLowerCase());
                break;
            }
            case STRING: {
                stringBuilder.append("text");
                break;
            }
            case ARRAY: {
                stringBuilder.append(this.type.toString().toLowerCase());
                break;
            }
            default: {
                stringBuilder.append("unknown type: " + this.type.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String prettyPrint(int lpad) {
        return Strings.repeat((String)" ", (int)lpad) + this.toSql();
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        node.setType(TTypeNodeType.SCALAR);
        TScalarType scalarType = new TScalarType();
        scalarType.setType(this.type.toThrift());
        switch (this.type) {
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case HLL: {
                scalarType.setLen(this.len);
                break;
            }
            case DECIMALV2: {
                scalarType.setScale(this.scale);
                scalarType.setPrecision(this.precision);
                break;
            }
        }
        node.setScalarType(scalarType);
    }

    public int decimalPrecision() {
        Preconditions.checkState((this.type == PrimitiveType.DECIMALV2 ? 1 : 0) != 0);
        return this.precision;
    }

    public int decimalScale() {
        Preconditions.checkState((this.type == PrimitiveType.DECIMALV2 ? 1 : 0) != 0);
        return this.scale;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return this.type;
    }

    public int ordinal() {
        return this.type.ordinal();
    }

    @Override
    public int getLength() {
        return this.len;
    }

    public void setLength(int len) {
        this.len = len;
    }

    public boolean isAssignedStrLenInColDefinition() {
        return this.isAssignedStrLenInColDefinition;
    }

    public void setAssignedStrLenInColDefinition() {
        this.isAssignedStrLenInColDefinition = true;
    }

    public int getScalarScale() {
        return this.scale;
    }

    public int getScalarPrecision() {
        return this.precision;
    }

    public String getScalarPrecisionStr() {
        return this.precisionStr;
    }

    public String getScalarScaleStr() {
        return this.scaleStr;
    }

    public String getLenStr() {
        return this.lenStr;
    }

    @Override
    public boolean isWildcardDecimal() {
        return this.type == PrimitiveType.DECIMALV2 && this.precision == -1 && this.scale == -1;
    }

    @Override
    public boolean isWildcardVarchar() {
        return (this.type == PrimitiveType.VARCHAR || this.type == PrimitiveType.HLL) && this.len == -1;
    }

    @Override
    public boolean isWildcardChar() {
        return this.type == PrimitiveType.CHAR && this.len == -1;
    }

    @Override
    public boolean isFixedLengthType() {
        return this.type == PrimitiveType.BOOLEAN || this.type == PrimitiveType.TINYINT || this.type == PrimitiveType.SMALLINT || this.type == PrimitiveType.INT || this.type == PrimitiveType.BIGINT || this.type == PrimitiveType.FLOAT || this.type == PrimitiveType.DOUBLE || this.type == PrimitiveType.DATE || this.type == PrimitiveType.DATETIME || this.type == PrimitiveType.DECIMALV2 || this.type == PrimitiveType.CHAR;
    }

    @Override
    public boolean isSupported() {
        switch (this.type) {
            case BINARY: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsTablePartitioning() {
        return this.isSupported() && !this.isComplexType();
    }

    @Override
    public int getSlotSize() {
        return this.type.getSlotSize();
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (!t.isScalarType()) {
            return false;
        }
        ScalarType scalarType = (ScalarType)t;
        if (this.type == PrimitiveType.VARCHAR && scalarType.isWildcardVarchar()) {
            Preconditions.checkState((!this.isWildcardVarchar() ? 1 : 0) != 0);
            return true;
        }
        if (this.type == PrimitiveType.CHAR && scalarType.isWildcardChar()) {
            Preconditions.checkState((!this.isWildcardChar() ? 1 : 0) != 0);
            return true;
        }
        if (this.type == PrimitiveType.CHAR && scalarType.isStringType()) {
            return true;
        }
        if (this.type == PrimitiveType.VARCHAR && scalarType.isStringType()) {
            return true;
        }
        if (this.isDecimalV2() && scalarType.isWildcardDecimal()) {
            Preconditions.checkState((!this.isWildcardDecimal() ? 1 : 0) != 0);
            return true;
        }
        return this.isDecimalV2() && scalarType.isDecimalV2();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ScalarType)) {
            return false;
        }
        ScalarType other = (ScalarType)o;
        if (this.type != other.type) {
            return false;
        }
        if (this.type == PrimitiveType.CHAR) {
            return this.len == other.len;
        }
        if (this.type == PrimitiveType.VARCHAR) {
            return this.len == other.len;
        }
        if (this.type == PrimitiveType.DECIMALV2) {
            return this.precision == other.precision && this.scale == other.scale;
        }
        return true;
    }

    @Override
    public Type getMaxResolutionType() {
        if (this.isIntegerType()) {
            return BIGINT;
        }
        if (this.isFloatingPointType()) {
            return DOUBLE;
        }
        if (this.isNull()) {
            return NULL;
        }
        if (this.isDecimalV2()) {
            return ScalarType.createDecimalV2TypeInternal(38, this.scale);
        }
        if (this.isLargeIntType()) {
            return LARGEINT;
        }
        return INVALID;
    }

    public ScalarType getNextResolutionType() {
        Preconditions.checkState((this.isNumericType() || this.isNull() ? 1 : 0) != 0);
        if (this.type == PrimitiveType.DOUBLE || this.type == PrimitiveType.BIGINT || this.isNull()) {
            return this;
        }
        if (this.type == PrimitiveType.DECIMALV2) {
            return ScalarType.createDecimalV2TypeInternal(38, this.scale);
        }
        return ScalarType.createType(PrimitiveType.values()[this.type.ordinal() + 1]);
    }

    public ScalarType getMinResolutionDecimal() {
        switch (this.type) {
            case NULL_TYPE: {
                return Type.NULL;
            }
            case DECIMALV2: {
                return this;
            }
            case TINYINT: {
                return ScalarType.createDecimalV2Type(3);
            }
            case SMALLINT: {
                return ScalarType.createDecimalV2Type(5);
            }
            case INT: {
                return ScalarType.createDecimalV2Type(10);
            }
            case BIGINT: {
                return ScalarType.createDecimalV2Type(19);
            }
            case FLOAT: {
                return ScalarType.createDecimalV2TypeInternal(38, 9);
            }
            case DOUBLE: {
                return ScalarType.createDecimalV2TypeInternal(38, 17);
            }
        }
        return INVALID;
    }

    public boolean isSupertypeOf(ScalarType o) {
        Preconditions.checkState((boolean)this.isDecimalV2());
        Preconditions.checkState((boolean)o.isDecimalV2());
        if (this.isWildcardDecimal()) {
            return true;
        }
        if (o.isWildcardDecimal()) {
            return false;
        }
        return this.scale >= o.scale && this.precision - this.scale >= o.precision - o.scale;
    }

    public static ScalarType getAssignmentCompatibleType(ScalarType t1, ScalarType t2, boolean strict) {
        boolean t2IsBitMap;
        boolean t2IsHLL;
        if (!t1.isValid() || !t2.isValid()) {
            return INVALID;
        }
        if (t1.equals(t2)) {
            return t1;
        }
        if (t1.isNull()) {
            return t2;
        }
        if (t2.isNull()) {
            return t1;
        }
        boolean t1IsHLL = t1.type == PrimitiveType.HLL;
        boolean bl = t2IsHLL = t2.type == PrimitiveType.HLL;
        if (t1IsHLL || t2IsHLL) {
            if (t1IsHLL && t2IsHLL) {
                return ScalarType.createHllType();
            }
            return INVALID;
        }
        boolean t1IsBitMap = t1.type == PrimitiveType.BITMAP;
        boolean bl2 = t2IsBitMap = t2.type == PrimitiveType.BITMAP;
        if (t1IsBitMap || t2IsBitMap) {
            if (t1IsBitMap && t2IsBitMap) {
                return BITMAP;
            }
            return INVALID;
        }
        if (t1.type == PrimitiveType.ALL || t2.type == PrimitiveType.ALL) {
            return Type.ALL;
        }
        if (t1.isStringType() || t2.isStringType()) {
            if (t1.type == PrimitiveType.STRING || t2.type == PrimitiveType.STRING) {
                return ScalarType.createStringType();
            }
            return ScalarType.createVarcharType(Math.max(t1.len, t2.len));
        }
        if (t1.isDecimalV2() && t2.isDate() || t1.isDate() && t2.isDecimalV2()) {
            return INVALID;
        }
        if (t1.isDecimalV2() || t2.isDecimalV2()) {
            return DECIMALV2;
        }
        PrimitiveType smallerType = t1.type.ordinal() < t2.type.ordinal() ? t1.type : t2.type;
        PrimitiveType largerType = t1.type.ordinal() > t2.type.ordinal() ? t1.type : t2.type;
        PrimitiveType result = null;
        if (strict) {
            result = strictCompatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        }
        if (result == null) {
            result = compatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        }
        Preconditions.checkNotNull(result);
        return ScalarType.createType(result);
    }

    public static boolean isImplicitlyCastable(ScalarType t1, ScalarType t2, boolean strict) {
        return ScalarType.getAssignmentCompatibleType(t1, t2, strict).matchesType(t2);
    }

    public static boolean canCastTo(ScalarType type, ScalarType targetType) {
        return PrimitiveType.isImplicitCast(type.getPrimitiveType(), targetType.getPrimitiveType());
    }

    @Override
    public int getStorageLayoutBytes() {
        switch (this.type) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case BIGINT: 
            case DATETIME: 
            case TIME: {
                return 8;
            }
            case DECIMALV2: 
            case LARGEINT: {
                return 16;
            }
            case DOUBLE: {
                return 12;
            }
            case DATE: {
                return 3;
            }
            case CHAR: 
            case VARCHAR: {
                return this.len;
            }
            case HLL: {
                return 16385;
            }
            case BITMAP: {
                return 1024;
            }
            case STRING: {
                return 1024;
            }
        }
        return 0;
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        TColumnType thrift = new TColumnType();
        thrift.type = this.type.toThrift();
        if (this.type == PrimitiveType.CHAR || this.type == PrimitiveType.VARCHAR || this.type == PrimitiveType.HLL) {
            thrift.setLen(this.len);
        }
        if (this.type == PrimitiveType.DECIMALV2) {
            thrift.setPrecision(this.precision);
            thrift.setScale(this.scale);
        }
        return thrift;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + Objects.hashCode((Object)this.type);
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static ScalarType read(DataInput input) throws IOException {
        String json = Text.readString((DataInput)input);
        return (ScalarType)GsonUtils.GSON.fromJson(json, ScalarType.class);
    }
}

