/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.io.IOUtils;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.URI;
import org.apache.doris.thrift.TFunction;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.doris.thrift.TScalarFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScalarFunction
extends Function {
    private static final Logger LOG = LogManager.getLogger(ScalarFunction.class);
    private String symbolName;
    private String prepareFnSymbol;
    private String closeFnSymbol;

    protected ScalarFunction() {
    }

    public ScalarFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs, boolean userVisible) {
        this(fnName, argTypes, retType, hasVarArgs, TFunctionBinaryType.BUILTIN, userVisible, false);
    }

    public ScalarFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs, boolean userVisible, boolean isVec) {
        this(fnName, argTypes, retType, hasVarArgs, TFunctionBinaryType.BUILTIN, userVisible, isVec);
    }

    public ScalarFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs, TFunctionBinaryType binaryType, boolean userVisible, boolean isVec) {
        super(0L, fnName, argTypes, retType, hasVarArgs, binaryType, userVisible, isVec, Function.NullableMode.DEPEND_ON_ARGUMENT);
    }

    public ScalarFunction(FunctionName fnName, List<Type> argTypes, Type retType, URI location, String symbolName, String initFnSymbol, String closeFnSymbol) {
        super(fnName, argTypes, retType, false);
        this.setLocation(location);
        this.setSymbolName(symbolName);
        this.setPrepareFnSymbol(initFnSymbol);
        this.setCloseFnSymbol(closeFnSymbol);
    }

    public static ScalarFunction createBuiltin(String name, Type retType, ArrayList<Type> argTypes, boolean hasVarArgs, String symbol, String prepareFnSymbol, String closeFnSymbol, boolean userVisible) {
        return ScalarFunction.createBuiltin(name, retType, Function.NullableMode.DEPEND_ON_ARGUMENT, argTypes, hasVarArgs, symbol, prepareFnSymbol, closeFnSymbol, userVisible);
    }

    public static ScalarFunction createBuiltin(String name, Type retType, Function.NullableMode nullableMode, ArrayList<Type> argTypes, boolean hasVarArgs, String symbol, String prepareFnSymbol, String closeFnSymbol, boolean userVisible) {
        Preconditions.checkNotNull((Object)symbol);
        ScalarFunction fn = new ScalarFunction(new FunctionName(name), argTypes, retType, hasVarArgs, userVisible);
        fn.symbolName = symbol;
        fn.prepareFnSymbol = prepareFnSymbol;
        fn.closeFnSymbol = closeFnSymbol;
        fn.nullableMode = nullableMode;
        return fn;
    }

    public static ScalarFunction createBuiltinOperator(String name, ArrayList<Type> argTypes, Type retType) {
        return ScalarFunction.createBuiltinOperator(name, argTypes, retType, Function.NullableMode.DEPEND_ON_ARGUMENT);
    }

    public static ScalarFunction createBuiltinOperator(String name, ArrayList<Type> argTypes, Type retType, Function.NullableMode nullableMode) {
        String beClass;
        String beFn = name;
        boolean usesDecimal = false;
        boolean usesDecimalV2 = false;
        block13: for (int i = 0; i < argTypes.size(); ++i) {
            switch (argTypes.get(i).getPrimitiveType()) {
                case BOOLEAN: {
                    beFn = beFn + "_boolean_val";
                    continue block13;
                }
                case TINYINT: {
                    beFn = beFn + "_tiny_int_val";
                    continue block13;
                }
                case SMALLINT: {
                    beFn = beFn + "_small_int_val";
                    continue block13;
                }
                case INT: {
                    beFn = beFn + "_int_val";
                    continue block13;
                }
                case BIGINT: {
                    beFn = beFn + "_big_int_val";
                    continue block13;
                }
                case LARGEINT: {
                    beFn = beFn + "_large_int_val";
                    continue block13;
                }
                case FLOAT: {
                    beFn = beFn + "_float_val";
                    continue block13;
                }
                case DOUBLE: 
                case TIME: {
                    beFn = beFn + "_double_val";
                    continue block13;
                }
                case CHAR: 
                case VARCHAR: 
                case HLL: 
                case BITMAP: 
                case STRING: {
                    beFn = beFn + "_string_val";
                    continue block13;
                }
                case DATE: 
                case DATETIME: {
                    beFn = beFn + "_datetime_val";
                    continue block13;
                }
                case DECIMALV2: {
                    beFn = beFn + "_decimalv2_val";
                    usesDecimalV2 = true;
                    continue block13;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("Argument type not supported: " + argTypes.get(i)));
                }
            }
        }
        String string = beClass = usesDecimal ? "DecimalOperators" : "Operators";
        if (usesDecimalV2) {
            beClass = "DecimalV2Operators";
        }
        String symbol = "doris::" + beClass + "::" + beFn;
        return ScalarFunction.createBuiltinOperator(name, symbol, argTypes, retType, nullableMode);
    }

    public static ScalarFunction createVecBuiltinOperator(String name, ArrayList<Type> argTypes, Type retType) {
        return ScalarFunction.createVecBuiltinOperator(name, argTypes, retType, Function.NullableMode.DEPEND_ON_ARGUMENT);
    }

    public static ScalarFunction createVecBuiltinOperator(String name, ArrayList<Type> argTypes, Type retType, Function.NullableMode nullableMode) {
        String beClass;
        StringBuilder beFn = new StringBuilder(name);
        boolean usesDecimal = false;
        boolean usesDecimalV2 = false;
        block13: for (int i = 0; i < argTypes.size(); ++i) {
            switch (argTypes.get(0).getPrimitiveType()) {
                case BOOLEAN: {
                    beFn.append("_boolean_val");
                    continue block13;
                }
                case TINYINT: {
                    beFn.append("_tiny_int_val");
                    continue block13;
                }
                case SMALLINT: {
                    beFn.append("_small_int_val");
                    continue block13;
                }
                case INT: {
                    beFn.append("_int_val");
                    continue block13;
                }
                case BIGINT: {
                    beFn.append("_big_int_val");
                    continue block13;
                }
                case LARGEINT: {
                    beFn.append("_large_int_val");
                    continue block13;
                }
                case FLOAT: {
                    beFn.append("_float_val");
                    continue block13;
                }
                case DOUBLE: 
                case TIME: {
                    beFn.append("_double_val");
                    continue block13;
                }
                case CHAR: 
                case VARCHAR: 
                case HLL: 
                case BITMAP: {
                    beFn.append("_string_val");
                    continue block13;
                }
                case DATE: 
                case DATETIME: {
                    beFn.append("_datetime_val");
                    continue block13;
                }
                case DECIMALV2: {
                    beFn.append("_decimalv2_val");
                    usesDecimalV2 = true;
                    continue block13;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("Argument type not supported: " + argTypes.get(i)));
                }
            }
        }
        String string = beClass = usesDecimal ? "DecimalOperators" : "Operators";
        if (usesDecimalV2) {
            beClass = "DecimalV2Operators";
        }
        String symbol = "doris::" + beClass + "::" + beFn;
        return ScalarFunction.createVecBuiltinOperator(name, symbol, argTypes, retType, nullableMode);
    }

    public static ScalarFunction createBuiltinOperator(String name, String symbol, ArrayList<Type> argTypes, Type retType) {
        return ScalarFunction.createBuiltinOperator(name, symbol, argTypes, retType, Function.NullableMode.DEPEND_ON_ARGUMENT);
    }

    public static ScalarFunction createBuiltinOperator(String name, String symbol, ArrayList<Type> argTypes, Type retType, Function.NullableMode nullableMode) {
        return ScalarFunction.createBuiltin(name, symbol, argTypes, false, retType, false, nullableMode);
    }

    public static ScalarFunction createBuiltin(String name, String symbol, ArrayList<Type> argTypes, boolean hasVarArgs, Type retType, boolean userVisible, Function.NullableMode nullableMode) {
        ScalarFunction fn = new ScalarFunction(new FunctionName(name), argTypes, retType, hasVarArgs, userVisible);
        fn.symbolName = symbol;
        fn.nullableMode = nullableMode;
        return fn;
    }

    public static ScalarFunction createVecBuiltinOperator(String name, String symbol, ArrayList<Type> argTypes, Type retType, Function.NullableMode nullableMode) {
        return ScalarFunction.createVecBuiltin(name, null, symbol, null, argTypes, false, retType, false, nullableMode);
    }

    public static ScalarFunction createVecBuiltin(String name, String prepareFnSymbolBName, String symbol, String closeFnSymbolName, ArrayList<Type> argTypes, boolean hasVarArgs, Type retType, boolean userVisible, Function.NullableMode nullableMode) {
        ScalarFunction fn = new ScalarFunction(new FunctionName(name), argTypes, retType, hasVarArgs, userVisible, true);
        if (prepareFnSymbolBName != null) {
            fn.prepareFnSymbol = prepareFnSymbolBName;
        }
        fn.symbolName = symbol;
        if (closeFnSymbolName != null) {
            fn.closeFnSymbol = closeFnSymbolName;
        }
        fn.nullableMode = nullableMode;
        return fn;
    }

    public static ScalarFunction createBuiltinSearchDesc(String name, Type[] argTypes, boolean hasVarArgs) {
        ArrayList<Type> fnArgs = argTypes == null ? new ArrayList<Type>() : Lists.newArrayList((Object[])argTypes);
        ScalarFunction fn = new ScalarFunction(new FunctionName(name), fnArgs, Type.INVALID, hasVarArgs, true);
        return fn;
    }

    public static ScalarFunction createUdf(TFunctionBinaryType binaryType, FunctionName name, Type[] args, Type returnType, boolean isVariadic, URI location, String symbol, String prepareFnSymbol, String closeFnSymbol) {
        ScalarFunction fn = new ScalarFunction(name, Arrays.asList(args), returnType, isVariadic, binaryType, true, false);
        fn.symbolName = symbol;
        fn.prepareFnSymbol = prepareFnSymbol;
        fn.closeFnSymbol = closeFnSymbol;
        fn.setLocation(location);
        return fn;
    }

    public void setSymbolName(String s) {
        this.symbolName = s;
    }

    public void setPrepareFnSymbol(String s) {
        this.prepareFnSymbol = s;
    }

    public void setCloseFnSymbol(String s) {
        this.closeFnSymbol = s;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public String getPrepareFnSymbol() {
        return this.prepareFnSymbol;
    }

    public String getCloseFnSymbol() {
        return this.closeFnSymbol;
    }

    @Override
    public String toSql(boolean ifNotExists) {
        StringBuilder sb = new StringBuilder("CREATE FUNCTION ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.signatureString()).append(" RETURNS " + this.getReturnType()).append(" PROPERTIES (");
        sb.append("\n  \"SYMBOL\"=").append("\"" + this.getSymbolName() + "\"");
        if (this.getPrepareFnSymbol() != null) {
            sb.append(",\n  \"PREPARE_FN\"=").append("\"" + this.getPrepareFnSymbol() + "\"");
        }
        if (this.getCloseFnSymbol() != null) {
            sb.append(",\n  \"CLOSE_FN\"=").append("\"" + this.getCloseFnSymbol() + "\"");
        }
        sb.append(",\n  \"OBJECT_FILE\"=").append("\"" + (this.getLocation() == null ? "" : this.getLocation().toString()) + "\"");
        sb.append(",\n  \"MD5\"=").append("\"" + this.getChecksum() + "\"");
        sb.append("\n);");
        return sb.toString();
    }

    @Override
    public TFunction toThrift() {
        TFunction fn = super.toThrift();
        fn.setScalarFn(new TScalarFunction());
        fn.getScalarFn().setSymbol(this.symbolName);
        if (this.prepareFnSymbol != null) {
            fn.getScalarFn().setPrepareFnSymbol(this.prepareFnSymbol);
        }
        if (this.closeFnSymbol != null) {
            fn.getScalarFn().setCloseFnSymbol(this.closeFnSymbol);
        }
        return fn;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Function.FunctionType.SCALAR.write(output);
        super.writeFields(output);
        Text.writeString((DataOutput)output, (String)this.symbolName);
        IOUtils.writeOptionString((DataOutput)output, (String)this.prepareFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.closeFnSymbol);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.symbolName = Text.readString((DataInput)input);
        if (input.readBoolean()) {
            this.prepareFnSymbol = Text.readString((DataInput)input);
        }
        if (input.readBoolean()) {
            this.closeFnSymbol = Text.readString((DataInput)input);
        }
    }

    @Override
    public String getProperties() {
        HashMap properties = Maps.newHashMap();
        properties.put("object_file", this.getLocation() == null ? "" : this.getLocation().toString());
        properties.put("md5", this.checksum);
        properties.put("symbol", this.symbolName);
        return new Gson().toJson((Object)properties);
    }
}

