/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import org.apache.doris.thrift.TResourceType;

public enum ResourceType {
    CPU_SHARE("CPU_SHARE", TResourceType.TRESOURCE_CPU_SHARE, 1000),
    IO_SHARE("IO_SHARE", TResourceType.TRESOURCE_IO_SHARE, 1000),
    SSD_READ_IOPS("SSD_READ_IOPS", TResourceType.TRESOURCE_SSD_READ_IOPS, 100000),
    SSD_WRITE_IOPS("SSD_WRITE_IOPS", TResourceType.TRESOURCE_SSD_WRITE_IOPS, 100000),
    SSD_READ_MBPS("SSD_READ_MBPS", TResourceType.TRESOURCE_SSD_READ_MBPS, 200),
    SSD_WRITE_MBPS("SSD_WRITE_MBPS", TResourceType.TRESOURCE_SSD_WRITE_MBPS, 200),
    HDD_READ_IOPS("HDD_READ_IOPS", TResourceType.TRESOURCE_HDD_READ_IOPS, 2000),
    HDD_WRITE_IOPS("HDD_WRITE_IOPS", TResourceType.TRESOURCE_HDD_WRITE_IOPS, 2000),
    HDD_READ_MBPS("HDD_READ_MBPS", TResourceType.TRESOURCE_HDD_READ_MBPS, 200),
    HDD_WRITE_MBPS("HDD_WRITE_MBPS", TResourceType.TRESOURCE_HDD_WRITE_MBPS, 200);

    static ImmutableSortedMap<String, ResourceType> typeByDesc;
    private final String desc;
    private final TResourceType tType;
    private final int defaultValue;

    private ResourceType(String desc, TResourceType tType, int value) {
        this.desc = desc;
        this.tType = tType;
        this.defaultValue = value;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public static ResourceType fromDesc(String desc) {
        return (ResourceType)((Object)typeByDesc.get((Object)desc));
    }

    public TResourceType toThrift() {
        return this.tType;
    }

    public static ResourceType fromThrift(TResourceType tType) {
        switch (tType) {
            case TRESOURCE_CPU_SHARE: {
                return CPU_SHARE;
            }
            case TRESOURCE_IO_SHARE: {
                return IO_SHARE;
            }
            case TRESOURCE_SSD_READ_IOPS: {
                return SSD_READ_IOPS;
            }
            case TRESOURCE_SSD_WRITE_IOPS: {
                return SSD_WRITE_IOPS;
            }
            case TRESOURCE_SSD_READ_MBPS: {
                return SSD_READ_MBPS;
            }
            case TRESOURCE_SSD_WRITE_MBPS: {
                return SSD_WRITE_MBPS;
            }
            case TRESOURCE_HDD_READ_IOPS: {
                return HDD_READ_IOPS;
            }
            case TRESOURCE_HDD_WRITE_IOPS: {
                return HDD_WRITE_IOPS;
            }
            case TRESOURCE_HDD_READ_MBPS: {
                return HDD_READ_MBPS;
            }
            case TRESOURCE_HDD_WRITE_MBPS: {
                return HDD_WRITE_MBPS;
            }
        }
        return null;
    }

    public String toString() {
        return this.getDesc();
    }

    static {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ResourceType type : ResourceType.values()) {
            builder.put((Object)type.desc, (Object)type);
        }
        typeByDesc = builder.build();
    }
}

