/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.CreateResourceStmt;
import org.apache.doris.analysis.DropResourceStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Resource;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.DropResourceOperationLog;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceMgr
implements Writable {
    private static final Logger LOG = LogManager.getLogger(ResourceMgr.class);
    public static final ImmutableList<String> RESOURCE_PROC_NODE_TITLE_NAMES = new ImmutableList.Builder().add((Object)"Name").add((Object)"ResourceType").add((Object)"Item").add((Object)"Value").build();
    @SerializedName(value="nameToResource")
    private final Map<String, Resource> nameToResource = Maps.newConcurrentMap();
    private final ResourceProcNode procNode = new ResourceProcNode();

    public void createResource(CreateResourceStmt stmt) throws DdlException {
        if (stmt.getResourceType() != Resource.ResourceType.SPARK && stmt.getResourceType() != Resource.ResourceType.ODBC_CATALOG) {
            throw new DdlException("Only support SPARK and ODBC_CATALOG resource.");
        }
        Resource resource = Resource.fromStmt(stmt);
        this.createResource(resource);
        Catalog.getCurrentCatalog().getEditLog().logCreateResource(resource);
        LOG.info("create resource success. resource: {}", (Object)resource);
    }

    public void createResource(Resource resource) throws DdlException {
        String resourceName = resource.getName();
        if (this.nameToResource.putIfAbsent(resourceName, resource) != null) {
            throw new DdlException("Resource(" + resourceName + ") already exist");
        }
    }

    public void replayCreateResource(Resource resource) {
        this.nameToResource.put(resource.getName(), resource);
    }

    public void dropResource(DropResourceStmt stmt) throws DdlException {
        String name = stmt.getResourceName();
        if (this.nameToResource.remove(name) == null) {
            throw new DdlException("Resource(" + name + ") does not exist");
        }
        Catalog.getCurrentCatalog().getEditLog().logDropResource(new DropResourceOperationLog(name));
        LOG.info("drop resource success. resource name: {}", (Object)name);
    }

    public void dropResource(Resource resource) {
        String name = resource.getName();
        if (this.nameToResource.remove(name) == null) {
            LOG.info("resource " + name + " does not exists.");
            return;
        }
    }

    public void replayDropResource(DropResourceOperationLog operationLog) {
        this.nameToResource.remove(operationLog.getName());
    }

    public boolean containsResource(String name) {
        return this.nameToResource.containsKey(name);
    }

    public Resource getResource(String name) {
        return this.nameToResource.get(name);
    }

    public int getResourceNum() {
        return this.nameToResource.size();
    }

    public List<List<Comparable>> getResourcesInfo(String name, boolean accurateMatch, Set<String> typeSets) {
        List<List<String>> targetRows = this.procNode.fetchResult().getRows();
        ArrayList returnRows = Lists.newArrayList();
        for (List<String> row : targetRows) {
            if (row == null || row.size() < 2) continue;
            String resourceName = row.get(0);
            String resourceType = row.get(1);
            if (name != null && (accurateMatch && !resourceName.equals(name) || !accurateMatch && !resourceName.contains(name)) || typeSets != null && !typeSets.contains(resourceType.toUpperCase())) continue;
            ArrayList comparableRow = Lists.newArrayList();
            for (Comparable comparable : row) {
                comparableRow.add(comparable);
            }
            returnRows.add(comparableRow);
        }
        return returnRows;
    }

    public ResourceProcNode getProcNode() {
        return this.procNode;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static ResourceMgr read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (ResourceMgr)GsonUtils.GSON.fromJson(json, ResourceMgr.class);
    }

    public static int analyzeColumn(String columnName) throws AnalysisException {
        for (String title : RESOURCE_PROC_NODE_TITLE_NAMES) {
            if (!title.equalsIgnoreCase(columnName)) continue;
            return RESOURCE_PROC_NODE_TITLE_NAMES.indexOf((Object)title);
        }
        throw new AnalysisException("Title name[" + columnName + "] does not exist");
    }

    public class ResourceProcNode
    implements ProcNodeInterface {
        @Override
        public ProcResult fetchResult() {
            BaseProcResult result = new BaseProcResult();
            result.setNames((List<String>)RESOURCE_PROC_NODE_TITLE_NAMES);
            for (Map.Entry entry : ResourceMgr.this.nameToResource.entrySet()) {
                Resource resource = (Resource)entry.getValue();
                if (!Catalog.getCurrentCatalog().getAuth().checkResourcePriv(ConnectContext.get(), resource.getName(), PrivPredicate.SHOW)) continue;
                resource.getProcNodeData(result);
            }
            return result;
        }
    }
}

