/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.doris.catalog.ResourceType;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TResourceGroup;
import org.apache.doris.thrift.TResourceType;

public class ResourceGroup
implements Writable {
    private EnumMap<ResourceType, Integer> quotaByType = Maps.newEnumMap(ResourceType.class);

    private ResourceGroup() {
    }

    private ResourceGroup(int cpuShare) {
        this.quotaByType.put(ResourceType.CPU_SHARE, cpuShare);
    }

    public ResourceGroup getCopiedResourceGroup() {
        ResourceGroup resourceGroup = new ResourceGroup();
        resourceGroup.quotaByType = Maps.newEnumMap(this.quotaByType);
        return resourceGroup;
    }

    public void updateByDesc(String desc, int value) throws DdlException {
        ResourceType type = ResourceType.fromDesc(desc);
        if (type == null) {
            throw new DdlException("Unknown resource type(" + desc + ")");
        }
        if (!(type != ResourceType.CPU_SHARE && type != ResourceType.IO_SHARE || value >= 100 && value <= 1000)) {
            throw new DdlException("Value for resource type(" + desc + ") has to be in [100, 1000]");
        }
        this.quotaByType.put(type, value);
    }

    public int getByDesc(String desc) throws DdlException {
        ResourceType type = ResourceType.fromDesc(desc);
        if (type == null) {
            throw new DdlException("Unknown resource type(" + desc + ")");
        }
        return this.quotaByType.get((Object)type);
    }

    public Map<ResourceType, Integer> getQuotaMap() {
        return this.quotaByType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TResourceGroup toThrift() {
        TResourceGroup tgroup = new TResourceGroup();
        for (Map.Entry<ResourceType, Integer> entry : this.quotaByType.entrySet()) {
            tgroup.putToResourceByType(entry.getKey().toThrift(), entry.getValue().intValue());
        }
        return tgroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        for (Map.Entry<ResourceType, Integer> entry : this.quotaByType.entrySet()) {
            if (idx++ != 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey().toString()).append(" = ").append(entry.getValue());
        }
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.quotaByType.size());
        for (Map.Entry<ResourceType, Integer> entry : this.quotaByType.entrySet()) {
            out.writeInt(entry.getKey().toThrift().getValue());
            out.writeInt(entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numResource = in.readInt();
        for (int i = 0; i < numResource; ++i) {
            int code = in.readInt();
            int value = in.readInt();
            this.quotaByType.put(ResourceType.fromThrift(TResourceType.findByValue((int)code)), value);
        }
    }

    public static ResourceGroup readIn(DataInput in) throws IOException {
        ResourceGroup group = new ResourceGroup();
        group.readFields(in);
        return group;
    }

    public static class Builder {
        private int cpuShare = ResourceType.CPU_SHARE.getDefaultValue();

        public ResourceGroup build() {
            return new ResourceGroup(this.cpuShare);
        }

        public Builder cpuShare(int share) {
            this.cpuShare = share;
            return this;
        }
    }
}

