/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.analysis.CreateResourceStmt;
import org.apache.doris.catalog.OdbcCatalogResource;
import org.apache.doris.catalog.SparkResource;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.DeepCopy;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Resource
implements Writable {
    private static final Logger LOG = LogManager.getLogger(OdbcCatalogResource.class);
    @SerializedName(value="name")
    protected String name;
    @SerializedName(value="type")
    protected ResourceType type;

    public Resource() {
    }

    public Resource(String name, ResourceType type) {
        this.name = name;
        this.type = type;
    }

    public static Resource fromStmt(CreateResourceStmt stmt) throws DdlException {
        Resource resource = null;
        ResourceType type = stmt.getResourceType();
        switch (type) {
            case SPARK: {
                resource = new SparkResource(stmt.getResourceName());
                break;
            }
            case ODBC_CATALOG: {
                resource = new OdbcCatalogResource(stmt.getResourceName());
                break;
            }
            default: {
                throw new DdlException("Only support Spark resource.");
            }
        }
        resource.setProperties(stmt.getProperties());
        return resource;
    }

    public String getName() {
        return this.name;
    }

    public ResourceType getType() {
        return this.type;
    }

    protected abstract void setProperties(Map<String, String> var1) throws DdlException;

    protected abstract void getProcNodeData(BaseProcResult var1);

    public String toString() {
        return GsonUtils.GSON.toJson((Object)this);
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static Resource read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (Resource)GsonUtils.GSON.fromJson(json, Resource.class);
    }

    public Resource clone() {
        Resource copied = (Resource)DeepCopy.copy((Writable)this, Resource.class, (int)FeConstants.meta_version);
        if (copied == null) {
            LOG.warn("failed to clone odbc resource: " + this.getName());
            return null;
        }
        return copied;
    }

    public static enum ResourceType {
        UNKNOWN,
        SPARK,
        ODBC_CATALOG;


        public static ResourceType fromString(String resourceType) {
            for (ResourceType type : ResourceType.values()) {
                if (!type.name().equalsIgnoreCase(resourceType)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

