/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.clearspring.analytics.util.Lists;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;

public class ReplicaAllocation
implements Writable {
    public static final ReplicaAllocation DEFAULT_ALLOCATION = new ReplicaAllocation(3);
    public static final ReplicaAllocation NOT_SET = new ReplicaAllocation();
    @SerializedName(value="allocMap")
    private Map<Tag, Short> allocMap = Maps.newHashMap();

    public ReplicaAllocation() {
    }

    public ReplicaAllocation(short replicaNum) {
        this.allocMap.put(Tag.DEFAULT_BACKEND_TAG, replicaNum);
    }

    public ReplicaAllocation(Map<Tag, Short> allocMap) {
        this.allocMap = allocMap;
    }

    public void put(Tag tag, Short num) {
        this.allocMap.put(tag, num);
    }

    public Map<Tag, Short> getAllocMap() {
        return this.allocMap;
    }

    public short getTotalReplicaNum() {
        short num = 0;
        for (Short s : this.allocMap.values()) {
            num = (short)(num + s);
        }
        return num;
    }

    public boolean isEmpty() {
        return this.allocMap.isEmpty();
    }

    public boolean isNotSet() {
        return this.equals(NOT_SET);
    }

    public Short getReplicaNumByTag(Tag tag) {
        return this.allocMap.getOrDefault(tag, (short)0);
    }

    public static ReplicaAllocation read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (ReplicaAllocation)GsonUtils.GSON.fromJson(json, ReplicaAllocation.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaAllocation that = (ReplicaAllocation)o;
        return that.allocMap.equals(this.allocMap);
    }

    public int hashCode() {
        return Objects.hash(this.allocMap);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public String toString() {
        return this.toCreateStmt();
    }

    public String toCreateStmt() {
        List tags = Lists.newArrayList();
        for (Map.Entry<Tag, Short> entry : this.allocMap.entrySet()) {
            tags.add("tag.location." + entry.getKey().value + ": " + entry.getValue());
        }
        return Joiner.on((String)", ").join((Iterable)tags);
    }
}

