/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Replica
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Replica.class);
    public static final VersionComparator<Replica> VERSION_DESC_COMPARATOR = new VersionComparator();
    @SerializedName(value="id")
    private long id;
    @SerializedName(value="backendId")
    private long backendId;
    @SerializedName(value="version")
    private volatile long version;
    @Deprecated
    @SerializedName(value="versionHash")
    private long versionHash = 0L;
    private int schemaHash = -1;
    @SerializedName(value="dataSize")
    private volatile long dataSize = 0L;
    @SerializedName(value="rowCount")
    private volatile long rowCount = 0L;
    @SerializedName(value="state")
    private volatile ReplicaState state;
    @SerializedName(value="lastFailedVersion")
    private long lastFailedVersion = -1L;
    @Deprecated
    @SerializedName(value="lastFailedVersionHash")
    private long lastFailedVersionHash = 0L;
    private long lastFailedTimestamp = 0L;
    @SerializedName(value="lastSuccessVersion")
    private long lastSuccessVersion = -1L;
    @Deprecated
    @SerializedName(value="lastSuccessVersionHash")
    private long lastSuccessVersionHash = 0L;
    private volatile long versionCount = -1L;
    private long pathHash = -1L;
    private boolean bad = false;
    private boolean needFurtherRepair = false;
    private long furtherRepairSetTime = -1L;
    private static final long FURTHER_REPAIR_TIMEOUT_MS = 1200000L;
    private long watermarkTxnId = -1L;

    public Replica() {
    }

    public Replica(long replicaId, long backendId, int schemaHash, ReplicaState state) {
        this(replicaId, backendId, -1L, schemaHash, 0L, 0L, state, -1L, -1L);
    }

    public Replica(long replicaId, long backendId, ReplicaState state, long version, int schemaHash) {
        this(replicaId, backendId, version, schemaHash, 0L, 0L, state, -1L, version);
    }

    public Replica(long replicaId, long backendId, long version, int schemaHash, long dataSize, long rowCount, ReplicaState state, long lastFailedVersion, long lastSuccessVersion) {
        this.id = replicaId;
        this.backendId = backendId;
        this.version = version;
        this.schemaHash = schemaHash;
        this.dataSize = dataSize;
        this.rowCount = rowCount;
        this.state = state;
        if (this.state == null) {
            this.state = ReplicaState.NORMAL;
        }
        this.lastFailedVersion = lastFailedVersion;
        if (this.lastFailedVersion > 0L) {
            this.lastFailedTimestamp = System.currentTimeMillis();
        }
        this.lastSuccessVersion = lastSuccessVersion < this.version ? this.version : lastSuccessVersion;
    }

    public long getVersion() {
        return this.version;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public void setSchemaHash(int schemaHash) {
        this.schemaHash = schemaHash;
    }

    public long getId() {
        return this.id;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getLastFailedVersion() {
        return this.lastFailedVersion;
    }

    public long getLastFailedTimestamp() {
        return this.lastFailedTimestamp;
    }

    public long getLastSuccessVersion() {
        return this.lastSuccessVersion;
    }

    public long getPathHash() {
        return this.pathHash;
    }

    public void setPathHash(long pathHash) {
        this.pathHash = pathHash;
    }

    public boolean isBad() {
        return this.bad;
    }

    public boolean setBad(boolean bad) {
        if (this.bad == bad) {
            return false;
        }
        this.bad = bad;
        return true;
    }

    public boolean needFurtherRepair() {
        return this.needFurtherRepair && System.currentTimeMillis() - this.furtherRepairSetTime < 1200000L;
    }

    public void setNeedFurtherRepair(boolean needFurtherRepair) {
        this.needFurtherRepair = needFurtherRepair;
        this.furtherRepairSetTime = System.currentTimeMillis();
    }

    public synchronized void updateStat(long dataSize, long rowNum) {
        this.dataSize = dataSize;
        this.rowCount = rowNum;
    }

    public synchronized void updateStat(long dataSize, long rowNum, long versionCount) {
        this.dataSize = dataSize;
        this.rowCount = rowNum;
        this.versionCount = versionCount;
    }

    public synchronized void updateVersionInfo(long newVersion, long newDataSize, long newRowCount) {
        this.updateReplicaInfo(newVersion, this.lastFailedVersion, this.lastSuccessVersion, newDataSize, newRowCount);
    }

    public synchronized void updateVersionWithFailedInfo(long newVersion, long lastFailedVersion, long lastSuccessVersion) {
        this.updateReplicaInfo(newVersion, lastFailedVersion, lastSuccessVersion, this.dataSize, this.rowCount);
    }

    public void updateVersionInfoForRecovery(long newVersion, long lastFailedVersion, long lastSuccessVersion) {
        LOG.warn("update replica {} on backend {}'s version for recovery. version: {}:{}. last failed version: {}:{}, last success version: {}:{}", (Object)this.id, (Object)this.backendId, (Object)this.version, (Object)newVersion, (Object)this.lastFailedVersion, (Object)lastFailedVersion, (Object)this.lastSuccessVersion, (Object)lastSuccessVersion);
        this.version = newVersion;
        this.lastFailedVersion = lastFailedVersion;
        this.lastSuccessVersion = lastSuccessVersion;
    }

    private void updateReplicaInfo(long newVersion, long lastFailedVersion, long lastSuccessVersion, long newDataSize, long newRowCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("before update: {}", (Object)this.toString());
        }
        if (newVersion < this.version) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("replica {} on backend {}'s new version {} is lower than meta version {},not to continue to update replica", (Object)this.id, (Object)this.backendId, (Object)newVersion, (Object)this.version);
            }
            return;
        }
        this.version = newVersion;
        this.dataSize = newDataSize;
        this.rowCount = newRowCount;
        if (lastSuccessVersion <= this.version) {
            lastSuccessVersion = this.version;
        }
        if (this.lastSuccessVersion <= this.lastFailedVersion) {
            this.lastSuccessVersion = this.version;
        }
        if (this.version > lastFailedVersion && lastFailedVersion > 0L) {
            LOG.debug("current version {} is larger than last failed version {}, maybe a fatal error or be report version, print a stack here ", (Object)this.version, (Object)lastFailedVersion, (Object)new Exception());
        }
        if (lastFailedVersion != this.lastFailedVersion) {
            if (lastFailedVersion > this.lastFailedVersion) {
                this.lastFailedVersion = lastFailedVersion;
                this.lastFailedTimestamp = System.currentTimeMillis();
            }
            this.lastSuccessVersion = this.version;
        } else {
            if (lastSuccessVersion >= this.lastSuccessVersion) {
                this.lastSuccessVersion = lastSuccessVersion;
            }
            if (lastFailedVersion >= this.lastSuccessVersion) {
                this.lastSuccessVersion = this.version;
            }
        }
        if (this.version >= this.lastFailedVersion) {
            this.lastFailedVersion = -1L;
            this.lastFailedVersionHash = 0L;
            this.lastFailedTimestamp = -1L;
            if (this.version < this.lastSuccessVersion) {
                this.version = this.lastSuccessVersion;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("after update {}", (Object)this.toString());
        }
    }

    public synchronized void updateLastFailedVersion(long lastFailedVersion) {
        this.updateReplicaInfo(this.version, lastFailedVersion, this.lastSuccessVersion, this.dataSize, this.rowCount);
    }

    public boolean checkVersionCatchUp(long expectedVersion, boolean ignoreAlter) {
        if (ignoreAlter && this.state == ReplicaState.ALTER && this.version == 1L) {
            return true;
        }
        if (expectedVersion == 1L) {
            return true;
        }
        if (this.version < expectedVersion) {
            LOG.debug("replica version does not catch up with version: {}. replica: {}", (Object)expectedVersion, (Object)this);
            return false;
        }
        return true;
    }

    public void setLastFailedVersion(long lastFailedVersion) {
        this.lastFailedVersion = lastFailedVersion;
    }

    public void setState(ReplicaState replicaState) {
        this.state = replicaState;
    }

    public ReplicaState getState() {
        return this.state;
    }

    public boolean tooSlow() {
        return this.state == ReplicaState.COMPACTION_TOO_SLOW;
    }

    public long getVersionCount() {
        return this.versionCount;
    }

    public void setVersionCount(long versionCount) {
        this.versionCount = versionCount;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer("[replicaId=");
        strBuffer.append(this.id);
        strBuffer.append(", BackendId=");
        strBuffer.append(this.backendId);
        strBuffer.append(", version=");
        strBuffer.append(this.version);
        strBuffer.append(", dataSize=");
        strBuffer.append(this.dataSize);
        strBuffer.append(", rowCount=");
        strBuffer.append(this.rowCount);
        strBuffer.append(", lastFailedVersion=");
        strBuffer.append(this.lastFailedVersion);
        strBuffer.append(", lastSuccessVersion=");
        strBuffer.append(this.lastSuccessVersion);
        strBuffer.append(", lastFailedTimestamp=");
        strBuffer.append(this.lastFailedTimestamp);
        strBuffer.append(", schemaHash=");
        strBuffer.append(this.schemaHash);
        strBuffer.append(", state=");
        strBuffer.append(this.state.name());
        strBuffer.append("]");
        return strBuffer.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.backendId);
        out.writeLong(this.version);
        out.writeLong(this.versionHash);
        out.writeLong(this.dataSize);
        out.writeLong(this.rowCount);
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeLong(this.lastFailedVersion);
        out.writeLong(this.lastFailedVersionHash);
        out.writeLong(this.lastSuccessVersion);
        out.writeLong(this.lastSuccessVersionHash);
    }

    public void readFields(DataInput in) throws IOException {
        this.id = in.readLong();
        this.backendId = in.readLong();
        this.version = in.readLong();
        this.versionHash = in.readLong();
        this.dataSize = in.readLong();
        this.rowCount = in.readLong();
        this.state = ReplicaState.valueOf(Text.readString((DataInput)in));
        this.lastFailedVersion = in.readLong();
        this.lastFailedVersionHash = in.readLong();
        this.lastSuccessVersion = in.readLong();
        this.lastSuccessVersionHash = in.readLong();
    }

    public static Replica read(DataInput in) throws IOException {
        Replica replica = new Replica();
        replica.readFields(in);
        return replica;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Replica)) {
            return false;
        }
        Replica replica = (Replica)obj;
        return this.id == replica.id && this.backendId == replica.backendId && this.version == replica.version && this.dataSize == replica.dataSize && this.rowCount == replica.rowCount && this.state.equals((Object)replica.state) && this.lastFailedVersion == replica.lastFailedVersion && this.lastSuccessVersion == replica.lastSuccessVersion;
    }

    public void setWatermarkTxnId(long watermarkTxnId) {
        this.watermarkTxnId = watermarkTxnId;
    }

    public long getWatermarkTxnId() {
        return this.watermarkTxnId;
    }

    public boolean isAlive() {
        return this.getState() != ReplicaState.CLONE && this.getState() != ReplicaState.DECOMMISSION && !this.isBad();
    }

    private static class VersionComparator<T extends Replica>
    implements Comparator<T> {
        @Override
        public int compare(T replica1, T replica2) {
            if (((Replica)replica1).getVersion() < ((Replica)replica2).getVersion()) {
                return 1;
            }
            if (((Replica)replica1).getVersion() == ((Replica)replica2).getVersion()) {
                return 0;
            }
            return -1;
        }
    }

    public static enum ReplicaStatus {
        OK,
        DEAD,
        VERSION_ERROR,
        MISSING,
        SCHEMA_ERROR,
        BAD;

    }

    public static enum ReplicaState {
        NORMAL,
        ROLLUP,
        SCHEMA_CHANGE,
        CLONE,
        ALTER,
        DECOMMISSION,
        COMPACTION_TOO_SLOW;


        public boolean canLoad() {
            return this == NORMAL || this == SCHEMA_CHANGE || this == ALTER || this == COMPACTION_TOO_SLOW;
        }

        public boolean canQuery() {
            return this == NORMAL || this == SCHEMA_CHANGE;
        }
    }
}

