/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import java.util.Map;
import org.apache.doris.analysis.CreateTableStmt;
import org.apache.doris.analysis.DropTableStmt;
import org.apache.doris.analysis.RefreshDbStmt;
import org.apache.doris.analysis.RefreshTableStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RefreshManager {
    private static final Logger LOG = LogManager.getLogger(RefreshManager.class);

    public void handleRefreshTable(RefreshTableStmt stmt) throws UserException {
        String dbName = stmt.getDbName();
        String tableName = stmt.getTblName();
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrDdlException(dbName);
        Table table = db.getTableNullable(tableName);
        if (!(table instanceof IcebergTable)) {
            throw new DdlException("Only support refresh Iceberg table.");
        }
        Map<String, String> icebergProperties = ((IcebergTable)table).getIcebergProperties();
        icebergProperties.put("iceberg.table", ((IcebergTable)table).getIcebergTbl());
        icebergProperties.put("iceberg.database", ((IcebergTable)table).getIcebergDb());
        DropTableStmt dropTableStmt = new DropTableStmt(true, stmt.getTableName(), true);
        catalog.dropTable(dropTableStmt);
        CreateTableStmt createTableStmt = new CreateTableStmt(true, true, stmt.getTableName(), "ICEBERG", icebergProperties, "");
        catalog.createTable(createTableStmt);
        LOG.info("Successfully refresh table: {} from db: {}", (Object)tableName, (Object)dbName);
    }

    public void handleRefreshDb(RefreshDbStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrDdlException(dbName);
        db.getDbProperties().checkAndBuildProperties();
        if (!db.getDbProperties().getIcebergProperty().isExist()) {
            throw new DdlException("Only support refresh Iceberg database.");
        }
        for (Table table : db.getTables()) {
            if (!(table instanceof IcebergTable)) continue;
            DropTableStmt dropTableStmt = new DropTableStmt(true, new TableName(dbName, table.getName()), true);
            catalog.dropTable(dropTableStmt);
        }
        catalog.getIcebergTableCreationRecordMgr().registerDb(db);
        LOG.info("Successfully refresh db: {}", (Object)dbName);
    }
}

