/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Range;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.common.util.RangeUtils;

public class RangePartitionItem
extends PartitionItem {
    private Range<PartitionKey> partitionKeyRange;
    public static final Range<PartitionKey> DUMMY_ITEM = Range.closed((Comparable)new PartitionKey(), (Comparable)new PartitionKey());

    public RangePartitionItem(Range<PartitionKey> range) {
        this.partitionKeyRange = range;
    }

    public Range<PartitionKey> getItems() {
        return this.partitionKeyRange;
    }

    public void write(DataOutput out) throws IOException {
        RangeUtils.writeRange(out, this.partitionKeyRange);
    }

    @Override
    public int compareTo(PartitionItem other) {
        if (this.partitionKeyRange.contains((Comparable)((PartitionKey)other.getItems()))) {
            return 1;
        }
        if (this.partitionKeyRange.equals(((RangePartitionItem)other).getItems())) {
            return 0;
        }
        return -1;
    }

    @Override
    public PartitionItem getIntersect(PartitionItem newItem) {
        Range intersection;
        Range newRange = (Range)newItem.getItems();
        if (this.partitionKeyRange.isConnected(newRange) && !(intersection = this.partitionKeyRange.intersection(newRange)).isEmpty()) {
            return new RangePartitionItem((Range<PartitionKey>)intersection);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangePartitionItem) {
            return this.partitionKeyRange.equals(((RangePartitionItem)obj).getItems());
        }
        return false;
    }

    public String toString() {
        return this.partitionKeyRange.toString();
    }
}

