/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.util.RangeUtils;

public class RangePartitionInfo
extends PartitionInfo {
    public RangePartitionInfo() {
    }

    public RangePartitionInfo(List<Column> partitionColumns) {
        super(PartitionType.RANGE);
        this.partitionColumns = partitionColumns;
        this.isMultiColumnPartition = partitionColumns.size() > 1;
    }

    @Override
    public PartitionItem createAndCheckPartitionItem(SinglePartitionDesc desc, boolean isTemp) throws DdlException {
        Range<PartitionKey> newRange = null;
        PartitionKeyDesc partitionKeyDesc = desc.getPartitionKeyDesc();
        try {
            newRange = this.createAndCheckNewRange(partitionKeyDesc, isTemp);
        }
        catch (AnalysisException e) {
            throw new DdlException("Invalid range value format\uff1a " + e.getMessage());
        }
        Preconditions.checkNotNull(newRange);
        return new RangePartitionItem(newRange);
    }

    @Override
    public List<Map.Entry<Long, PartitionItem>> getPartitionItemEntryList(boolean isTemp, boolean isSorted) {
        Map tmpMap = this.idToItem;
        if (isTemp) {
            tmpMap = this.idToTempItem;
        }
        ArrayList itemEntryList = Lists.newArrayList(tmpMap.entrySet());
        if (isSorted) {
            Collections.sort(itemEntryList, RangeUtils.RANGE_MAP_ENTRY_COMPARATOR);
        }
        return itemEntryList;
    }

    private Range<PartitionKey> createAndCheckNewRange(PartitionKeyDesc partKeyDesc, boolean isTemp) throws AnalysisException, DdlException {
        List<Map.Entry<Long, PartitionItem>> partitionItemEntryList;
        boolean isFixedPartitionKeyValueType = partKeyDesc.getPartitionType() == PartitionKeyDesc.PartitionKeyValueType.FIXED;
        List<Map.Entry<Long, PartitionItem>> list = partitionItemEntryList = isFixedPartitionKeyValueType ? this.getPartitionItemEntryList(isTemp, false) : this.getPartitionItemEntryList(isTemp, true);
        if (isFixedPartitionKeyValueType) {
            return this.createNewRangeForFixedPartitionValueType(partKeyDesc, partitionItemEntryList);
        }
        Range<PartitionKey> newRange = null;
        PartitionKey newRangeUpper = null;
        newRangeUpper = partKeyDesc.isMax() ? PartitionKey.createInfinityPartitionKey(this.partitionColumns, true) : PartitionKey.createPartitionKey(partKeyDesc.getUpperValues(), this.partitionColumns);
        if (newRangeUpper.isMinValue()) {
            throw new DdlException("Partition's upper value should not be MIN VALUE: " + partKeyDesc.toSql());
        }
        Range lastRange = null;
        Range currentRange = null;
        for (Map.Entry<Long, PartitionItem> entry : partitionItemEntryList) {
            currentRange = (Range)entry.getValue().getItems();
            PartitionKey upperKey = (PartitionKey)currentRange.upperEndpoint();
            if (upperKey.compareTo(newRangeUpper) >= 0) {
                newRange = this.createNewRangeForLessThanPartitionValueType(newRangeUpper, (Range<PartitionKey>)lastRange, (Range<PartitionKey>)currentRange);
                break;
            }
            lastRange = currentRange;
        }
        if (newRange == null) {
            newRange = this.createNewRangeForLessThanPartitionValueType(newRangeUpper, lastRange, currentRange);
        }
        return newRange;
    }

    private Range<PartitionKey> createNewRangeForFixedPartitionValueType(PartitionKeyDesc partKeyDesc, List<Map.Entry<Long, PartitionItem>> partitionItemEntryList) throws AnalysisException, DdlException {
        PartitionKey upperKey;
        PartitionKey lowKey = PartitionKey.createPartitionKey(partKeyDesc.getLowerValues(), this.partitionColumns);
        if (lowKey.compareTo(upperKey = PartitionKey.createPartitionKey(partKeyDesc.getUpperValues(), this.partitionColumns)) >= 0) {
            throw new AnalysisException("The lower values must smaller than upper values");
        }
        Range newRange = Range.closedOpen((Comparable)lowKey, (Comparable)upperKey);
        for (Map.Entry<Long, PartitionItem> partitionItemEntry : partitionItemEntryList) {
            RangeUtils.checkRangeIntersect((Range<PartitionKey>)newRange, (Range<PartitionKey>)((Range)partitionItemEntry.getValue().getItems()));
        }
        return newRange;
    }

    private Range<PartitionKey> createNewRangeForLessThanPartitionValueType(PartitionKey newRangeUpper, Range<PartitionKey> lastRange, Range<PartitionKey> currentRange) throws AnalysisException, DdlException {
        PartitionKey lowKey;
        PartitionKey partitionKey = lowKey = lastRange == null ? PartitionKey.createInfinityPartitionKey(this.partitionColumns, false) : (PartitionKey)lastRange.upperEndpoint();
        if (lowKey.compareTo(newRangeUpper) >= 0) {
            throw new AnalysisException("The lower values must smaller than upper values");
        }
        Range newRange = Range.closedOpen((Comparable)lowKey, (Comparable)newRangeUpper);
        if (currentRange != null) {
            RangeUtils.checkRangeIntersect((Range<PartitionKey>)newRange, currentRange);
        }
        return newRange;
    }

    public static void checkPartitionColumn(Column column) throws AnalysisException {
        PrimitiveType type = column.getDataType();
        if (!type.isFixedPointType() && !type.isDateType()) {
            throw new AnalysisException("Column[" + column.getName() + "] type[" + (Object)((Object)type) + "] cannot be a range partition key.");
        }
    }

    @Override
    public void checkPartitionItemListsMatch(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        RangeUtils.checkPartitionItemListsMatch(list1, list2);
    }

    @Override
    public void checkPartitionItemListsConflict(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        RangeUtils.checkRangeConflict(list1, list2);
    }

    public static PartitionInfo read(DataInput in) throws IOException {
        RangePartitionInfo partitionInfo = new RangePartitionInfo();
        ((PartitionInfo)partitionInfo).readFields(in);
        return partitionInfo;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.partitionColumns.size());
        for (Column column : this.partitionColumns) {
            column.write(out);
        }
        out.writeInt(this.idToItem.size());
        for (Map.Entry entry : this.idToItem.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((PartitionItem)entry.getValue()).write(out);
        }
        out.writeInt(this.idToTempItem.size());
        for (Map.Entry entry : this.idToTempItem.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((PartitionItem)entry.getValue()).write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Range<PartitionKey> range;
        int i;
        super.readFields(in);
        int counter = in.readInt();
        for (i = 0; i < counter; ++i) {
            Column column = Column.read(in);
            this.partitionColumns.add(column);
        }
        this.isMultiColumnPartition = this.partitionColumns.size() > 1;
        counter = in.readInt();
        for (i = 0; i < counter; ++i) {
            long partitionId = in.readLong();
            range = RangeUtils.readRange(in);
            this.idToItem.put(partitionId, new RangePartitionItem(range));
        }
        counter = in.readInt();
        for (i = 0; i < counter; ++i) {
            long partitionId = in.readLong();
            range = RangeUtils.readRange(in);
            this.idToTempItem.put(partitionId, new RangePartitionItem(range));
        }
    }

    @Override
    public String toSql(OlapTable table, List<Long> partitionId) {
        StringBuilder sb = new StringBuilder();
        sb.append("PARTITION BY RANGE(");
        int idx = 0;
        for (Column column : this.partitionColumns) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append("`").append(column.getName()).append("`");
            ++idx;
        }
        sb.append(")\n(");
        ArrayList entries = new ArrayList(this.idToItem.entrySet());
        Collections.sort(entries, RangeUtils.RANGE_MAP_ENTRY_COMPARATOR);
        idx = 0;
        for (Map.Entry entry : entries) {
            Partition partition = table.getPartition((Long)entry.getKey());
            String partitionName = partition.getName();
            Range range = (Range)((PartitionItem)entry.getValue()).getItems();
            sb.append("PARTITION ").append(partitionName).append(" VALUES [");
            sb.append(((PartitionKey)range.lowerEndpoint()).toSql());
            sb.append(", ").append(((PartitionKey)range.upperEndpoint()).toSql()).append(")");
            if (partitionId != null) {
                partitionId.add((Long)entry.getKey());
                break;
            }
            if (idx != entries.size() - 1) {
                sb.append(",\n");
            }
            ++idx;
        }
        sb.append(")");
        return sb.toString();
    }
}

