/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.RandomDistributionDesc;
import org.apache.doris.catalog.DistributionInfo;

public class RandomDistributionInfo
extends DistributionInfo {
    private int bucketNum;

    public RandomDistributionInfo() {
    }

    public RandomDistributionInfo(int bucketNum) {
        super(DistributionInfo.DistributionInfoType.RANDOM);
        this.bucketNum = bucketNum;
    }

    @Override
    public DistributionDesc toDistributionDesc() {
        RandomDistributionDesc distributionDesc = new RandomDistributionDesc(this.bucketNum);
        return distributionDesc;
    }

    @Override
    public int getBucketNum() {
        return this.bucketNum;
    }

    @Override
    public String toSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("DISTRIBUTED BY RANDOM BUCKETS ").append(this.bucketNum);
        return builder.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.bucketNum);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.bucketNum = in.readInt();
    }

    public static DistributionInfo read(DataInput in) throws IOException {
        RandomDistributionInfo distributionInfo = new RandomDistributionInfo();
        ((DistributionInfo)distributionInfo).readFields(in);
        return distributionInfo;
    }

    @Override
    public boolean equals(DistributionInfo info) {
        if (this == info) {
            return true;
        }
        if (!(info instanceof RandomDistributionInfo)) {
            return false;
        }
        RandomDistributionInfo randomDistributionInfo = (RandomDistributionInfo)info;
        return this.type == randomDistributionInfo.type && this.bucketNum == randomDistributionInfo.bucketNum;
    }
}

