/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.mysql.MysqlColType;
import org.apache.doris.thrift.TPrimitiveType;

public enum PrimitiveType {
    INVALID_TYPE("INVALID_TYPE", -1, TPrimitiveType.INVALID_TYPE),
    NULL_TYPE("NULL_TYPE", 1, TPrimitiveType.NULL_TYPE),
    BOOLEAN("BOOLEAN", 1, TPrimitiveType.BOOLEAN),
    TINYINT("TINYINT", 1, TPrimitiveType.TINYINT),
    SMALLINT("SMALLINT", 2, TPrimitiveType.SMALLINT),
    INT("INT", 4, TPrimitiveType.INT),
    BIGINT("BIGINT", 8, TPrimitiveType.BIGINT),
    LARGEINT("LARGEINT", 16, TPrimitiveType.LARGEINT),
    FLOAT("FLOAT", 4, TPrimitiveType.FLOAT),
    DOUBLE("DOUBLE", 8, TPrimitiveType.DOUBLE),
    DATE("DATE", 16, TPrimitiveType.DATE),
    DATETIME("DATETIME", 16, TPrimitiveType.DATETIME),
    CHAR("CHAR", 16, TPrimitiveType.CHAR),
    VARCHAR("VARCHAR", 16, TPrimitiveType.VARCHAR),
    DECIMALV2("DECIMALV2", 16, TPrimitiveType.DECIMALV2),
    HLL("HLL", 16, TPrimitiveType.HLL),
    TIME("TIME", 8, TPrimitiveType.TIME),
    BITMAP("BITMAP", 16, TPrimitiveType.OBJECT),
    ARRAY("ARRAY", 24, TPrimitiveType.ARRAY),
    MAP("MAP", 24, TPrimitiveType.MAP),
    STRUCT("MAP", 24, TPrimitiveType.STRUCT),
    STRING("STRING", 16, TPrimitiveType.STRING),
    BINARY("BINARY", -1, TPrimitiveType.BINARY),
    ALL("ALL", -1, TPrimitiveType.INVALID_TYPE);

    private static final int DATE_INDEX_LEN = 3;
    private static final int DATETIME_INDEX_LEN = 8;
    private static final int VARCHAR_INDEX_LEN = 20;
    private static final int STRING_INDEX_LEN = 20;
    private static final int DECIMAL_INDEX_LEN = 12;
    private static ImmutableSetMultimap<PrimitiveType, PrimitiveType> implicitCastMap;
    private static ArrayList<PrimitiveType> integerTypes;
    private static ArrayList<PrimitiveType> numericTypes;
    private static ArrayList<PrimitiveType> supportedTypes;
    private static PrimitiveType[][] compatibilityMatrix;
    private final String description;
    private final int slotSize;
    private final TPrimitiveType thriftType;
    private boolean isTimeType = false;

    public static ArrayList<PrimitiveType> getIntegerTypes() {
        return integerTypes;
    }

    public static ArrayList<PrimitiveType> getNumericTypes() {
        return numericTypes;
    }

    public static ArrayList<PrimitiveType> getSupportedTypes() {
        return supportedTypes;
    }

    public static boolean isImplicitCast(PrimitiveType type, PrimitiveType target) {
        return implicitCastMap.get((Object)type).contains((Object)target);
    }

    private PrimitiveType(String description, int slotSize, TPrimitiveType thriftType) {
        this.description = description;
        this.slotSize = slotSize;
        this.thriftType = thriftType;
    }

    public void setTimeType() {
        this.isTimeType = true;
    }

    public boolean isTimeType() {
        return this.isTimeType;
    }

    public static PrimitiveType fromThrift(TPrimitiveType tPrimitiveType) {
        switch (tPrimitiveType) {
            case NULL_TYPE: {
                return NULL_TYPE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case BINARY: {
                return BINARY;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case TIME: {
                return TIME;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case STRING: {
                return STRING;
            }
            case CHAR: {
                return CHAR;
            }
            case HLL: {
                return HLL;
            }
            case OBJECT: {
                return BITMAP;
            }
            case ARRAY: {
                return ARRAY;
            }
            case MAP: {
                return MAP;
            }
            case STRUCT: {
                return STRUCT;
            }
            case ALL: {
                return ALL;
            }
        }
        return INVALID_TYPE;
    }

    public static List<TPrimitiveType> toThrift(PrimitiveType[] types) {
        ArrayList result = Lists.newArrayList();
        for (PrimitiveType t : types) {
            result.add(t.toThrift());
        }
        return result;
    }

    public static int getMaxSlotSize() {
        return PrimitiveType.ARRAY.slotSize;
    }

    public static PrimitiveType getAssignmentCompatibleType(PrimitiveType t1, PrimitiveType t2) {
        if (!t1.isValid() || !t2.isValid()) {
            return INVALID_TYPE;
        }
        PrimitiveType smallerType = t1.ordinal() < t2.ordinal() ? t1 : t2;
        PrimitiveType largerType = t1.ordinal() > t2.ordinal() ? t1 : t2;
        PrimitiveType result = compatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        Preconditions.checkNotNull((Object)((Object)result));
        return result;
    }

    public static boolean isImplicitlyCastable(PrimitiveType t1, PrimitiveType t2) {
        return PrimitiveType.getAssignmentCompatibleType(t1, t2) == t2;
    }

    public String toString() {
        return this.description;
    }

    public TPrimitiveType toThrift() {
        return this.thriftType;
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public boolean isFixedPointType() {
        return this == TINYINT || this == SMALLINT || this == INT || this == BIGINT || this == LARGEINT;
    }

    public boolean isFloatingPointType() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isDecimalV2Type() {
        return this == DECIMALV2;
    }

    public boolean isNumericType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isDecimalV2Type();
    }

    public boolean isValid() {
        return this != INVALID_TYPE;
    }

    public boolean isNull() {
        return this == NULL_TYPE;
    }

    public boolean isDateType() {
        return this == DATE || this == DATETIME;
    }

    public boolean isArrayType() {
        return this == ARRAY;
    }

    public boolean isStringType() {
        return this == VARCHAR || this == CHAR || this == HLL || this == STRING;
    }

    public boolean isCharFamily() {
        return this == VARCHAR || this == CHAR || this == STRING;
    }

    public boolean isIntegerType() {
        return this == TINYINT || this == SMALLINT || this == INT || this == BIGINT;
    }

    public MysqlColType toMysqlType() {
        switch (this) {
            case BOOLEAN: 
            case TINYINT: {
                return MysqlColType.MYSQL_TYPE_TINY;
            }
            case SMALLINT: {
                return MysqlColType.MYSQL_TYPE_SHORT;
            }
            case INT: {
                return MysqlColType.MYSQL_TYPE_LONG;
            }
            case BIGINT: {
                return MysqlColType.MYSQL_TYPE_LONGLONG;
            }
            case FLOAT: {
                return MysqlColType.MYSQL_TYPE_FLOAT;
            }
            case DOUBLE: {
                return MysqlColType.MYSQL_TYPE_DOUBLE;
            }
            case TIME: {
                return MysqlColType.MYSQL_TYPE_TIME;
            }
            case DATE: {
                return MysqlColType.MYSQL_TYPE_DATE;
            }
            case DATETIME: {
                if (this.isTimeType) {
                    return MysqlColType.MYSQL_TYPE_TIME;
                }
                return MysqlColType.MYSQL_TYPE_DATETIME;
            }
            case DECIMALV2: {
                return MysqlColType.MYSQL_TYPE_NEWDECIMAL;
            }
            case STRING: {
                return MysqlColType.MYSQL_TYPE_BLOB;
            }
        }
        return MysqlColType.MYSQL_TYPE_STRING;
    }

    public int getOlapColumnIndexSize() {
        switch (this) {
            case DATE: {
                return 3;
            }
            case DATETIME: {
                return 8;
            }
            case VARCHAR: {
                return 20;
            }
            case CHAR: {
                return -1;
            }
            case STRING: {
                return 20;
            }
            case DECIMALV2: {
                return 12;
            }
        }
        return this.getSlotSize();
    }

    static {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)NULL_TYPE, (Object)BOOLEAN);
        builder.put((Object)NULL_TYPE, (Object)TINYINT);
        builder.put((Object)NULL_TYPE, (Object)SMALLINT);
        builder.put((Object)NULL_TYPE, (Object)INT);
        builder.put((Object)NULL_TYPE, (Object)BIGINT);
        builder.put((Object)NULL_TYPE, (Object)LARGEINT);
        builder.put((Object)NULL_TYPE, (Object)FLOAT);
        builder.put((Object)NULL_TYPE, (Object)DOUBLE);
        builder.put((Object)NULL_TYPE, (Object)DATE);
        builder.put((Object)NULL_TYPE, (Object)DATETIME);
        builder.put((Object)NULL_TYPE, (Object)DECIMALV2);
        builder.put((Object)NULL_TYPE, (Object)CHAR);
        builder.put((Object)NULL_TYPE, (Object)VARCHAR);
        builder.put((Object)NULL_TYPE, (Object)STRING);
        builder.put((Object)NULL_TYPE, (Object)BITMAP);
        builder.put((Object)NULL_TYPE, (Object)TIME);
        builder.put((Object)BOOLEAN, (Object)BOOLEAN);
        builder.put((Object)BOOLEAN, (Object)TINYINT);
        builder.put((Object)BOOLEAN, (Object)SMALLINT);
        builder.put((Object)BOOLEAN, (Object)INT);
        builder.put((Object)BOOLEAN, (Object)BIGINT);
        builder.put((Object)BOOLEAN, (Object)LARGEINT);
        builder.put((Object)BOOLEAN, (Object)FLOAT);
        builder.put((Object)BOOLEAN, (Object)DOUBLE);
        builder.put((Object)BOOLEAN, (Object)DATE);
        builder.put((Object)BOOLEAN, (Object)DATETIME);
        builder.put((Object)BOOLEAN, (Object)DECIMALV2);
        builder.put((Object)BOOLEAN, (Object)VARCHAR);
        builder.put((Object)BOOLEAN, (Object)STRING);
        builder.put((Object)TINYINT, (Object)BOOLEAN);
        builder.put((Object)TINYINT, (Object)TINYINT);
        builder.put((Object)TINYINT, (Object)SMALLINT);
        builder.put((Object)TINYINT, (Object)INT);
        builder.put((Object)TINYINT, (Object)BIGINT);
        builder.put((Object)TINYINT, (Object)LARGEINT);
        builder.put((Object)TINYINT, (Object)FLOAT);
        builder.put((Object)TINYINT, (Object)DOUBLE);
        builder.put((Object)TINYINT, (Object)DATE);
        builder.put((Object)TINYINT, (Object)DATETIME);
        builder.put((Object)TINYINT, (Object)DECIMALV2);
        builder.put((Object)TINYINT, (Object)VARCHAR);
        builder.put((Object)TINYINT, (Object)STRING);
        builder.put((Object)SMALLINT, (Object)BOOLEAN);
        builder.put((Object)SMALLINT, (Object)TINYINT);
        builder.put((Object)SMALLINT, (Object)SMALLINT);
        builder.put((Object)SMALLINT, (Object)INT);
        builder.put((Object)SMALLINT, (Object)BIGINT);
        builder.put((Object)SMALLINT, (Object)LARGEINT);
        builder.put((Object)SMALLINT, (Object)FLOAT);
        builder.put((Object)SMALLINT, (Object)DOUBLE);
        builder.put((Object)SMALLINT, (Object)DATE);
        builder.put((Object)SMALLINT, (Object)DATETIME);
        builder.put((Object)SMALLINT, (Object)DECIMALV2);
        builder.put((Object)SMALLINT, (Object)VARCHAR);
        builder.put((Object)SMALLINT, (Object)STRING);
        builder.put((Object)INT, (Object)BOOLEAN);
        builder.put((Object)INT, (Object)TINYINT);
        builder.put((Object)INT, (Object)SMALLINT);
        builder.put((Object)INT, (Object)INT);
        builder.put((Object)INT, (Object)BIGINT);
        builder.put((Object)INT, (Object)LARGEINT);
        builder.put((Object)INT, (Object)FLOAT);
        builder.put((Object)INT, (Object)DOUBLE);
        builder.put((Object)INT, (Object)DATE);
        builder.put((Object)INT, (Object)DATETIME);
        builder.put((Object)INT, (Object)DECIMALV2);
        builder.put((Object)INT, (Object)VARCHAR);
        builder.put((Object)INT, (Object)STRING);
        builder.put((Object)BIGINT, (Object)BOOLEAN);
        builder.put((Object)BIGINT, (Object)TINYINT);
        builder.put((Object)BIGINT, (Object)SMALLINT);
        builder.put((Object)BIGINT, (Object)INT);
        builder.put((Object)BIGINT, (Object)BIGINT);
        builder.put((Object)BIGINT, (Object)LARGEINT);
        builder.put((Object)BIGINT, (Object)FLOAT);
        builder.put((Object)BIGINT, (Object)DOUBLE);
        builder.put((Object)BIGINT, (Object)DATE);
        builder.put((Object)BIGINT, (Object)DATETIME);
        builder.put((Object)BIGINT, (Object)DECIMALV2);
        builder.put((Object)BIGINT, (Object)VARCHAR);
        builder.put((Object)BIGINT, (Object)STRING);
        builder.put((Object)LARGEINT, (Object)BOOLEAN);
        builder.put((Object)LARGEINT, (Object)TINYINT);
        builder.put((Object)LARGEINT, (Object)SMALLINT);
        builder.put((Object)LARGEINT, (Object)INT);
        builder.put((Object)LARGEINT, (Object)BIGINT);
        builder.put((Object)LARGEINT, (Object)LARGEINT);
        builder.put((Object)LARGEINT, (Object)FLOAT);
        builder.put((Object)LARGEINT, (Object)DOUBLE);
        builder.put((Object)LARGEINT, (Object)DATE);
        builder.put((Object)LARGEINT, (Object)DATETIME);
        builder.put((Object)LARGEINT, (Object)DECIMALV2);
        builder.put((Object)LARGEINT, (Object)VARCHAR);
        builder.put((Object)LARGEINT, (Object)STRING);
        builder.put((Object)FLOAT, (Object)BOOLEAN);
        builder.put((Object)FLOAT, (Object)TINYINT);
        builder.put((Object)FLOAT, (Object)SMALLINT);
        builder.put((Object)FLOAT, (Object)INT);
        builder.put((Object)FLOAT, (Object)BIGINT);
        builder.put((Object)FLOAT, (Object)LARGEINT);
        builder.put((Object)FLOAT, (Object)FLOAT);
        builder.put((Object)FLOAT, (Object)DOUBLE);
        builder.put((Object)FLOAT, (Object)DATE);
        builder.put((Object)FLOAT, (Object)DATETIME);
        builder.put((Object)FLOAT, (Object)DECIMALV2);
        builder.put((Object)FLOAT, (Object)VARCHAR);
        builder.put((Object)FLOAT, (Object)STRING);
        builder.put((Object)DOUBLE, (Object)BOOLEAN);
        builder.put((Object)DOUBLE, (Object)TINYINT);
        builder.put((Object)DOUBLE, (Object)SMALLINT);
        builder.put((Object)DOUBLE, (Object)INT);
        builder.put((Object)DOUBLE, (Object)BIGINT);
        builder.put((Object)DOUBLE, (Object)LARGEINT);
        builder.put((Object)DOUBLE, (Object)FLOAT);
        builder.put((Object)DOUBLE, (Object)DOUBLE);
        builder.put((Object)DOUBLE, (Object)DATE);
        builder.put((Object)DOUBLE, (Object)DATETIME);
        builder.put((Object)DOUBLE, (Object)DECIMALV2);
        builder.put((Object)DOUBLE, (Object)VARCHAR);
        builder.put((Object)DOUBLE, (Object)STRING);
        builder.put((Object)DATE, (Object)BOOLEAN);
        builder.put((Object)DATE, (Object)TINYINT);
        builder.put((Object)DATE, (Object)SMALLINT);
        builder.put((Object)DATE, (Object)INT);
        builder.put((Object)DATE, (Object)BIGINT);
        builder.put((Object)DATE, (Object)LARGEINT);
        builder.put((Object)DATE, (Object)FLOAT);
        builder.put((Object)DATE, (Object)DOUBLE);
        builder.put((Object)DATE, (Object)DATE);
        builder.put((Object)DATE, (Object)DATETIME);
        builder.put((Object)DATE, (Object)DECIMALV2);
        builder.put((Object)DATE, (Object)VARCHAR);
        builder.put((Object)DATE, (Object)STRING);
        builder.put((Object)DATETIME, (Object)BOOLEAN);
        builder.put((Object)DATETIME, (Object)TINYINT);
        builder.put((Object)DATETIME, (Object)SMALLINT);
        builder.put((Object)DATETIME, (Object)INT);
        builder.put((Object)DATETIME, (Object)BIGINT);
        builder.put((Object)DATETIME, (Object)LARGEINT);
        builder.put((Object)DATETIME, (Object)FLOAT);
        builder.put((Object)DATETIME, (Object)DOUBLE);
        builder.put((Object)DATETIME, (Object)DATE);
        builder.put((Object)DATETIME, (Object)DATETIME);
        builder.put((Object)DATETIME, (Object)DECIMALV2);
        builder.put((Object)DATETIME, (Object)VARCHAR);
        builder.put((Object)DATETIME, (Object)STRING);
        builder.put((Object)CHAR, (Object)BOOLEAN);
        builder.put((Object)CHAR, (Object)TINYINT);
        builder.put((Object)CHAR, (Object)SMALLINT);
        builder.put((Object)CHAR, (Object)CHAR);
        builder.put((Object)CHAR, (Object)INT);
        builder.put((Object)CHAR, (Object)BIGINT);
        builder.put((Object)CHAR, (Object)LARGEINT);
        builder.put((Object)CHAR, (Object)FLOAT);
        builder.put((Object)CHAR, (Object)DOUBLE);
        builder.put((Object)CHAR, (Object)DATE);
        builder.put((Object)CHAR, (Object)DATETIME);
        builder.put((Object)CHAR, (Object)DECIMALV2);
        builder.put((Object)CHAR, (Object)VARCHAR);
        builder.put((Object)CHAR, (Object)STRING);
        builder.put((Object)VARCHAR, (Object)BOOLEAN);
        builder.put((Object)VARCHAR, (Object)TINYINT);
        builder.put((Object)VARCHAR, (Object)SMALLINT);
        builder.put((Object)VARCHAR, (Object)INT);
        builder.put((Object)VARCHAR, (Object)BIGINT);
        builder.put((Object)VARCHAR, (Object)LARGEINT);
        builder.put((Object)VARCHAR, (Object)FLOAT);
        builder.put((Object)VARCHAR, (Object)DOUBLE);
        builder.put((Object)VARCHAR, (Object)DATE);
        builder.put((Object)VARCHAR, (Object)DATETIME);
        builder.put((Object)VARCHAR, (Object)DECIMALV2);
        builder.put((Object)VARCHAR, (Object)VARCHAR);
        builder.put((Object)VARCHAR, (Object)STRING);
        builder.put((Object)STRING, (Object)BOOLEAN);
        builder.put((Object)STRING, (Object)TINYINT);
        builder.put((Object)STRING, (Object)SMALLINT);
        builder.put((Object)STRING, (Object)INT);
        builder.put((Object)STRING, (Object)BIGINT);
        builder.put((Object)STRING, (Object)LARGEINT);
        builder.put((Object)STRING, (Object)FLOAT);
        builder.put((Object)STRING, (Object)DOUBLE);
        builder.put((Object)STRING, (Object)DATE);
        builder.put((Object)STRING, (Object)DATETIME);
        builder.put((Object)STRING, (Object)DECIMALV2);
        builder.put((Object)STRING, (Object)VARCHAR);
        builder.put((Object)STRING, (Object)STRING);
        builder.put((Object)DECIMALV2, (Object)BOOLEAN);
        builder.put((Object)DECIMALV2, (Object)TINYINT);
        builder.put((Object)DECIMALV2, (Object)SMALLINT);
        builder.put((Object)DECIMALV2, (Object)INT);
        builder.put((Object)DECIMALV2, (Object)BIGINT);
        builder.put((Object)DECIMALV2, (Object)LARGEINT);
        builder.put((Object)DECIMALV2, (Object)FLOAT);
        builder.put((Object)DECIMALV2, (Object)DOUBLE);
        builder.put((Object)DECIMALV2, (Object)DECIMALV2);
        builder.put((Object)DECIMALV2, (Object)VARCHAR);
        builder.put((Object)DECIMALV2, (Object)STRING);
        builder.put((Object)HLL, (Object)HLL);
        builder.put((Object)BITMAP, (Object)BITMAP);
        builder.put((Object)TIME, (Object)TIME);
        builder.put((Object)TIME, (Object)DOUBLE);
        implicitCastMap = builder.build();
        integerTypes = Lists.newArrayList();
        integerTypes.add(TINYINT);
        integerTypes.add(SMALLINT);
        integerTypes.add(INT);
        integerTypes.add(BIGINT);
        integerTypes.add(LARGEINT);
        numericTypes = Lists.newArrayList();
        numericTypes.add(TINYINT);
        numericTypes.add(SMALLINT);
        numericTypes.add(INT);
        numericTypes.add(BIGINT);
        numericTypes.add(LARGEINT);
        numericTypes.add(FLOAT);
        numericTypes.add(DOUBLE);
        numericTypes.add(DECIMALV2);
        supportedTypes = Lists.newArrayList();
        supportedTypes.add(NULL_TYPE);
        supportedTypes.add(BOOLEAN);
        supportedTypes.add(TINYINT);
        supportedTypes.add(SMALLINT);
        supportedTypes.add(INT);
        supportedTypes.add(BIGINT);
        supportedTypes.add(LARGEINT);
        supportedTypes.add(FLOAT);
        supportedTypes.add(DOUBLE);
        supportedTypes.add(VARCHAR);
        supportedTypes.add(STRING);
        supportedTypes.add(HLL);
        supportedTypes.add(CHAR);
        supportedTypes.add(DATE);
        supportedTypes.add(DATETIME);
        supportedTypes.add(TIME);
        supportedTypes.add(DECIMALV2);
        supportedTypes.add(BITMAP);
        supportedTypes.add(ARRAY);
        supportedTypes.add(MAP);
        compatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.NULL_TYPE.ordinal()] = NULL_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BOOLEAN.ordinal()] = BOOLEAN;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DATE.ordinal()] = DATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.CHAR.ordinal()] = CHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BITMAP.ordinal()] = BITMAP;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.BOOLEAN.ordinal()] = BOOLEAN;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BOOLEAN.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TINYINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.SMALLINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.INT.ordinal()] = INT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.INT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.BIGINT.ordinal()] = BIGINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BIGINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.LARGEINT.ordinal()] = LARGEINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.FLOAT.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.LARGEINT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.FLOAT.ordinal()] = FLOAT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.FLOAT.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DOUBLE.ordinal()] = DOUBLE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DATE.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DATETIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DOUBLE.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DATE.ordinal()] = DATE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATE.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DATETIME.ordinal()] = DATETIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.CHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.VARCHAR.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.STRING.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DATETIME.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.CHAR.ordinal()] = CHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.CHAR.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.VARCHAR.ordinal()] = VARCHAR;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.VARCHAR.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.STRING.ordinal()] = STRING;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.STRING.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.DECIMALV2.ordinal()] = DECIMALV2;
        PrimitiveType.compatibilityMatrix[PrimitiveType.DECIMALV2.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.HLL.ordinal()][PrimitiveType.HLL.ordinal()] = HLL;
        PrimitiveType.compatibilityMatrix[PrimitiveType.HLL.ordinal()][PrimitiveType.TIME.ordinal()] = INVALID_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.BITMAP.ordinal()][PrimitiveType.BITMAP.ordinal()] = BITMAP;
        PrimitiveType.compatibilityMatrix[PrimitiveType.TIME.ordinal()][PrimitiveType.TIME.ordinal()] = TIME;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.NULL_TYPE.ordinal()] = NULL_TYPE;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.BOOLEAN.ordinal()] = BOOLEAN;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.TINYINT.ordinal()] = TINYINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.SMALLINT.ordinal()] = SMALLINT;
        PrimitiveType.compatibilityMatrix[PrimitiveType.NULL_TYPE.ordinal()][PrimitiveType.INT.ordinal()] = INT;
    }
}

