/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.PartitionValue;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionKey
implements Comparable<PartitionKey>,
Writable {
    private static final Logger LOG = LogManager.getLogger(PartitionKey.class);
    private List<LiteralExpr> keys = Lists.newArrayList();
    private List<PrimitiveType> types = Lists.newArrayList();

    public static PartitionKey createInfinityPartitionKey(List<Column> columns, boolean isMax) throws AnalysisException {
        PartitionKey partitionKey = new PartitionKey();
        for (Column column : columns) {
            partitionKey.keys.add(LiteralExpr.createInfinity(Type.fromPrimitiveType(column.getDataType()), isMax));
            partitionKey.types.add(column.getDataType());
        }
        return partitionKey;
    }

    public static PartitionKey createPartitionKey(List<PartitionValue> keys, List<Column> columns) throws AnalysisException {
        int i;
        PartitionKey partitionKey = new PartitionKey();
        Preconditions.checkArgument((keys.size() <= columns.size() ? 1 : 0) != 0);
        for (i = 0; i < keys.size(); ++i) {
            partitionKey.keys.add(keys.get(i).getValue(Type.fromPrimitiveType(columns.get(i).getDataType())));
            partitionKey.types.add(columns.get(i).getDataType());
        }
        while (i < columns.size()) {
            Type type = Type.fromPrimitiveType(columns.get(i).getDataType());
            partitionKey.keys.add(LiteralExpr.createInfinity(type, false));
            partitionKey.types.add(columns.get(i).getDataType());
            ++i;
        }
        Preconditions.checkState((partitionKey.keys.size() == columns.size() ? 1 : 0) != 0);
        return partitionKey;
    }

    public static PartitionKey createListPartitionKey(List<PartitionValue> values, List<Column> columns) throws AnalysisException {
        Preconditions.checkArgument((values.size() == columns.size() ? 1 : 0) != 0, (Object)("in value size[" + values.size() + "] is not equal to partition column size[" + columns.size() + "]."));
        PartitionKey partitionKey = new PartitionKey();
        for (int i = 0; i < values.size(); ++i) {
            partitionKey.keys.add(values.get(i).getValue(Type.fromPrimitiveType(columns.get(i).getDataType())));
            partitionKey.types.add(columns.get(i).getDataType());
        }
        return partitionKey;
    }

    public void pushColumn(LiteralExpr keyValue, PrimitiveType keyType) {
        this.keys.add(keyValue);
        this.types.add(keyType);
    }

    public void popColumn() {
        this.keys.remove(this.keys.size() - 1);
        this.types.remove(this.types.size() - 1);
    }

    public List<LiteralExpr> getKeys() {
        return this.keys;
    }

    public long getHashValue() {
        CRC32 hashValue = new CRC32();
        int i = 0;
        for (LiteralExpr expr : this.keys) {
            ByteBuffer buffer = expr.getHashValue(this.types.get(i));
            hashValue.update(buffer.array(), 0, buffer.limit());
            ++i;
        }
        return hashValue.getValue();
    }

    public boolean isMinValue() {
        for (LiteralExpr literalExpr : this.keys) {
            if (literalExpr.isMinValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isMaxValue() {
        for (LiteralExpr literalExpr : this.keys) {
            if (literalExpr == MaxLiteral.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    public static int compareLiteralExpr(LiteralExpr key1, LiteralExpr key2) {
        int ret = 0;
        if (key1 instanceof MaxLiteral || key2 instanceof MaxLiteral) {
            ret = key1.compareLiteral(key2);
        } else {
            Type destType = Type.getAssignmentCompatibleType(key1.getType(), key2.getType(), false);
            try {
                LiteralExpr newKey = key1;
                if (key1.getType() != destType) {
                    newKey = (LiteralExpr)key1.castTo(destType);
                }
                LiteralExpr newOtherKey = key2;
                if (key2.getType() != destType) {
                    newOtherKey = (LiteralExpr)key2.castTo(destType);
                }
                ret = newKey.compareLiteral(newOtherKey);
            }
            catch (AnalysisException e) {
                throw new RuntimeException("Cast error in partition");
            }
        }
        return ret;
    }

    @Override
    public int compareTo(PartitionKey other) {
        int this_key_len = this.keys.size();
        int other_key_len = other.keys.size();
        int min_len = Math.min(this_key_len, other_key_len);
        for (int i = 0; i < min_len; ++i) {
            int ret = PartitionKey.compareLiteralExpr(this.getKeys().get(i), other.getKeys().get(i));
            if (0 == ret) continue;
            return ret;
        }
        return Integer.compare(this_key_len, other_key_len);
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        for (LiteralExpr expr : this.keys) {
            String value = null;
            if (expr == MaxLiteral.MAX_VALUE) {
                value = expr.toSql();
                sb.append((Object)value);
                continue;
            }
            value = "\"" + expr.getRealValue() + "\"";
            if (expr instanceof DateLiteral) {
                DateLiteral dateLiteral = (DateLiteral)expr;
                value = dateLiteral.toSql();
            }
            sb.append((Object)value);
            if (this.keys.size() - 1 != i) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("types: [");
        builder.append(Joiner.on((String)", ").join(this.types));
        builder.append("]; ");
        builder.append("keys: [");
        builder.append(PartitionKey.toString(this.keys));
        builder.append("]; ");
        return builder.toString();
    }

    public static String toString(List<LiteralExpr> keys) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (LiteralExpr expr : keys) {
            Object value = null;
            if (expr == MaxLiteral.MAX_VALUE) {
                value = expr.toSql();
            } else {
                value = expr.getRealValue();
                if (expr instanceof DateLiteral) {
                    DateLiteral dateLiteral = (DateLiteral)expr;
                    value = dateLiteral.getStringValue();
                }
            }
            if (keys.size() - 1 == i) {
                builder.append(value);
            } else {
                builder.append(value).append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public void write(DataOutput out) throws IOException {
        int count = this.keys.size();
        if (count != this.types.size()) {
            throw new IOException("Size of keys and types are not equal");
        }
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            PrimitiveType type = this.types.get(i);
            Text.writeString((DataOutput)out, (String)type.toString());
            if (this.keys.get(i) == MaxLiteral.MAX_VALUE) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            this.keys.get(i).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            PrimitiveType type = PrimitiveType.valueOf(Text.readString((DataInput)in));
            this.types.add(type);
            LiteralExpr literal = null;
            boolean isMax = in.readBoolean();
            if (isMax) {
                literal = MaxLiteral.MAX_VALUE;
            } else {
                switch (type) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: {
                        literal = IntLiteral.read(in);
                        break;
                    }
                    case LARGEINT: {
                        literal = LargeIntLiteral.read(in);
                        break;
                    }
                    case DATE: 
                    case DATETIME: {
                        literal = DateLiteral.read(in);
                        break;
                    }
                    case CHAR: 
                    case VARCHAR: 
                    case STRING: {
                        literal = StringLiteral.read(in);
                        break;
                    }
                    case BOOLEAN: {
                        literal = BoolLiteral.read(in);
                        break;
                    }
                    default: {
                        throw new IOException("type[" + type.name() + "] not supported: ");
                    }
                }
            }
            literal.setType(Type.fromPrimitiveType(type));
            this.keys.add(literal);
        }
    }

    public static PartitionKey read(DataInput in) throws IOException {
        PartitionKey key = new PartitionKey();
        key.readFields(in);
        return key;
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartitionKey)) {
            return false;
        }
        PartitionKey partitionKey = (PartitionKey)obj;
        if (this.keys != partitionKey.keys) {
            if (this.keys.size() != partitionKey.keys.size()) {
                return false;
            }
            for (i = 0; i < this.keys.size(); ++i) {
                if (this.keys.get(i).equals(partitionKey.keys.get(i))) continue;
                return false;
            }
        }
        if (this.types != partitionKey.types) {
            if (this.types.size() != partitionKey.types.size()) {
                return false;
            }
            for (i = 0; i < this.types.size(); ++i) {
                if (this.types.get(i).equals((Object)partitionKey.types.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = this.types.size() * 1000;
        for (PrimitiveType type : this.types) {
            ret += type.ordinal();
        }
        return ret;
    }
}

