/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TTabletType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionInfo
implements Writable {
    private static final Logger LOG = LogManager.getLogger(PartitionInfo.class);
    protected PartitionType type;
    protected List<Column> partitionColumns = Lists.newArrayList();
    protected Map<Long, PartitionItem> idToItem = Maps.newHashMap();
    protected Map<Long, PartitionItem> idToTempItem = Maps.newHashMap();
    protected Map<Long, DataProperty> idToDataProperty;
    protected Map<Long, ReplicaAllocation> idToReplicaAllocation;
    protected boolean isMultiColumnPartition = false;
    protected Map<Long, Boolean> idToInMemory;
    protected Map<Long, TTabletType> idToTabletType;

    public PartitionInfo() {
        this.idToDataProperty = new HashMap<Long, DataProperty>();
        this.idToReplicaAllocation = new HashMap<Long, ReplicaAllocation>();
        this.idToInMemory = new HashMap<Long, Boolean>();
        this.idToTabletType = new HashMap<Long, TTabletType>();
    }

    public PartitionInfo(PartitionType type) {
        this.type = type;
        this.idToDataProperty = new HashMap<Long, DataProperty>();
        this.idToReplicaAllocation = new HashMap<Long, ReplicaAllocation>();
        this.idToInMemory = new HashMap<Long, Boolean>();
        this.idToTabletType = new HashMap<Long, TTabletType>();
    }

    public PartitionInfo(PartitionType type, List<Column> partitionColumns) {
        this(type);
        this.partitionColumns = partitionColumns;
        this.isMultiColumnPartition = partitionColumns.size() > 1;
    }

    public PartitionType getType() {
        return this.type;
    }

    public List<Column> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Map<Long, PartitionItem> getIdToItem(boolean isTemp) {
        if (isTemp) {
            return this.idToTempItem;
        }
        return this.idToItem;
    }

    public PartitionItem getItem(long partitionId) {
        PartitionItem item = this.idToItem.get(partitionId);
        if (item == null) {
            item = this.idToTempItem.get(partitionId);
        }
        return item;
    }

    public void setItem(long partitionId, boolean isTemp, PartitionItem item) {
        this.setItemInternal(partitionId, isTemp, item);
    }

    private void setItemInternal(long partitionId, boolean isTemp, PartitionItem item) {
        if (isTemp) {
            this.idToTempItem.put(partitionId, item);
        } else {
            this.idToItem.put(partitionId, item);
        }
    }

    public PartitionItem handleNewSinglePartitionDesc(SinglePartitionDesc desc, long partitionId, boolean isTemp) throws DdlException {
        Preconditions.checkArgument((boolean)desc.isAnalyzed());
        PartitionItem partitionItem = this.createAndCheckPartitionItem(desc, isTemp);
        this.setItemInternal(partitionId, isTemp, partitionItem);
        this.idToDataProperty.put(partitionId, desc.getPartitionDataProperty());
        this.idToReplicaAllocation.put(partitionId, desc.getReplicaAlloc());
        this.idToInMemory.put(partitionId, desc.isInMemory());
        return partitionItem;
    }

    public PartitionItem createAndCheckPartitionItem(SinglePartitionDesc desc, boolean isTemp) throws DdlException {
        return null;
    }

    public void unprotectHandleNewSinglePartitionDesc(long partitionId, boolean isTemp, PartitionItem partitionItem, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory) {
        this.setItemInternal(partitionId, isTemp, partitionItem);
        this.idToDataProperty.put(partitionId, dataProperty);
        this.idToReplicaAllocation.put(partitionId, replicaAlloc);
        this.idToInMemory.put(partitionId, isInMemory);
    }

    public List<Map.Entry<Long, PartitionItem>> getPartitionItemEntryList(boolean isTemp, boolean isSorted) {
        Map<Long, PartitionItem> tmpMap = this.idToItem;
        if (isTemp) {
            tmpMap = this.idToTempItem;
        }
        ArrayList itemEntryList = Lists.newArrayList(tmpMap.entrySet());
        if (isSorted) {
            Collections.sort(itemEntryList, PartitionItem.ITEM_MAP_ENTRY_COMPARATOR);
        }
        return itemEntryList;
    }

    public List<PartitionItem> getItemList(Set<Long> excludePartitionIds, boolean isTemp) {
        Map<Long, PartitionItem> tempMap = this.idToItem;
        if (isTemp) {
            tempMap = this.idToTempItem;
        }
        ArrayList resultList = Lists.newArrayList();
        for (Map.Entry<Long, PartitionItem> entry : tempMap.entrySet()) {
            if (excludePartitionIds.contains(entry.getKey())) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    public PartitionItem getAnyIntersectItem(PartitionItem newItem, boolean isTemp) {
        Map<Long, PartitionItem> tmpMap = this.idToItem;
        if (isTemp) {
            tmpMap = this.idToTempItem;
        }
        for (PartitionItem item : tmpMap.values()) {
            PartitionItem retItem = item.getIntersect(newItem);
            if (null == retItem) continue;
            return retItem;
        }
        return null;
    }

    public void checkPartitionItemListsMatch(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
    }

    public void checkPartitionItemListsConflict(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
    }

    public DataProperty getDataProperty(long partitionId) {
        return this.idToDataProperty.get(partitionId);
    }

    public void setDataProperty(long partitionId, DataProperty newDataProperty) {
        this.idToDataProperty.put(partitionId, newDataProperty);
    }

    public ReplicaAllocation getReplicaAllocation(long partitionId) {
        if (!this.idToReplicaAllocation.containsKey(partitionId)) {
            LOG.debug("failed to get replica allocation for partition: {}", (Object)partitionId);
            return ReplicaAllocation.DEFAULT_ALLOCATION;
        }
        return this.idToReplicaAllocation.get(partitionId);
    }

    public void setReplicaAllocation(long partitionId, ReplicaAllocation replicaAlloc) {
        this.idToReplicaAllocation.put(partitionId, replicaAlloc);
    }

    public boolean getIsInMemory(long partitionId) {
        return this.idToInMemory.get(partitionId);
    }

    public void setIsInMemory(long partitionId, boolean isInMemory) {
        this.idToInMemory.put(partitionId, isInMemory);
    }

    public TTabletType getTabletType(long partitionId) {
        if (!this.idToTabletType.containsKey(partitionId)) {
            return TTabletType.TABLET_TYPE_DISK;
        }
        return this.idToTabletType.get(partitionId);
    }

    public void setTabletType(long partitionId, TTabletType tabletType) {
        this.idToTabletType.put(partitionId, tabletType);
    }

    public void dropPartition(long partitionId) {
        this.idToDataProperty.remove(partitionId);
        this.idToReplicaAllocation.remove(partitionId);
        this.idToInMemory.remove(partitionId);
        this.idToItem.remove(partitionId);
        this.idToTempItem.remove(partitionId);
    }

    public void addPartition(long partitionId, boolean isTemp, PartitionItem item, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory) {
        this.addPartition(partitionId, dataProperty, replicaAlloc, isInMemory);
        this.setItemInternal(partitionId, isTemp, item);
    }

    public void addPartition(long partitionId, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory) {
        this.idToDataProperty.put(partitionId, dataProperty);
        this.idToReplicaAllocation.put(partitionId, replicaAlloc);
        this.idToInMemory.put(partitionId, isInMemory);
    }

    public static PartitionInfo read(DataInput in) throws IOException {
        PartitionInfo partitionInfo = new PartitionInfo();
        partitionInfo.readFields(in);
        return partitionInfo;
    }

    public boolean isMultiColumnPartition() {
        return this.isMultiColumnPartition;
    }

    public String toSql(OlapTable table, List<Long> partitionId) {
        return "";
    }

    public void moveFromTempToFormal(long tempPartitionId) {
        PartitionItem item = this.idToTempItem.remove(tempPartitionId);
        if (item != null) {
            this.idToItem.put(tempPartitionId, item);
        }
    }

    public void resetPartitionIdForRestore(long newPartitionId, long oldPartitionId, ReplicaAllocation restoreReplicaAlloc, boolean isSinglePartitioned) {
        this.idToDataProperty.put(newPartitionId, this.idToDataProperty.remove(oldPartitionId));
        this.idToReplicaAllocation.remove(oldPartitionId);
        this.idToReplicaAllocation.put(newPartitionId, restoreReplicaAlloc);
        if (!isSinglePartitioned) {
            this.idToItem.put(newPartitionId, this.idToItem.remove(oldPartitionId));
        }
        this.idToInMemory.put(newPartitionId, this.idToInMemory.remove(oldPartitionId));
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.type.name());
        Preconditions.checkState((this.idToDataProperty.size() == this.idToReplicaAllocation.size() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.idToInMemory.keySet().equals(this.idToReplicaAllocation.keySet()));
        out.writeInt(this.idToDataProperty.size());
        for (Map.Entry<Long, DataProperty> entry : this.idToDataProperty.entrySet()) {
            out.writeLong(entry.getKey());
            if (entry.getValue().equals(new DataProperty(TStorageMedium.HDD))) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                entry.getValue().write(out);
            }
            this.idToReplicaAllocation.get(entry.getKey()).write(out);
            out.writeBoolean(this.idToInMemory.get(entry.getKey()));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.type = PartitionType.valueOf(Text.readString((DataInput)in));
        int counter = in.readInt();
        for (int i = 0; i < counter; ++i) {
            long partitionId = in.readLong();
            boolean isDefaultHddDataProperty = in.readBoolean();
            if (isDefaultHddDataProperty) {
                this.idToDataProperty.put(partitionId, new DataProperty(TStorageMedium.HDD));
            } else {
                this.idToDataProperty.put(partitionId, DataProperty.read(in));
            }
            if (Catalog.getCurrentCatalogJournalVersion() < 105) {
                short replicationNum = in.readShort();
                ReplicaAllocation replicaAlloc = new ReplicaAllocation(replicationNum);
                this.idToReplicaAllocation.put(partitionId, replicaAlloc);
            } else {
                ReplicaAllocation replicaAlloc = ReplicaAllocation.read(in);
                this.idToReplicaAllocation.put(partitionId, replicaAlloc);
            }
            this.idToInMemory.put(partitionId, in.readBoolean());
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("type: ").append(this.type.typeString).append("; ");
        for (Map.Entry<Long, DataProperty> entry : this.idToDataProperty.entrySet()) {
            buff.append(entry.getKey()).append(" is HDD: ");
            if (entry.getValue().equals(new DataProperty(TStorageMedium.HDD))) {
                buff.append(true);
            } else {
                buff.append(false);
            }
            buff.append("; ");
            buff.append("data_property: ").append(entry.getValue().toString()).append("; ");
            buff.append("replica number: ").append(this.idToReplicaAllocation.get(entry.getKey())).append("; ");
            buff.append("in memory: ").append(this.idToInMemory.get(entry.getKey()));
        }
        return buff.toString();
    }
}

