/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MetaObject;
import org.apache.doris.catalog.RandomDistributionInfo;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Partition
extends MetaObject
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Partition.class);
    public static final long PARTITION_INIT_VERSION = 1L;
    @SerializedName(value="id")
    private long id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="state")
    private PartitionState state;
    @SerializedName(value="baseIndex")
    private MaterializedIndex baseIndex;
    @SerializedName(value="idToVisibleRollupIndex")
    private Map<Long, MaterializedIndex> idToVisibleRollupIndex = Maps.newHashMap();
    @SerializedName(value="idToShadowIndex")
    private Map<Long, MaterializedIndex> idToShadowIndex = Maps.newHashMap();
    @Deprecated
    @SerializedName(value="committedVersionHash")
    private long committedVersionHash;
    @SerializedName(value="visibleVersion")
    private long visibleVersion;
    @SerializedName(value="visibleVersionTime")
    private long visibleVersionTime;
    @Deprecated
    @SerializedName(value="visibleVersionHash")
    private long visibleVersionHash;
    @SerializedName(value="nextVersion")
    private long nextVersion;
    @Deprecated
    @SerializedName(value="nextVersionHash")
    private long nextVersionHash;
    @SerializedName(value="distributionInfo")
    private DistributionInfo distributionInfo;

    private Partition() {
    }

    public Partition(long id, String name, MaterializedIndex baseIndex, DistributionInfo distributionInfo) {
        this.id = id;
        this.name = name;
        this.state = PartitionState.NORMAL;
        this.baseIndex = baseIndex;
        this.visibleVersion = 1L;
        this.visibleVersionTime = System.currentTimeMillis();
        this.nextVersion = 2L;
        this.distributionInfo = distributionInfo;
    }

    public void setIdForRestore(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public void setState(PartitionState state) {
        this.state = state;
    }

    public void updateVersionForRestore(long visibleVersion) {
        this.setVisibleVersion(visibleVersion);
        this.nextVersion = this.visibleVersion + 1L;
        LOG.info("update partition {} version for restore: visible: {}, next: {}", (Object)this.name, (Object)visibleVersion, (Object)this.nextVersion);
    }

    public void updateVisibleVersion(long visibleVersion) {
        this.updateVisibleVersionAndTime(visibleVersion, System.currentTimeMillis());
    }

    public void updateVisibleVersionAndTime(long visibleVersion, long visibleVersionTime) {
        this.setVisibleVersionAndTime(visibleVersion, visibleVersionTime);
    }

    public long getVisibleVersion() {
        return this.visibleVersion;
    }

    public long getVisibleVersionTime() {
        return this.visibleVersionTime;
    }

    private void setVisibleVersion(long visibleVersion) {
        this.visibleVersion = visibleVersion;
        this.visibleVersionTime = System.currentTimeMillis();
    }

    public void setVisibleVersionAndTime(long visibleVersion, long visibleVersionTime) {
        this.visibleVersion = visibleVersion;
        this.visibleVersionTime = visibleVersionTime;
    }

    public PartitionState getState() {
        return this.state;
    }

    public DistributionInfo getDistributionInfo() {
        return this.distributionInfo;
    }

    public void createRollupIndex(MaterializedIndex mIndex) {
        if (mIndex.getState().isVisible()) {
            this.idToVisibleRollupIndex.put(mIndex.getId(), mIndex);
        } else {
            this.idToShadowIndex.put(mIndex.getId(), mIndex);
        }
    }

    public MaterializedIndex deleteRollupIndex(long indexId) {
        if (this.idToVisibleRollupIndex.containsKey(indexId)) {
            return this.idToVisibleRollupIndex.remove(indexId);
        }
        return this.idToShadowIndex.remove(indexId);
    }

    public MaterializedIndex getBaseIndex() {
        return this.baseIndex;
    }

    public long getNextVersion() {
        return this.nextVersion;
    }

    public void setNextVersion(long nextVersion) {
        this.nextVersion = nextVersion;
    }

    public long getCommittedVersion() {
        return this.nextVersion - 1L;
    }

    public MaterializedIndex getIndex(long indexId) {
        if (this.baseIndex.getId() == indexId) {
            return this.baseIndex;
        }
        if (this.idToVisibleRollupIndex.containsKey(indexId)) {
            return this.idToVisibleRollupIndex.get(indexId);
        }
        return this.idToShadowIndex.get(indexId);
    }

    public List<MaterializedIndex> getMaterializedIndices(MaterializedIndex.IndexExtState extState) {
        ArrayList indices = Lists.newArrayList();
        switch (extState) {
            case ALL: {
                indices.add(this.baseIndex);
                indices.addAll(this.idToVisibleRollupIndex.values());
                indices.addAll(this.idToShadowIndex.values());
                break;
            }
            case VISIBLE: {
                indices.add(this.baseIndex);
                indices.addAll(this.idToVisibleRollupIndex.values());
                break;
            }
            case SHADOW: {
                indices.addAll(this.idToShadowIndex.values());
            }
        }
        return indices;
    }

    public long getDataSize() {
        long dataSize = 0L;
        for (MaterializedIndex mIndex : this.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
            dataSize += mIndex.getDataSize();
        }
        return dataSize;
    }

    public long getReplicaCount() {
        long replicaCount = 0L;
        for (MaterializedIndex mIndex : this.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
            replicaCount += mIndex.getReplicaCount();
        }
        return replicaCount;
    }

    public boolean hasData() {
        return this.visibleVersion != 1L || FeConstants.runningUnitTest;
    }

    public boolean visualiseShadowIndex(long shadowIndexId, boolean isBaseIndex) {
        MaterializedIndex shadowIdx = this.idToShadowIndex.remove(shadowIndexId);
        if (shadowIdx == null) {
            return false;
        }
        Preconditions.checkState((!this.idToVisibleRollupIndex.containsKey(shadowIndexId) ? 1 : 0) != 0, (Object)shadowIndexId);
        shadowIdx.setState(MaterializedIndex.IndexState.NORMAL);
        if (isBaseIndex) {
            this.baseIndex = shadowIdx;
        } else {
            this.idToVisibleRollupIndex.put(shadowIndexId, shadowIdx);
        }
        LOG.info("visualise the shadow index: {}", (Object)shadowIndexId);
        return true;
    }

    public static Partition read(DataInput in) throws IOException {
        Partition partition = new Partition();
        partition.readFields(in);
        return partition;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.id);
        Text.writeString((DataOutput)out, (String)this.name);
        Text.writeString((DataOutput)out, (String)this.state.name());
        this.baseIndex.write(out);
        int rollupCount = this.idToVisibleRollupIndex != null ? this.idToVisibleRollupIndex.size() : 0;
        out.writeInt(rollupCount);
        if (this.idToVisibleRollupIndex != null) {
            for (Map.Entry<Long, MaterializedIndex> entry : this.idToVisibleRollupIndex.entrySet()) {
                entry.getValue().write(out);
            }
        }
        out.writeInt(this.idToShadowIndex.size());
        for (MaterializedIndex shadowIndex : this.idToShadowIndex.values()) {
            shadowIndex.write(out);
        }
        out.writeLong(this.visibleVersion);
        out.writeLong(this.visibleVersionTime);
        out.writeLong(this.visibleVersionHash);
        out.writeLong(this.nextVersion);
        out.writeLong(this.nextVersionHash);
        out.writeLong(this.committedVersionHash);
        Text.writeString((DataOutput)out, (String)this.distributionInfo.getType().name());
        this.distributionInfo.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.id = in.readLong();
        this.name = Text.readString((DataInput)in);
        this.state = PartitionState.valueOf(Text.readString((DataInput)in));
        this.baseIndex = MaterializedIndex.read(in);
        int rollupCount = in.readInt();
        for (int i = 0; i < rollupCount; ++i) {
            MaterializedIndex rollupTable = MaterializedIndex.read(in);
            this.idToVisibleRollupIndex.put(rollupTable.getId(), rollupTable);
        }
        int shadowIndexCount = in.readInt();
        for (int i = 0; i < shadowIndexCount; ++i) {
            MaterializedIndex shadowIndex = MaterializedIndex.read(in);
            this.idToShadowIndex.put(shadowIndex.getId(), shadowIndex);
        }
        this.visibleVersion = in.readLong();
        this.visibleVersionTime = in.readLong();
        this.visibleVersionHash = in.readLong();
        this.nextVersion = in.readLong();
        this.nextVersionHash = in.readLong();
        this.committedVersionHash = in.readLong();
        DistributionInfo.DistributionInfoType distriType = DistributionInfo.DistributionInfoType.valueOf(Text.readString((DataInput)in));
        if (distriType == DistributionInfo.DistributionInfoType.HASH) {
            this.distributionInfo = HashDistributionInfo.read(in);
        } else if (distriType == DistributionInfo.DistributionInfoType.RANDOM) {
            this.distributionInfo = RandomDistributionInfo.read(in);
        } else {
            throw new IOException("invalid distribution type: " + (Object)((Object)distriType));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Partition)) {
            return false;
        }
        Partition partition = (Partition)obj;
        if (this.idToVisibleRollupIndex != partition.idToVisibleRollupIndex) {
            if (this.idToVisibleRollupIndex.size() != partition.idToVisibleRollupIndex.size()) {
                return false;
            }
            for (Map.Entry<Long, MaterializedIndex> entry : this.idToVisibleRollupIndex.entrySet()) {
                long key = entry.getKey();
                if (!partition.idToVisibleRollupIndex.containsKey(key)) {
                    return false;
                }
                if (entry.getValue().equals(partition.idToVisibleRollupIndex.get(key))) continue;
                return false;
            }
        }
        return this.visibleVersion == partition.visibleVersion && this.baseIndex.equals(partition.baseIndex) && this.distributionInfo.equals(partition.distributionInfo);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("partition_id: ").append(this.id).append("; ");
        buffer.append("name: ").append(this.name).append("; ");
        buffer.append("partition_state.name: ").append(this.state.name()).append("; ");
        buffer.append("base_index: ").append(this.baseIndex.toString()).append("; ");
        int rollupCount = this.idToVisibleRollupIndex != null ? this.idToVisibleRollupIndex.size() : 0;
        buffer.append("rollup count: ").append(rollupCount).append("; ");
        if (this.idToVisibleRollupIndex != null) {
            for (Map.Entry<Long, MaterializedIndex> entry : this.idToVisibleRollupIndex.entrySet()) {
                buffer.append("rollup_index: ").append(entry.getValue().toString()).append("; ");
            }
        }
        buffer.append("committedVersion: ").append(this.visibleVersion).append("; ");
        buffer.append("distribution_info.type: ").append(this.distributionInfo.getType().name()).append("; ");
        buffer.append("distribution_info: ").append(this.distributionInfo.toString());
        return buffer.toString();
    }

    public void convertHashDistributionToRandomDistribution() {
        if (this.distributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH) {
            this.distributionInfo = ((HashDistributionInfo)this.distributionInfo).toRandomDistributionInfo();
        }
    }

    public static enum PartitionState {
        NORMAL,
        ROLLUP,
        SCHEMA_CHANGE,
        RESTORE;

    }
}

