/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.CreateTableStmt;
import org.apache.doris.analysis.DataSortInfo;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.ListPartitionInfo;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.RandomDistributionInfo;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.SinglePartitionInfo;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.TableIndexes;
import org.apache.doris.catalog.TableProperty;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TempPartitions;
import org.apache.doris.catalog.Type;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.DeepCopy;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.Util;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.TCompressionType;
import org.apache.doris.thrift.TOlapTable;
import org.apache.doris.thrift.TSortType;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapTable
extends Table {
    private static final Logger LOG = LogManager.getLogger(OlapTable.class);
    private volatile OlapTableState state;
    private Map<Long, MaterializedIndexMeta> indexIdToMeta = Maps.newHashMap();
    private Map<String, Long> indexNameToId = Maps.newHashMap();
    private KeysType keysType;
    private PartitionInfo partitionInfo;
    private Map<Long, Partition> idToPartition = new HashMap<Long, Partition>();
    private Map<String, Partition> nameToPartition = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private DistributionInfo defaultDistributionInfo;
    private TempPartitions tempPartitions = new TempPartitions();
    private Set<String> bfColumns;
    private double bfFpp;
    private String colocateGroup;
    private boolean hasSequenceCol;
    private Type sequenceType;
    private TableIndexes indexes;
    private long baseIndexId = -1L;
    private TableProperty tableProperty;

    public OlapTable() {
        super(Table.TableType.OLAP);
        this.bfColumns = null;
        this.bfFpp = 0.0;
        this.colocateGroup = null;
        this.indexes = null;
        this.tableProperty = null;
        this.hasSequenceCol = false;
    }

    public OlapTable(long id, String tableName, List<Column> baseSchema, KeysType keysType, PartitionInfo partitionInfo, DistributionInfo defaultDistributionInfo) {
        this(id, tableName, baseSchema, keysType, partitionInfo, defaultDistributionInfo, null);
    }

    public OlapTable(long id, String tableName, List<Column> baseSchema, KeysType keysType, PartitionInfo partitionInfo, DistributionInfo defaultDistributionInfo, TableIndexes indexes) {
        super(id, tableName, Table.TableType.OLAP, baseSchema);
        this.state = OlapTableState.NORMAL;
        this.keysType = keysType;
        this.partitionInfo = partitionInfo;
        this.defaultDistributionInfo = defaultDistributionInfo;
        this.bfColumns = null;
        this.bfFpp = 0.0;
        this.colocateGroup = null;
        this.indexes = indexes;
        this.tableProperty = null;
    }

    public void setTableProperty(TableProperty tableProperty) {
        this.tableProperty = tableProperty;
    }

    public TableProperty getTableProperty() {
        return this.tableProperty;
    }

    public boolean dynamicPartitionExists() {
        return this.tableProperty != null && this.tableProperty.getDynamicPartitionProperty() != null && this.tableProperty.getDynamicPartitionProperty().isExist();
    }

    public boolean isZOrderSort() {
        return this.tableProperty != null && this.tableProperty.getDataSortInfo() != null && this.tableProperty.getDataSortInfo().getSortType() == TSortType.ZORDER;
    }

    public void setBaseIndexId(long baseIndexId) {
        this.baseIndexId = baseIndexId;
    }

    public long getBaseIndexId() {
        return this.baseIndexId;
    }

    public void setState(OlapTableState state) {
        this.state = state;
    }

    public OlapTableState getState() {
        return this.state;
    }

    public List<Index> getIndexes() {
        if (this.indexes == null) {
            return Lists.newArrayList();
        }
        return this.indexes.getIndexes();
    }

    public TableIndexes getTableIndexes() {
        return this.indexes;
    }

    public Map<String, Index> getIndexesMap() {
        HashMap<String, Index> indexMap = new HashMap<String, Index>();
        if (this.indexes != null) {
            Optional.ofNullable(this.indexes.getIndexes()).orElse(Collections.emptyList()).stream().forEach(i -> indexMap.put(i.getIndexName(), (Index)i));
        }
        return indexMap;
    }

    public void checkAndSetName(String newName, boolean onlyCheck) throws DdlException {
        for (String idxName : this.getIndexNameToId().keySet()) {
            if (!idxName.equals(newName)) continue;
            throw new DdlException("New name conflicts with rollup index name: " + idxName);
        }
        if (!onlyCheck) {
            this.setName(newName);
        }
    }

    @Override
    public void setName(String newName) {
        block0: {
            Iterator<Partition> iterator;
            long baseIndexId = this.indexNameToId.remove(this.name);
            this.indexNameToId.put(newName, baseIndexId);
            this.name = newName;
            if (this.partitionInfo.getType() != PartitionType.UNPARTITIONED || !(iterator = this.getPartitions().iterator()).hasNext()) break block0;
            Partition partition = iterator.next();
            partition.setName(newName);
            this.nameToPartition.clear();
            this.nameToPartition.put(newName, partition);
        }
    }

    public boolean hasMaterializedIndex(String indexName) {
        return this.indexNameToId.containsKey(indexName);
    }

    public void setIndexMeta(long indexId, String indexName, List<Column> schema, int schemaVersion, int schemaHash, short shortKeyColumnCount, TStorageType storageType, KeysType keysType) {
        this.setIndexMeta(indexId, indexName, schema, schemaVersion, schemaHash, shortKeyColumnCount, storageType, keysType, null);
    }

    public void setIndexMeta(long indexId, String indexName, List<Column> schema, int schemaVersion, int schemaHash, short shortKeyColumnCount, TStorageType storageType, KeysType keysType, OriginStatement origStmt) {
        if (indexName == null) {
            indexName = this.getIndexNameById(indexId);
            Preconditions.checkState((indexName != null ? 1 : 0) != 0);
        }
        if (keysType == null) {
            keysType = this.keysType;
        }
        if (storageType == null) {
            MaterializedIndexMeta oldIndexMeta = this.indexIdToMeta.get(indexId);
            Preconditions.checkState((oldIndexMeta != null ? 1 : 0) != 0);
            storageType = oldIndexMeta.getStorageType();
            Preconditions.checkState((storageType != null ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((storageType == TStorageType.COLUMN ? 1 : 0) != 0);
        }
        MaterializedIndexMeta indexMeta = new MaterializedIndexMeta(indexId, schema, schemaVersion, schemaHash, shortKeyColumnCount, storageType, keysType, origStmt);
        this.indexIdToMeta.put(indexId, indexMeta);
        this.indexNameToId.put(indexName, indexId);
    }

    public void rebuildFullSchema() {
        this.fullSchema.clear();
        this.nameToColumn.clear();
        for (Column baseColumn : this.indexIdToMeta.get(this.baseIndexId).getSchema()) {
            this.fullSchema.add(baseColumn);
            this.nameToColumn.put(baseColumn.getName(), baseColumn);
        }
        for (MaterializedIndexMeta indexMeta : this.indexIdToMeta.values()) {
            for (Column column : indexMeta.getSchema()) {
                if (this.nameToColumn.containsKey(column.getName())) continue;
                this.fullSchema.add(column);
                this.nameToColumn.put(column.getName(), column);
            }
        }
        LOG.debug("after rebuild full schema. table {}, schema: {}", (Object)this.id, (Object)this.fullSchema);
    }

    public boolean deleteIndexInfo(String indexName) {
        if (!this.indexNameToId.containsKey(indexName)) {
            return false;
        }
        long indexId = this.indexNameToId.remove(indexName);
        this.indexIdToMeta.remove(indexId);
        if (indexId != this.baseIndexId) {
            this.rebuildFullSchema();
        }
        return true;
    }

    public Map<String, Long> getIndexNameToId() {
        return this.indexNameToId;
    }

    public Long getIndexIdByName(String indexName) {
        return this.indexNameToId.get(indexName);
    }

    public Long getSegmentV2FormatIndexId() {
        String v2RollupIndexName = "__v2_" + this.getName();
        return this.indexNameToId.get(v2RollupIndexName);
    }

    public String getIndexNameById(long indexId) {
        for (Map.Entry<String, Long> entry : this.indexNameToId.entrySet()) {
            if (entry.getValue() != indexId) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<Long, MaterializedIndexMeta> getVisibleIndexIdToMeta() {
        HashMap visibleMVs = Maps.newHashMap();
        List<MaterializedIndex> mvs = this.getVisibleIndex();
        for (MaterializedIndex mv : mvs) {
            visibleMVs.put(mv.getId(), this.indexIdToMeta.get(mv.getId()));
        }
        return visibleMVs;
    }

    public List<MaterializedIndex> getVisibleIndex() {
        Optional<Partition> partition = this.idToPartition.values().stream().findFirst();
        return partition.isPresent() ? partition.get().getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE) : Collections.emptyList();
    }

    public Column getVisibleColumn(String columnName) {
        for (MaterializedIndexMeta meta : this.getVisibleIndexIdToMeta().values()) {
            for (Column column : meta.getSchema()) {
                if (!column.getName().equalsIgnoreCase(columnName)) continue;
                return column;
            }
        }
        return null;
    }

    @Override
    public long getUpdateTime() {
        long updateTime = this.tempPartitions.getUpdateTime();
        for (Partition p : this.idToPartition.values()) {
            if (p.getVisibleVersionTime() <= updateTime) continue;
            updateTime = p.getVisibleVersionTime();
        }
        return updateTime;
    }

    public void renameIndexForSchemaChange(String name, String newName) {
        long idxId = this.indexNameToId.remove(name);
        this.indexNameToId.put(newName, idxId);
    }

    public void renameColumnNamePrefix(long idxId) {
        List<Column> columns = this.indexIdToMeta.get(idxId).getSchema();
        for (Column column : columns) {
            column.setName(Column.removeNamePrefix(column.getName()));
        }
    }

    public void resetPropertiesForRestore() {
        if (this.tableProperty != null) {
            this.tableProperty.resetPropertiesForRestore();
        }
        this.setColocateGroup(null);
    }

    public Status resetIdsForRestore(Catalog catalog, Database db, ReplicaAllocation restoreReplicaAlloc) {
        this.id = catalog.getNextId();
        HashMap origIdxIdToName = Maps.newHashMap();
        for (Map.Entry<String, Long> entry : this.indexNameToId.entrySet()) {
            origIdxIdToName.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Long> entry : origIdxIdToName.entrySet()) {
            long newIdxId = catalog.getNextId();
            if (((String)((Object)entry.getValue())).equals(this.name)) {
                this.baseIndexId = newIdxId;
            }
            this.indexIdToMeta.put(newIdxId, this.indexIdToMeta.remove(entry.getKey()));
            this.indexNameToId.put((String)((Object)entry.getValue()), newIdxId);
        }
        HashMap origPartNameToId = Maps.newHashMap();
        for (Partition partition : this.idToPartition.values()) {
            origPartNameToId.put(partition.getName(), partition.getId());
        }
        if (this.partitionInfo.getType() == PartitionType.RANGE || this.partitionInfo.getType() == PartitionType.LIST) {
            for (Map.Entry entry : origPartNameToId.entrySet()) {
                long newPartId = catalog.getNextId();
                this.partitionInfo.resetPartitionIdForRestore(newPartId, (Long)entry.getValue(), restoreReplicaAlloc, false);
                this.idToPartition.put(newPartId, this.idToPartition.remove(entry.getValue()));
            }
        } else {
            long l = catalog.getNextId();
            for (Map.Entry entry : origPartNameToId.entrySet()) {
                this.partitionInfo.resetPartitionIdForRestore(l, (Long)entry.getValue(), restoreReplicaAlloc, true);
                this.idToPartition.put(l, this.idToPartition.remove(entry.getValue()));
            }
        }
        for (Map.Entry<Long, Partition> entry : this.idToPartition.entrySet()) {
            Partition partition = entry.getValue();
            ReplicaAllocation replicaAlloc = this.partitionInfo.getReplicaAllocation(entry.getKey());
            for (Map.Entry entry2 : origIdxIdToName.entrySet()) {
                MaterializedIndex idx = partition.getIndex((Long)entry2.getKey());
                long newIdxId = this.indexNameToId.get(entry2.getValue());
                int schemaHash = this.indexIdToMeta.get(newIdxId).getSchemaHash();
                idx.setIdForRestore(newIdxId);
                if (newIdxId != this.baseIndexId) {
                    partition.deleteRollupIndex((Long)entry2.getKey());
                    partition.createRollupIndex(idx);
                }
                int tabletNum = idx.getTablets().size();
                idx.clearTabletsForRestore();
                for (int i = 0; i < tabletNum; ++i) {
                    long newTabletId = catalog.getNextId();
                    Tablet newTablet = new Tablet(newTabletId);
                    idx.addTablet(newTablet, null, true);
                    try {
                        Map<Tag, List<Long>> tag2beIds = Catalog.getCurrentSystemInfo().selectBackendIdsForReplicaCreation(replicaAlloc, db.getClusterName(), null);
                        for (Map.Entry<Tag, List<Long>> entry3 : tag2beIds.entrySet()) {
                            for (Long beId : entry3.getValue()) {
                                long newReplicaId = catalog.getNextId();
                                Replica replica = new Replica(newReplicaId, beId, Replica.ReplicaState.NORMAL, partition.getVisibleVersion(), schemaHash);
                                newTablet.addReplica(replica, true);
                            }
                        }
                        continue;
                    }
                    catch (DdlException e) {
                        return new Status(Status.ErrCode.COMMON_ERROR, e.getMessage());
                    }
                }
            }
            partition.setIdForRestore(entry.getKey());
        }
        return Status.OK;
    }

    public Map<Long, MaterializedIndexMeta> getIndexIdToMeta() {
        return this.indexIdToMeta;
    }

    public Map<Long, MaterializedIndexMeta> getCopiedIndexIdToMeta() {
        return new HashMap<Long, MaterializedIndexMeta>(this.indexIdToMeta);
    }

    public MaterializedIndexMeta getIndexMetaByIndexId(long indexId) {
        return this.indexIdToMeta.get(indexId);
    }

    public List<Long> getIndexIdListExceptBaseIndex() {
        ArrayList result = Lists.newArrayList();
        for (Long indexId : this.indexIdToMeta.keySet()) {
            if (indexId == this.baseIndexId) continue;
            result.add(indexId);
        }
        return result;
    }

    public Map<Long, List<Column>> getIndexIdToSchema() {
        return this.getIndexIdToSchema(Util.showHiddenColumns());
    }

    public Map<Long, List<Column>> getIndexIdToSchema(boolean full) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<Long, MaterializedIndexMeta> entry : this.indexIdToMeta.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSchema(full));
        }
        return result;
    }

    public List<Column> getSchemaByIndexId(Long indexId) {
        return this.getSchemaByIndexId(indexId, Util.showHiddenColumns());
    }

    public List<Column> getSchemaByIndexId(Long indexId, boolean full) {
        if (full) {
            return this.indexIdToMeta.get(indexId).getSchema();
        }
        return this.indexIdToMeta.get(indexId).getSchema().stream().filter(column -> column.isVisible()).collect(Collectors.toList());
    }

    public List<Column> getKeyColumnsByIndexId(Long indexId) {
        ArrayList keyColumns = Lists.newArrayList();
        List<Column> allColumns = this.getSchemaByIndexId(indexId);
        for (Column column : allColumns) {
            if (!column.isKey()) continue;
            keyColumns.add(column);
        }
        return keyColumns;
    }

    public boolean hasDeleteSign() {
        return this.getDeleteSignColumn() != null;
    }

    public Column getDeleteSignColumn() {
        for (Column column : this.getBaseSchema(true)) {
            if (!column.isDeleteSignColumn()) continue;
            return column;
        }
        return null;
    }

    public Map<Long, Integer> getIndexIdToSchemaHash() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<Long, MaterializedIndexMeta> entry : this.indexIdToMeta.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSchemaHash());
        }
        return result;
    }

    public int getSchemaHashByIndexId(Long indexId) {
        MaterializedIndexMeta indexMeta = this.indexIdToMeta.get(indexId);
        if (indexMeta == null) {
            return -1;
        }
        return indexMeta.getSchemaHash();
    }

    public TStorageType getStorageTypeByIndexId(Long indexId) {
        MaterializedIndexMeta indexMeta = this.indexIdToMeta.get(indexId);
        if (indexMeta == null) {
            return TStorageType.COLUMN;
        }
        return indexMeta.getStorageType();
    }

    public KeysType getKeysType() {
        return this.keysType;
    }

    public KeysType getKeysTypeByIndexId(long indexId) {
        MaterializedIndexMeta indexMeta = this.indexIdToMeta.get(indexId);
        Preconditions.checkNotNull((Object)indexMeta, (Object)("index id:" + indexId + " meta is null"));
        return indexMeta.getKeysType();
    }

    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public Set<String> getPartitionColumnNames() throws DdlException {
        HashSet partitionColumnNames = Sets.newHashSet();
        if (this.partitionInfo instanceof SinglePartitionInfo) {
            return partitionColumnNames;
        }
        if (this.partitionInfo instanceof RangePartitionInfo) {
            RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)this.partitionInfo;
            return rangePartitionInfo.getPartitionColumns().stream().map(c -> c.getName().toLowerCase()).collect(Collectors.toSet());
        }
        if (this.partitionInfo instanceof ListPartitionInfo) {
            ListPartitionInfo listPartitionInfo = (ListPartitionInfo)this.partitionInfo;
            return listPartitionInfo.getPartitionColumns().stream().map(c -> c.getName().toLowerCase()).collect(Collectors.toSet());
        }
        throw new DdlException("Unknown partition info type: " + this.partitionInfo.getType().name());
    }

    public DistributionInfo getDefaultDistributionInfo() {
        return this.defaultDistributionInfo;
    }

    public Set<String> getDistributionColumnNames() {
        HashSet distributionColumnNames = Sets.newHashSet();
        if (this.defaultDistributionInfo instanceof RandomDistributionInfo) {
            return distributionColumnNames;
        }
        HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)this.defaultDistributionInfo;
        List<Column> partitionColumns = hashDistributionInfo.getDistributionColumns();
        for (Column column : partitionColumns) {
            distributionColumnNames.add(column.getName().toLowerCase());
        }
        return distributionColumnNames;
    }

    public void renamePartition(String partitionName, String newPartitionName) {
        if (this.partitionInfo.getType() == PartitionType.UNPARTITIONED) {
            Iterator<Partition> iterator = this.idToPartition.values().iterator();
            if (iterator.hasNext()) {
                Partition partition = iterator.next();
                partition.setName(newPartitionName);
                this.nameToPartition.clear();
                this.nameToPartition.put(newPartitionName, partition);
                LOG.info("rename partition {} in table {}", (Object)newPartitionName, (Object)this.name);
            }
        } else {
            Partition partition = this.nameToPartition.remove(partitionName);
            partition.setName(newPartitionName);
            this.nameToPartition.put(newPartitionName, partition);
        }
    }

    public void addPartition(Partition partition) {
        this.idToPartition.put(partition.getId(), partition);
        this.nameToPartition.put(partition.getName(), partition);
    }

    private Partition dropPartition(long dbId, String partitionName, boolean isForceDrop, boolean reserveTablets) {
        Partition partition = this.nameToPartition.get(partitionName);
        if (partition != null) {
            this.idToPartition.remove(partition.getId());
            this.nameToPartition.remove(partitionName);
            Preconditions.checkState((this.partitionInfo.getType() == PartitionType.RANGE || this.partitionInfo.getType() == PartitionType.LIST ? 1 : 0) != 0);
            if (!isForceDrop) {
                if (this.partitionInfo.getType() == PartitionType.RANGE) {
                    Catalog.getCurrentRecycleBin().recyclePartition(dbId, this.id, partition, (Range<PartitionKey>)((Range)this.partitionInfo.getItem(partition.getId()).getItems()), new ListPartitionItem(Lists.newArrayList((Object[])new PartitionKey[]{new PartitionKey()})), this.partitionInfo.getDataProperty(partition.getId()), this.partitionInfo.getReplicaAllocation(partition.getId()), this.partitionInfo.getIsInMemory(partition.getId()));
                } else if (this.partitionInfo.getType() == PartitionType.LIST) {
                    ArrayList<Column> dummyColumns = new ArrayList<Column>();
                    dummyColumns.add(new Column("dummy", PrimitiveType.INT));
                    PartitionKey dummyKey = null;
                    try {
                        dummyKey = PartitionKey.createInfinityPartitionKey(dummyColumns, false);
                    }
                    catch (AnalysisException e) {
                        e.printStackTrace();
                    }
                    Range dummyRange = Range.open((Comparable)new PartitionKey(), (Comparable)dummyKey);
                    Catalog.getCurrentRecycleBin().recyclePartition(dbId, this.id, partition, (Range<PartitionKey>)dummyRange, this.partitionInfo.getItem(partition.getId()), this.partitionInfo.getDataProperty(partition.getId()), this.partitionInfo.getReplicaAllocation(partition.getId()), this.partitionInfo.getIsInMemory(partition.getId()));
                }
            } else if (!reserveTablets) {
                Catalog.getCurrentCatalog().onErasePartition(partition);
            }
            this.partitionInfo.dropPartition(partition.getId());
        }
        return partition;
    }

    public Partition dropPartitionAndReserveTablet(String partitionName) {
        return this.dropPartition(-1L, partitionName, true, true);
    }

    public Partition dropPartition(long dbId, String partitionName, boolean isForceDrop) {
        return this.dropPartition(dbId, partitionName, isForceDrop, !isForceDrop);
    }

    @Override
    public Partition getPartition(String partitionName) {
        return this.getPartition(partitionName, false);
    }

    public Partition getPartition(String partitionName, boolean isTempPartition) {
        if (isTempPartition) {
            return this.tempPartitions.getPartition(partitionName);
        }
        return this.nameToPartition.get(partitionName);
    }

    public Partition getPartition(long partitionId) {
        Partition partition = this.idToPartition.get(partitionId);
        if (partition == null) {
            partition = this.tempPartitions.getPartition(partitionId);
        }
        return partition;
    }

    public Collection<Partition> getPartitions() {
        return this.idToPartition.values();
    }

    public Collection<Partition> getTempPartitions() {
        return this.tempPartitions.getAllPartitions();
    }

    public Collection<Partition> getAllPartitions() {
        ArrayList partitions = Lists.newArrayList(this.idToPartition.values());
        partitions.addAll(this.tempPartitions.getAllPartitions());
        return partitions;
    }

    public Set<String> getPartitionNames() {
        return Sets.newHashSet(this.nameToPartition.keySet());
    }

    public List<Long> getPartitionIds() {
        return this.getPartitions().stream().map(entity -> entity.getId()).collect(Collectors.toList());
    }

    public Set<String> getCopiedBfColumns() {
        if (this.bfColumns == null) {
            return null;
        }
        return Sets.newHashSet(this.bfColumns);
    }

    public List<Index> getCopiedIndexes() {
        if (this.indexes == null) {
            return Lists.newArrayList();
        }
        return this.indexes.getCopiedIndexes();
    }

    public double getBfFpp() {
        return this.bfFpp;
    }

    public void setBloomFilterInfo(Set<String> bfColumns, double bfFpp) {
        this.bfColumns = bfColumns;
        this.bfFpp = bfFpp;
    }

    public void setSequenceInfo(Type type) {
        this.hasSequenceCol = true;
        this.sequenceType = type;
        Column sequenceCol = ColumnDef.newSequenceColumnDef(type, AggregateType.REPLACE).toColumn();
        this.fullSchema.add(sequenceCol);
        this.nameToColumn.put("__DORIS_SEQUENCE_COL__", sequenceCol);
        for (MaterializedIndexMeta indexMeta : this.indexIdToMeta.values()) {
            List<Column> schema = indexMeta.getSchema();
            schema.add(sequenceCol);
        }
    }

    public Column getSequenceCol() {
        for (Column column : this.getBaseSchema(true)) {
            if (!column.isSequenceColumn()) continue;
            return column;
        }
        return null;
    }

    public Boolean hasSequenceCol() {
        return this.getSequenceCol() != null;
    }

    public boolean hasHiddenColumn() {
        return this.getBaseSchema().stream().anyMatch(column -> !column.isVisible());
    }

    public Type getSequenceType() {
        if (this.getSequenceCol() == null) {
            return null;
        }
        return this.getSequenceCol().getType();
    }

    public void setIndexes(List<Index> indexes) {
        if (this.indexes == null) {
            this.indexes = new TableIndexes(null);
        }
        this.indexes.setIndexes(indexes);
    }

    public boolean isColocateTable() {
        return this.colocateGroup != null;
    }

    public String getColocateGroup() {
        return this.colocateGroup;
    }

    public void setColocateGroup(String colocateGroup) {
        this.colocateGroup = colocateGroup;
    }

    public boolean shouldLoadToNewRollup() {
        return false;
    }

    @Override
    public TTableDescriptor toThrift() {
        TOlapTable tOlapTable = new TOlapTable(this.getName());
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.id, TTableType.OLAP_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setOlapTable(tOlapTable);
        return tTableDescriptor;
    }

    @Override
    public long getRowCount() {
        long rowCount = 0L;
        for (Map.Entry<Long, Partition> entry : this.idToPartition.entrySet()) {
            rowCount += entry.getValue().getBaseIndex().getRowCount();
        }
        return rowCount;
    }

    @Override
    public long getAvgRowLength() {
        long rowCount = 0L;
        long dataSize = 0L;
        for (Map.Entry<Long, Partition> entry : this.idToPartition.entrySet()) {
            rowCount += entry.getValue().getBaseIndex().getRowCount();
            dataSize += entry.getValue().getBaseIndex().getDataSize();
        }
        if (rowCount > 0L) {
            return dataSize / rowCount;
        }
        return 0L;
    }

    @Override
    public long getDataLength() {
        long dataSize = 0L;
        for (Map.Entry<Long, Partition> entry : this.idToPartition.entrySet()) {
            dataSize += entry.getValue().getBaseIndex().getDataSize();
        }
        return dataSize;
    }

    @Override
    public CreateTableStmt toCreateTableStmt(String dbName) {
        throw new RuntimeException("Don't support anymore");
    }

    public String getSignature(int signatureVersion, List<String> partNames) {
        StringBuilder sb = new StringBuilder(signatureVersion);
        sb.append(this.name);
        sb.append((Object)this.type);
        TreeSet indexNames = Sets.newTreeSet(this.indexNameToId.keySet());
        for (String indexName : indexNames) {
            long indexId = this.indexNameToId.get(indexName);
            MaterializedIndexMeta indexMeta = this.indexIdToMeta.get(indexId);
            sb.append(indexName);
            sb.append(Util.getSchemaSignatureString(indexMeta.getSchema()));
            sb.append(indexMeta.getShortKeyColumnCount());
            sb.append(indexMeta.getStorageType());
        }
        if (this.bfColumns != null && !this.bfColumns.isEmpty()) {
            for (String bfCol : this.bfColumns) {
                sb.append(bfCol);
            }
            sb.append(this.bfFpp);
        }
        sb.append((Object)this.partitionInfo.getType());
        if (this.partitionInfo.getType() == PartitionType.RANGE) {
            RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)this.partitionInfo;
            List<Column> partitionColumns = rangePartitionInfo.getPartitionColumns();
            sb.append(Util.getSchemaSignatureString(partitionColumns));
        }
        Collections.sort(partNames, String.CASE_INSENSITIVE_ORDER);
        for (String partName : partNames) {
            Partition partition = this.getPartition(partName);
            Preconditions.checkNotNull((Object)partition, (Object)partName);
            DistributionInfo distributionInfo = partition.getDistributionInfo();
            sb.append(partName);
            sb.append((Object)distributionInfo.getType());
            if (distributionInfo.getType() != DistributionInfo.DistributionInfoType.HASH) continue;
            HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)distributionInfo;
            sb.append(Util.getSchemaSignatureString(hashDistributionInfo.getDistributionColumns()));
            sb.append(hashDistributionInfo.getBucketNum());
        }
        String md5 = DigestUtils.md5Hex((String)sb.toString());
        LOG.debug("get signature of table {}: {}. signature string: {}", (Object)this.name, (Object)md5, (Object)sb.toString());
        return md5;
    }

    public Status getIntersectPartNamesWith(OlapTable anotherTbl, List<String> intersectPartNames) {
        if (this.getPartitionInfo().getType() != anotherTbl.getPartitionInfo().getType()) {
            return new Status(Status.ErrCode.COMMON_ERROR, "Table's partition type is different");
        }
        Set<String> intersect = this.getPartitionNames();
        intersect.retainAll(anotherTbl.getPartitionNames());
        intersectPartNames.addAll(intersect);
        return Status.OK;
    }

    @Override
    public boolean isPartitioned() {
        int numSegs = 0;
        for (Partition part : this.getPartitions()) {
            if ((numSegs += part.getDistributionInfo().getBucketNum()) <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.state.name());
        int counter = this.indexNameToId.size();
        out.writeInt(counter);
        for (Map.Entry<String, Long> entry : this.indexNameToId.entrySet()) {
            String indexName = entry.getKey();
            long indexId = entry.getValue();
            Text.writeString((DataOutput)out, (String)indexName);
            out.writeLong(indexId);
            this.indexIdToMeta.get(indexId).write(out);
        }
        Text.writeString((DataOutput)out, (String)this.keysType.name());
        Text.writeString((DataOutput)out, (String)this.partitionInfo.getType().name());
        this.partitionInfo.write(out);
        Text.writeString((DataOutput)out, (String)this.defaultDistributionInfo.getType().name());
        this.defaultDistributionInfo.write(out);
        int partitionCount = this.idToPartition.size();
        out.writeInt(partitionCount);
        for (Partition partition : this.idToPartition.values()) {
            partition.write(out);
        }
        if (this.bfColumns == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.bfColumns.size());
            for (String bfColumn : this.bfColumns) {
                Text.writeString((DataOutput)out, (String)bfColumn);
            }
            out.writeDouble(this.bfFpp);
        }
        if (this.colocateGroup == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.colocateGroup);
        }
        out.writeLong(this.baseIndexId);
        if (this.indexes != null) {
            out.writeBoolean(true);
            this.indexes.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.tableProperty == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.tableProperty.write(out);
        }
        this.tempPartitions.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.state = OlapTableState.valueOf(Text.readString((DataInput)in));
        int counter = in.readInt();
        ArrayList tmpIndexMetaList = Lists.newArrayList();
        for (int i = 0; i < counter; ++i) {
            String indexName = Text.readString((DataInput)in);
            long indexId = in.readLong();
            this.indexNameToId.put(indexName, indexId);
            MaterializedIndexMeta indexMeta = MaterializedIndexMeta.read(in);
            this.indexIdToMeta.put(indexId, indexMeta);
        }
        this.keysType = KeysType.valueOf(Text.readString((DataInput)in));
        for (MaterializedIndexMeta indexMeta : tmpIndexMetaList) {
            indexMeta.setKeysType(this.keysType);
            this.indexIdToMeta.put(indexMeta.getIndexId(), indexMeta);
        }
        PartitionType partType = PartitionType.valueOf(Text.readString((DataInput)in));
        if (partType == PartitionType.UNPARTITIONED) {
            this.partitionInfo = SinglePartitionInfo.read(in);
        } else if (partType == PartitionType.RANGE) {
            this.partitionInfo = RangePartitionInfo.read(in);
        } else if (partType == PartitionType.LIST) {
            this.partitionInfo = ListPartitionInfo.read(in);
        } else {
            throw new IOException("invalid partition type: " + (Object)((Object)partType));
        }
        DistributionInfo.DistributionInfoType distriType = DistributionInfo.DistributionInfoType.valueOf(Text.readString((DataInput)in));
        if (distriType == DistributionInfo.DistributionInfoType.HASH) {
            this.defaultDistributionInfo = HashDistributionInfo.read(in);
        } else if (distriType == DistributionInfo.DistributionInfoType.RANDOM) {
            this.defaultDistributionInfo = RandomDistributionInfo.read(in);
        } else {
            throw new IOException("invalid distribution type: " + (Object)((Object)distriType));
        }
        int partitionCount = in.readInt();
        for (int i = 0; i < partitionCount; ++i) {
            Partition partition = Partition.read(in);
            this.idToPartition.put(partition.getId(), partition);
            this.nameToPartition.put(partition.getName(), partition);
        }
        if (in.readBoolean()) {
            int bfColumnCount = in.readInt();
            this.bfColumns = Sets.newHashSet();
            for (int i = 0; i < bfColumnCount; ++i) {
                this.bfColumns.add(Text.readString((DataInput)in));
            }
            this.bfFpp = in.readDouble();
        }
        if (in.readBoolean()) {
            this.colocateGroup = Text.readString((DataInput)in);
        }
        this.baseIndexId = in.readLong();
        if (in.readBoolean()) {
            this.indexes = TableIndexes.read(in);
        }
        if (in.readBoolean()) {
            this.tableProperty = TableProperty.read(in);
        }
        this.tempPartitions = TempPartitions.read(in);
        RangePartitionInfo tempRangeInfo = this.tempPartitions.getPartitionInfo();
        if (tempRangeInfo != null) {
            for (long partitionId : tempRangeInfo.getIdToItem(false).keySet()) {
                this.partitionInfo.addPartition(partitionId, true, tempRangeInfo.getItem(partitionId), tempRangeInfo.getDataProperty(partitionId), tempRangeInfo.getReplicaAllocation(partitionId), tempRangeInfo.getIsInMemory(partitionId));
            }
        }
        this.tempPartitions.unsetPartitionInfo();
        this.rebuildFullSchema();
    }

    @Override
    public boolean equals(Table table) {
        if (this == table) {
            return true;
        }
        return table instanceof OlapTable;
    }

    public OlapTable selectiveCopy(Collection<String> reservedPartitions, MaterializedIndex.IndexExtState extState, boolean isForBackup) {
        OlapTable copied = new OlapTable();
        if (!DeepCopy.copy((Writable)this, (Writable)copied, OlapTable.class, (int)FeConstants.meta_version)) {
            LOG.warn("failed to copy olap table: " + this.getName());
            return null;
        }
        List<MaterializedIndex> shadowIndex = copied.getPartitions().stream().findFirst().get().getMaterializedIndices(MaterializedIndex.IndexExtState.SHADOW);
        for (MaterializedIndex deleteIndex : shadowIndex) {
            LOG.debug("copied table delete shadow index : {}", (Object)deleteIndex.getId());
            copied.deleteIndexInfo(copied.getIndexNameById(deleteIndex.getId()));
        }
        copied.setState(OlapTableState.NORMAL);
        for (Partition partition : copied.getPartitions()) {
            for (MaterializedIndex deleteIndex : shadowIndex) {
                partition.deleteRollupIndex(deleteIndex.getId());
            }
            partition.setState(Partition.PartitionState.NORMAL);
            if (isForBackup) {
                copied.getPartitionInfo().setDataProperty(partition.getId(), new DataProperty(TStorageMedium.HDD));
            }
            for (MaterializedIndex idx : partition.getMaterializedIndices(extState)) {
                idx.setState(MaterializedIndex.IndexState.NORMAL);
                for (Tablet tablet : idx.getTablets()) {
                    for (Replica replica : tablet.getReplicas()) {
                        replica.setState(Replica.ReplicaState.NORMAL);
                    }
                }
            }
        }
        if (reservedPartitions == null || reservedPartitions.isEmpty()) {
            return copied;
        }
        HashSet partNames = Sets.newHashSet();
        partNames.addAll(copied.getPartitionNames());
        Set lowerReservedPartitionNames = reservedPartitions.stream().map(String::toLowerCase).collect(Collectors.toSet());
        for (String partName : partNames) {
            if (lowerReservedPartitionNames.contains(partName.toLowerCase())) continue;
            copied.dropPartitionAndReserveTablet(partName);
        }
        return copied;
    }

    public Partition replacePartition(Partition newPartition) {
        Partition oldPartition = this.nameToPartition.remove(newPartition.getName());
        this.idToPartition.remove(oldPartition.getId());
        this.idToPartition.put(newPartition.getId(), newPartition);
        this.nameToPartition.put(newPartition.getName(), newPartition);
        DataProperty dataProperty = this.partitionInfo.getDataProperty(oldPartition.getId());
        ReplicaAllocation replicaAlloc = this.partitionInfo.getReplicaAllocation(oldPartition.getId());
        boolean isInMemory = this.partitionInfo.getIsInMemory(oldPartition.getId());
        if (this.partitionInfo.getType() == PartitionType.RANGE || this.partitionInfo.getType() == PartitionType.LIST) {
            PartitionItem item = this.partitionInfo.getItem(oldPartition.getId());
            this.partitionInfo.dropPartition(oldPartition.getId());
            this.partitionInfo.addPartition(newPartition.getId(), false, item, dataProperty, replicaAlloc, isInMemory);
        } else {
            this.partitionInfo.dropPartition(oldPartition.getId());
            this.partitionInfo.addPartition(newPartition.getId(), dataProperty, replicaAlloc, isInMemory);
        }
        return oldPartition;
    }

    public long getDataSize() {
        long dataSize = 0L;
        for (Partition partition : this.getAllPartitions()) {
            dataSize += partition.getDataSize();
        }
        return dataSize;
    }

    public long getReplicaCount() {
        long replicaCount = 0L;
        for (Partition partition : this.getAllPartitions()) {
            replicaCount += partition.getReplicaCount();
        }
        return replicaCount;
    }

    public void checkStableAndNormal(String clusterName) throws DdlException {
        if (this.state != OlapTableState.NORMAL) {
            throw new DdlException("Table[" + this.name + "]'s state is not NORMAL. Do not allow doing materialized view");
        }
        boolean isStable = this.isStable(Catalog.getCurrentSystemInfo(), Catalog.getCurrentCatalog().getTabletScheduler(), clusterName);
        if (!isStable) {
            throw new DdlException("table [" + this.name + "] is not stable. Some tablets of this table may not be healthy or are being scheduled. You need to repair the table first or stop cluster balance. See 'help admin;'.");
        }
    }

    public boolean isStable(SystemInfoService infoService, TabletScheduler tabletScheduler, String clusterName) {
        List<Long> aliveBeIdsInCluster = infoService.getClusterBackendIds(clusterName, true);
        for (Partition partition : this.idToPartition.values()) {
            long visibleVersion = partition.getVisibleVersion();
            ReplicaAllocation replicaAlloc = this.partitionInfo.getReplicaAllocation(partition.getId());
            for (MaterializedIndex mIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                for (Tablet tablet : mIndex.getTablets()) {
                    if (tabletScheduler.containsTablet(tablet.getId())) {
                        LOG.info("table {} is not stable because tablet {} is in tablet scheduler. replicas: {}", (Object)this.id, (Object)tablet.getId(), tablet.getReplicas());
                        return false;
                    }
                    Pair<Tablet.TabletStatus, TabletSchedCtx.Priority> statusPair = tablet.getHealthStatusWithPriority(infoService, clusterName, visibleVersion, replicaAlloc, aliveBeIdsInCluster);
                    if (statusPair.first == Tablet.TabletStatus.HEALTHY) continue;
                    LOG.info("table {} is not stable because tablet {} status is {}. replicas: {}", (Object)this.id, (Object)tablet.getId(), statusPair.first, tablet.getReplicas());
                    return false;
                }
            }
        }
        return true;
    }

    public Map<Tag, List<List<Long>>> getArbitraryTabletBucketsSeq() throws DdlException {
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        HashMap backendsPerBucketSeq = Maps.newHashMap();
        Iterator<Partition> iterator = this.idToPartition.values().iterator();
        if (iterator.hasNext()) {
            Partition partition = iterator.next();
            ReplicaAllocation replicaAlloc = this.partitionInfo.getReplicaAllocation(partition.getId());
            short totalReplicaNum = replicaAlloc.getTotalReplicaNum();
            MaterializedIndex baseIdx = partition.getBaseIndex();
            for (Long tabletId : baseIdx.getTabletIdsInOrder()) {
                Tablet tablet = baseIdx.getTablet(tabletId);
                List<Long> replicaBackendIds = tablet.getNormalReplicaBackendIds();
                if (replicaBackendIds.size() != totalReplicaNum) {
                    throw new DdlException("Normal replica number of tablet " + tabletId + " is: " + replicaBackendIds.size() + ", but expected: " + totalReplicaNum);
                }
                HashMap currentReplicaAlloc = Maps.newHashMap();
                HashMap tag2beIds = Maps.newHashMap();
                Iterator<Object> iterator2 = replicaBackendIds.iterator();
                while (iterator2.hasNext()) {
                    long l = iterator2.next();
                    Backend be = infoService.getBackend(l);
                    if (be == null) continue;
                    short num = currentReplicaAlloc.getOrDefault(be.getTag(), (short)0);
                    currentReplicaAlloc.put(be.getTag(), (short)(num + 1));
                    List beIds = tag2beIds.getOrDefault(be.getTag(), Lists.newArrayList());
                    beIds.add(l);
                    tag2beIds.put(be.getTag(), beIds);
                }
                if (!currentReplicaAlloc.equals(replicaAlloc.getAllocMap())) {
                    throw new DdlException("The relica allocation is " + ((Object)currentReplicaAlloc).toString() + ", but expected: " + replicaAlloc.toCreateStmt());
                }
                for (Map.Entry entry : tag2beIds.entrySet()) {
                    backendsPerBucketSeq.putIfAbsent((Tag)entry.getKey(), Lists.newArrayList());
                    ((List)backendsPerBucketSeq.get(entry.getKey())).add((List)entry.getValue());
                }
            }
        }
        return backendsPerBucketSeq;
    }

    public long proximateRowCount() {
        long totalCount = 0L;
        for (Partition partition : this.getPartitions()) {
            long version = partition.getVisibleVersion();
            for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                for (Tablet tablet : index.getTablets()) {
                    long tabletRowCount = 0L;
                    for (Replica replica : tablet.getReplicas()) {
                        if (!replica.checkVersionCatchUp(version, false) || replica.getRowCount() <= tabletRowCount) continue;
                        tabletRowCount = replica.getRowCount();
                    }
                    totalCount += tabletRowCount;
                }
            }
        }
        return totalCount;
    }

    @Override
    public List<Column> getBaseSchema() {
        return this.getSchemaByIndexId(this.baseIndexId);
    }

    @Override
    public List<Column> getBaseSchema(boolean full) {
        return this.getSchemaByIndexId(this.baseIndexId, full);
    }

    public Column getBaseColumn(String columnName) {
        for (Column column : this.getBaseSchema()) {
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public int getKeysNum() {
        int keysNum = 0;
        for (Column column : this.getBaseSchema()) {
            if (!column.isKey()) continue;
            ++keysNum;
        }
        return keysNum;
    }

    public boolean convertHashDistributionToRandomDistribution() {
        boolean hasChanged = false;
        if (this.defaultDistributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH) {
            this.defaultDistributionInfo = ((HashDistributionInfo)this.defaultDistributionInfo).toRandomDistributionInfo();
            hasChanged = true;
            for (Partition partition : this.idToPartition.values()) {
                partition.convertHashDistributionToRandomDistribution();
            }
        }
        return hasChanged;
    }

    public void setReplicationAllocation(ReplicaAllocation replicaAlloc) {
        if (this.tableProperty == null) {
            this.tableProperty = new TableProperty(new HashMap<String, String>());
        }
        this.tableProperty.setReplicaAlloc(replicaAlloc);
    }

    public ReplicaAllocation getDefaultReplicaAllocation() {
        if (this.tableProperty != null) {
            return this.tableProperty.getReplicaAllocation();
        }
        return ReplicaAllocation.DEFAULT_ALLOCATION;
    }

    public Boolean isInMemory() {
        if (this.tableProperty != null) {
            return this.tableProperty.isInMemory();
        }
        return false;
    }

    public void setIsInMemory(boolean isInMemory) {
        if (this.tableProperty == null) {
            this.tableProperty = new TableProperty(new HashMap<String, String>());
        }
        this.tableProperty.modifyTableProperties("in_memory", Boolean.valueOf(isInMemory).toString());
        this.tableProperty.buildInMemory();
    }

    public void setDataSortInfo(DataSortInfo dataSortInfo) {
        if (this.tableProperty == null) {
            this.tableProperty = new TableProperty(new HashMap<String, String>());
        }
        this.tableProperty.modifyDataSortInfoProperties(dataSortInfo);
        this.tableProperty.buildDataSortInfo();
    }

    public boolean checkPartitionNameExist(String partitionName) {
        if (this.nameToPartition.containsKey(partitionName)) {
            return true;
        }
        return this.tempPartitions.hasPartition(partitionName);
    }

    public boolean checkPartitionNameExist(String partitionName, boolean isTempPartition) {
        if (isTempPartition) {
            return this.tempPartitions.hasPartition(partitionName);
        }
        return this.nameToPartition.containsKey(partitionName);
    }

    public void dropTempPartition(String partitionName, boolean needDropTablet) {
        Partition partition = this.getPartition(partitionName, true);
        if (partition != null) {
            this.partitionInfo.dropPartition(partition.getId());
            this.tempPartitions.dropPartition(partitionName, needDropTablet);
        }
    }

    public void replaceTempPartitions(List<String> partitionNames, List<String> tempPartitionNames, boolean strictRange, boolean useTempPartitionName) throws DdlException {
        this.checkPartition(partitionNames, tempPartitionNames, strictRange);
        for (String partitionName : partitionNames) {
            this.dropPartition(-1L, partitionName, true);
        }
        for (String partitionName : tempPartitionNames) {
            Partition partition = this.tempPartitions.getPartition(partitionName);
            this.addPartition(partition);
            this.tempPartitions.dropPartition(partitionName, false);
            this.partitionInfo.moveFromTempToFormal(partition.getId());
        }
        if (!useTempPartitionName && partitionNames.size() == tempPartitionNames.size()) {
            for (int i = 0; i < tempPartitionNames.size(); ++i) {
                this.renamePartition(tempPartitionNames.get(i), partitionNames.get(i));
            }
        }
    }

    private void checkPartition(List<String> partitionNames, List<String> tempPartitionNames, boolean strictRange) throws DdlException {
        if (strictRange) {
            Partition partition;
            ArrayList list = Lists.newArrayList();
            ArrayList tempList = Lists.newArrayList();
            for (String partName : partitionNames) {
                partition = this.nameToPartition.get(partName);
                Preconditions.checkNotNull((Object)partition);
                list.add(this.partitionInfo.getItem(partition.getId()));
            }
            for (String partName : tempPartitionNames) {
                partition = this.tempPartitions.getPartition(partName);
                Preconditions.checkNotNull((Object)partition);
                tempList.add(this.partitionInfo.getItem(partition.getId()));
            }
            this.partitionInfo.checkPartitionItemListsMatch(list, tempList);
        } else {
            HashSet replacePartitionIds = Sets.newHashSet();
            for (String partName : partitionNames) {
                Partition partition = this.nameToPartition.get(partName);
                Preconditions.checkNotNull((Object)partition);
                replacePartitionIds.add(partition.getId());
            }
            List<PartitionItem> currentItemList = this.partitionInfo.getItemList(replacePartitionIds, false);
            ArrayList replacePartitionItems = Lists.newArrayList();
            for (String partName : tempPartitionNames) {
                Partition partition = this.tempPartitions.getPartition(partName);
                Preconditions.checkNotNull((Object)partition);
                replacePartitionItems.add(this.partitionInfo.getItem(partition.getId()));
            }
            this.partitionInfo.checkPartitionItemListsConflict(currentItemList, replacePartitionItems);
        }
    }

    public void addTempPartition(Partition partition) {
        this.tempPartitions.addPartition(partition);
    }

    public void dropAllTempPartitions() {
        for (Partition partition : this.tempPartitions.getAllPartitions()) {
            this.partitionInfo.dropPartition(partition.getId());
        }
        this.tempPartitions.dropAll();
    }

    public boolean existTempPartitions() {
        return !this.tempPartitions.isEmpty();
    }

    public void setCompressionType(TCompressionType compressionType) {
        if (this.tableProperty == null) {
            this.tableProperty = new TableProperty(new HashMap<String, String>());
        }
        this.tableProperty.modifyTableProperties("compression", compressionType.name());
        this.tableProperty.buildCompressionType();
    }

    public void setStorageFormat(TStorageFormat storageFormat) {
        if (this.tableProperty == null) {
            this.tableProperty = new TableProperty(new HashMap<String, String>());
        }
        this.tableProperty.modifyTableProperties("storage_format", storageFormat.name());
        this.tableProperty.buildStorageFormat();
    }

    public TStorageFormat getStorageFormat() {
        if (this.tableProperty == null) {
            return TStorageFormat.DEFAULT;
        }
        return this.tableProperty.getStorageFormat();
    }

    public TCompressionType getCompressionType() {
        if (this.tableProperty == null) {
            return TCompressionType.LZ4F;
        }
        return this.tableProperty.getCompressionType();
    }

    public DataSortInfo getDataSortInfo() {
        if (this.tableProperty == null) {
            return new DataSortInfo(TSortType.LEXICAL, this.getKeysNum());
        }
        return this.tableProperty.getDataSortInfo();
    }

    public boolean meetAggDistributionRequirements(AggregateInfo aggregateInfo) {
        ArrayList<Expr> groupingExps = aggregateInfo.getGroupingExprs();
        if (groupingExps == null || groupingExps.isEmpty()) {
            return false;
        }
        List<Expr> partitionExps = aggregateInfo.getPartitionExprs() != null ? aggregateInfo.getPartitionExprs() : groupingExps;
        DistributionInfo distribution = this.getDefaultDistributionInfo();
        if (distribution instanceof HashDistributionInfo) {
            List<Column> rangeColumns;
            List<Column> distributeColumns = ((HashDistributionInfo)distribution).getDistributionColumns();
            PartitionInfo partitionInfo = this.getPartitionInfo();
            if (partitionInfo instanceof RangePartitionInfo && !distributeColumns.containsAll(rangeColumns = ((RangePartitionInfo)partitionInfo).getPartitionColumns())) {
                return false;
            }
            List partitionSlots = partitionExps.stream().map(Expr::unwrapSlotRef).collect(Collectors.toList());
            if (partitionSlots.contains(null)) {
                return false;
            }
            List hashColumns = partitionSlots.stream().map(SlotRef::getDesc).map(SlotDescriptor::getColumn).collect(Collectors.toList());
            return hashColumns.containsAll(distributeColumns);
        }
        return false;
    }

    public void checkReplicaAllocation() throws UserException {
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        for (Partition partition : this.getPartitions()) {
            ReplicaAllocation replicaAlloc = this.getPartitionInfo().getReplicaAllocation(partition.getId());
            Map<Tag, Short> allocMap = replicaAlloc.getAllocMap();
            for (MaterializedIndex mIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                for (Tablet tablet : mIndex.getTablets()) {
                    HashMap curMap = Maps.newHashMap();
                    for (Replica replica : tablet.getReplicas()) {
                        Backend be = infoService.getBackend(replica.getBackendId());
                        if (be == null) continue;
                        short num = curMap.getOrDefault(be.getTag(), (short)0);
                        curMap.put(be.getTag(), (short)(num + 1));
                    }
                    if (curMap.equals(allocMap)) continue;
                    throw new UserException("replica allocation of tablet " + tablet.getId() + " is not expected, expected: " + allocMap.toString() + ", actual: " + ((Object)curMap).toString());
                }
            }
        }
    }

    public static enum OlapTableState {
        NORMAL,
        ROLLUP,
        SCHEMA_CHANGE,
        BACKUP,
        RESTORE,
        RESTORE_WITH_LOAD,
        WAITING_STABLE;

    }
}

