/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OdbcCatalogResource;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.DeepCopy;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TOdbcTable;
import org.apache.doris.thrift.TOdbcTableType;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OdbcTable
extends Table {
    private static final Logger LOG = LogManager.getLogger(OlapTable.class);
    public static final String ODBC_CATALOG_RESOURCE = "odbc_catalog_resource";
    public static final String ODBC_HOST = "host";
    public static final String ODBC_PORT = "port";
    public static final String ODBC_USER = "user";
    public static final String ODBC_PASSWORD = "password";
    public static final String ODBC_DATABASE = "database";
    public static final String ODBC_TABLE = "table";
    public static final String ODBC_DRIVER = "driver";
    public static final String ODBC_TYPE = "odbc_type";
    private static Map<String, TOdbcTableType> TABLE_TYPE_MAP;
    private String odbcCatalogResourceName;
    private String host;
    private String port;
    private String userName;
    private String passwd;
    private String odbcDatabaseName;
    private String odbcTableName;
    private String driver;
    private String odbcTableTypeName;

    private static String mysqlProperName(String name) {
        return "`" + name + "`";
    }

    public static String databaseProperName(TOdbcTableType tableType, String name) {
        switch (tableType) {
            case MYSQL: {
                return OdbcTable.mysqlProperName(name);
            }
        }
        return name;
    }

    public OdbcTable() {
        super(Table.TableType.ODBC);
    }

    public OdbcTable(long id, String name, List<Column> schema, Map<String, String> properties) throws DdlException {
        super(id, name, Table.TableType.ODBC, schema);
        this.validate(properties);
    }

    private void validate(Map<String, String> properties) throws DdlException {
        if (properties == null) {
            throw new DdlException("Please set properties of odbc table, they are: odbc_catalog_resource or [host, port, user, password, driver, odbc_type] and database and table");
        }
        if (properties.containsKey(ODBC_CATALOG_RESOURCE)) {
            this.odbcCatalogResourceName = properties.get(ODBC_CATALOG_RESOURCE);
            Resource oriResource = Catalog.getCurrentCatalog().getResourceMgr().getResource(this.odbcCatalogResourceName);
            if (oriResource == null) {
                throw new DdlException("Resource does not exist. name: " + this.odbcCatalogResourceName);
            }
            if (!Catalog.getCurrentCatalog().getAuth().checkResourcePriv(ConnectContext.get(), this.odbcCatalogResourceName, PrivPredicate.USAGE)) {
                throw new DdlException("USAGE denied to user '" + ConnectContext.get().getQualifiedUser() + "'@'" + ConnectContext.get().getRemoteIP() + "' for resource '" + this.odbcCatalogResourceName + "'");
            }
        } else {
            this.host = properties.get(ODBC_HOST);
            if (Strings.isNullOrEmpty((String)this.host)) {
                throw new DdlException("Host of Odbc table is null. Please set proper resource or add properties('host'='xxx.xxx.xxx.xxx') when create table");
            }
            this.port = properties.get(ODBC_PORT);
            if (Strings.isNullOrEmpty((String)this.port)) {
                throw new DdlException("Port of Odbc table is null. Please set odbc_catalog_resource or add properties('port'='3306') when create table");
            }
            try {
                Integer.valueOf(this.port);
            }
            catch (Exception e) {
                throw new DdlException("Port of Odbc table must be a number.Please set odbc_catalog_resource or add properties('port'='3306') when create table");
            }
            this.userName = properties.get(ODBC_USER);
            if (Strings.isNullOrEmpty((String)this.userName)) {
                throw new DdlException("User of Odbc table is null. Please set odbc_catalog_resource or add properties('user'='root') when create table");
            }
            this.passwd = properties.get(ODBC_PASSWORD);
            if (this.passwd == null) {
                throw new DdlException("Password of Odbc table is null. Please set odbc_catalog_resource or add properties('password'='xxxx') when create table");
            }
            this.driver = properties.get(ODBC_DRIVER);
            if (Strings.isNullOrEmpty((String)this.driver)) {
                throw new DdlException("Driver of Odbc table is null. Please set odbc_catalog_resource or add properties('diver'='xxxx') when create table");
            }
            String tableType = properties.get(ODBC_TYPE);
            if (Strings.isNullOrEmpty((String)tableType)) {
                throw new DdlException("Type of Odbc table is null. Please set odbc_catalog_resource or add properties('odbc_type'='xxxx') when create table");
            }
            this.odbcTableTypeName = tableType.toLowerCase();
            if (!TABLE_TYPE_MAP.containsKey(this.odbcTableTypeName)) {
                throw new DdlException("Invalid Odbc table type:" + tableType + " Now Odbc table type only support:" + OdbcTable.supportTableType());
            }
        }
        this.odbcDatabaseName = properties.get(ODBC_DATABASE);
        if (Strings.isNullOrEmpty((String)this.odbcDatabaseName)) {
            throw new DdlException("Database of Odbc table is null. Please add properties('database'='xxxx') when create table");
        }
        this.odbcTableName = properties.get(ODBC_TABLE);
        if (Strings.isNullOrEmpty((String)this.odbcTableName)) {
            throw new DdlException("Database of Odbc table is null. Please add properties('table'='xxxx') when create table");
        }
    }

    private String getPropertyFromResource(String propertyName) {
        OdbcCatalogResource odbcCatalogResource = (OdbcCatalogResource)Catalog.getCurrentCatalog().getResourceMgr().getResource(this.odbcCatalogResourceName);
        if (odbcCatalogResource == null) {
            throw new RuntimeException("Resource does not exist. name: " + this.odbcCatalogResourceName);
        }
        String property = odbcCatalogResource.getProperties(propertyName);
        if (property == null) {
            throw new RuntimeException("The property:" + propertyName + " do not set in resource " + this.odbcCatalogResourceName);
        }
        return property;
    }

    public String getOdbcCatalogResourceName() {
        return this.odbcCatalogResourceName;
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        return this.getPropertyFromResource(ODBC_HOST);
    }

    public String getPort() {
        if (this.port != null) {
            return this.port;
        }
        return this.getPropertyFromResource(ODBC_PORT);
    }

    public String getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        return this.getPropertyFromResource(ODBC_USER);
    }

    public String getPasswd() {
        if (this.passwd != null) {
            return this.passwd;
        }
        return this.getPropertyFromResource(ODBC_PASSWORD);
    }

    public String getOdbcDatabaseName() {
        return this.odbcDatabaseName;
    }

    public String getOdbcTableName() {
        return this.odbcTableName;
    }

    public String getOdbcDriver() {
        if (this.driver != null) {
            return this.driver;
        }
        return this.getPropertyFromResource(ODBC_DRIVER);
    }

    public String getOdbcTableTypeName() {
        if (this.odbcTableTypeName != null) {
            return this.odbcTableTypeName;
        }
        return this.getPropertyFromResource(ODBC_TYPE);
    }

    public String getConnectString() {
        String connectString = "";
        switch (this.getOdbcTableType()) {
            case ORACLE: {
                connectString = String.format("Driver=%s;Dbq=//%s:%s/%s;DataBase=%s;Uid=%s;Pwd=%s;charset=%s", this.getOdbcDriver(), this.getHost(), this.getPort(), this.getOdbcDatabaseName(), this.getOdbcDatabaseName(), this.getUserName(), this.getPasswd(), "utf8");
                break;
            }
            case POSTGRESQL: {
                connectString = String.format("Driver=%s;Server=%s;Port=%s;DataBase=%s;Uid=%s;Pwd=%s;charset=%s;UseDeclareFetch=1;Fetch=4096", this.getOdbcDriver(), this.getHost(), this.getPort(), this.getOdbcDatabaseName(), this.getUserName(), this.getPasswd(), "utf8");
                break;
            }
            case MYSQL: {
                connectString = String.format("Driver=%s;Server=%s;Port=%s;DataBase=%s;Uid=%s;Pwd=%s;charset=%s;forward_cursor=1;no_cache=1", this.getOdbcDriver(), this.getHost(), this.getPort(), this.getOdbcDatabaseName(), this.getUserName(), this.getPasswd(), "utf8");
                break;
            }
            case SQLSERVER: {
                connectString = String.format("Driver=%s;Server=%s,%s;DataBase=%s;Uid=%s;Pwd=%s", this.getOdbcDriver(), this.getHost(), this.getPort(), this.getOdbcDatabaseName(), this.getUserName(), this.getPasswd());
                break;
            }
        }
        return connectString;
    }

    public TOdbcTableType getOdbcTableType() {
        return TABLE_TYPE_MAP.get(this.getOdbcTableTypeName());
    }

    public OdbcTable clone() {
        OdbcTable copied = new OdbcTable();
        if (!DeepCopy.copy((Writable)this, (Writable)copied, OdbcTable.class, (int)FeConstants.meta_version)) {
            LOG.warn("failed to copy odbc table: " + this.getName());
            return null;
        }
        return copied;
    }

    public void resetIdsForRestore(Catalog catalog) {
        this.id = catalog.getNextId();
    }

    @Override
    public TTableDescriptor toThrift() {
        TOdbcTable tOdbcTable = new TOdbcTable();
        tOdbcTable.setHost(this.getHost());
        tOdbcTable.setPort(this.getPort());
        tOdbcTable.setUser(this.getUserName());
        tOdbcTable.setPasswd(this.getPasswd());
        tOdbcTable.setDb(this.getOdbcDatabaseName());
        tOdbcTable.setTable(this.getOdbcTableName());
        tOdbcTable.setDriver(this.getOdbcDriver());
        tOdbcTable.setType(this.getOdbcTableType());
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.ODBC_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setOdbcTable(tOdbcTable);
        return tTableDescriptor;
    }

    @Override
    public String getSignature(int signatureVersion) {
        StringBuilder sb = new StringBuilder(signatureVersion);
        sb.append(this.name);
        sb.append((Object)this.type);
        if (this.odbcCatalogResourceName != null) {
            sb.append(this.odbcCatalogResourceName);
            sb.append(this.odbcDatabaseName);
            sb.append(this.odbcTableName);
        } else {
            sb.append(this.host);
            sb.append(this.port);
            sb.append(this.userName);
            sb.append(this.passwd);
            sb.append(this.driver);
            sb.append(this.odbcTableTypeName);
        }
        String md5 = DigestUtils.md5Hex((String)sb.toString());
        LOG.debug("get signature of odbc table {}: {}. signature string: {}", (Object)this.name, (Object)md5, (Object)sb.toString());
        return md5;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        HashMap serializeMap = Maps.newHashMap();
        serializeMap.put(ODBC_CATALOG_RESOURCE, this.odbcCatalogResourceName);
        serializeMap.put(ODBC_HOST, this.host);
        serializeMap.put(ODBC_PORT, this.port);
        serializeMap.put(ODBC_USER, this.userName);
        serializeMap.put(ODBC_PASSWORD, this.passwd);
        serializeMap.put(ODBC_DATABASE, this.odbcDatabaseName);
        serializeMap.put(ODBC_TABLE, this.odbcTableName);
        serializeMap.put(ODBC_DRIVER, this.driver);
        serializeMap.put(ODBC_TYPE, this.odbcTableTypeName);
        int size = (int)serializeMap.values().stream().filter(v -> v != null).count();
        out.writeInt(size);
        for (Map.Entry kv : serializeMap.entrySet()) {
            if (kv.getValue() == null) continue;
            Text.writeString((DataOutput)out, (String)((String)kv.getKey()));
            Text.writeString((DataOutput)out, (String)((String)kv.getValue()));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        HashMap serializeMap = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            serializeMap.put(key, value);
        }
        this.odbcCatalogResourceName = (String)serializeMap.get(ODBC_CATALOG_RESOURCE);
        this.host = (String)serializeMap.get(ODBC_HOST);
        this.port = (String)serializeMap.get(ODBC_PORT);
        this.userName = (String)serializeMap.get(ODBC_USER);
        this.passwd = (String)serializeMap.get(ODBC_PASSWORD);
        this.odbcDatabaseName = (String)serializeMap.get(ODBC_DATABASE);
        this.odbcTableName = (String)serializeMap.get(ODBC_TABLE);
        this.driver = (String)serializeMap.get(ODBC_DRIVER);
        this.odbcTableTypeName = (String)serializeMap.get(ODBC_TYPE);
    }

    public static String supportTableType() {
        String supportTable = "";
        for (String table : TABLE_TYPE_MAP.keySet()) {
            supportTable = supportTable + table + " ";
        }
        return supportTable;
    }

    static {
        HashMap<String, TOdbcTableType> tempMap = new HashMap<String, TOdbcTableType>();
        tempMap.put("oracle", TOdbcTableType.ORACLE);
        tempMap.put("mysql", TOdbcTableType.MYSQL);
        tempMap.put("postgresql", TOdbcTableType.POSTGRESQL);
        tempMap.put("sqlserver", TOdbcTableType.SQLSERVER);
        TABLE_TYPE_MAP = Collections.unmodifiableMap(tempMap);
    }
}

