/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.doris.catalog.Resource;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OdbcCatalogResource
extends Resource {
    private static final Logger LOG = LogManager.getLogger(OdbcCatalogResource.class);
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String TYPE = "odbc_type";
    private static final String DRIVER = "driver";
    @SerializedName(value="configs")
    private Map<String, String> configs;

    public OdbcCatalogResource() {
    }

    public OdbcCatalogResource(String name) {
        this(name, Maps.newHashMap());
    }

    private OdbcCatalogResource(String name, Map<String, String> configs) {
        super(name, Resource.ResourceType.ODBC_CATALOG);
        this.configs = configs;
    }

    public OdbcCatalogResource getCopiedResource() {
        return new OdbcCatalogResource(this.name, Maps.newHashMap(this.configs));
    }

    private void checkProperties(String propertiesKey) throws DdlException {
        String value = this.configs.get(propertiesKey);
        if (value == null) {
            throw new DdlException("Missing " + propertiesKey + " in properties");
        }
    }

    public String getProperties(String propertiesKey) {
        String value = this.configs.get(propertiesKey);
        return value;
    }

    public int getSignature(int signatureVersion) {
        Adler32 adler32 = new Adler32();
        adler32.update(signatureVersion);
        String charsetName = "UTF-8";
        try {
            adler32.update(this.name.getBytes("UTF-8"));
            LOG.debug("signature. view name: {}", (Object)this.name);
            adler32.update(this.type.name().getBytes("UTF-8"));
            LOG.debug("signature. view type: {}", (Object)this.type.name());
            for (Map.Entry<String, String> config : this.configs.entrySet()) {
                adler32.update(config.getKey().getBytes("UTF-8"));
                adler32.update(config.getValue().getBytes("UTF-8"));
                LOG.debug("signature. view config: {}", config);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("encoding error", (Throwable)e);
            return -1;
        }
        LOG.debug("signature: {}", (Object)Math.abs((int)adler32.getValue()));
        return Math.abs((int)adler32.getValue());
    }

    @Override
    protected void setProperties(Map<String, String> properties) throws DdlException {
        Preconditions.checkState((properties != null ? 1 : 0) != 0);
        this.configs = properties;
        this.checkProperties(HOST);
        this.checkProperties(PORT);
        this.checkProperties(USER);
        this.checkProperties(PASSWORD);
    }

    @Override
    protected void getProcNodeData(BaseProcResult result) {
        String lowerCaseType = this.type.name().toLowerCase();
        for (Map.Entry<String, String> entry : this.configs.entrySet()) {
            if (entry.getKey().equals(PASSWORD)) {
                result.addRow(Lists.newArrayList((Object[])new String[]{this.name, lowerCaseType, entry.getKey(), ""}));
                continue;
            }
            result.addRow(Lists.newArrayList((Object[])new String[]{this.name, lowerCaseType, entry.getKey(), entry.getValue()}));
        }
    }
}

