/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OdbcCatalogResource;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TMySQLTable;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlTable
extends Table {
    private static final Logger LOG = LogManager.getLogger(OlapTable.class);
    private static final String ODBC_CATALOG_RESOURCE = "odbc_catalog_resource";
    private static final String MYSQL_HOST = "host";
    private static final String MYSQL_PORT = "port";
    private static final String MYSQL_USER = "user";
    private static final String MYSQL_PASSWORD = "password";
    private static final String MYSQL_DATABASE = "database";
    private static final String MYSQL_TABLE = "table";
    private String odbcCatalogResourceName;
    private String host;
    private String port;
    private String userName;
    private String passwd;
    private String mysqlDatabaseName;
    private String mysqlTableName;

    public MysqlTable() {
        super(Table.TableType.MYSQL);
    }

    public MysqlTable(long id, String name, List<Column> schema, Map<String, String> properties) throws DdlException {
        super(id, name, Table.TableType.MYSQL, schema);
        this.validate(properties);
    }

    private void validate(Map<String, String> properties) throws DdlException {
        if (properties == null) {
            throw new DdlException("Please set properties of mysql table, they are: odbc_catalog_resource or [host, port, user, password] and database and table");
        }
        if (properties.containsKey(ODBC_CATALOG_RESOURCE)) {
            this.odbcCatalogResourceName = properties.get(ODBC_CATALOG_RESOURCE);
            Resource oriResource = Catalog.getCurrentCatalog().getResourceMgr().getResource(this.odbcCatalogResourceName);
            if (oriResource == null) {
                throw new DdlException("Resource does not exist. name: " + this.odbcCatalogResourceName);
            }
            if (!Catalog.getCurrentCatalog().getAuth().checkResourcePriv(ConnectContext.get(), this.odbcCatalogResourceName, PrivPredicate.USAGE)) {
                throw new DdlException("USAGE denied to user '" + ConnectContext.get().getQualifiedUser() + "'@'" + ConnectContext.get().getRemoteIP() + "' for resource '" + this.odbcCatalogResourceName + "'");
            }
        } else {
            this.host = properties.get(MYSQL_HOST);
            if (Strings.isNullOrEmpty((String)this.host)) {
                throw new DdlException("Host of MySQL table is null. Please set proper resource or add properties('host'='xxx.xxx.xxx.xxx') when create table");
            }
            this.port = properties.get(MYSQL_PORT);
            if (Strings.isNullOrEmpty((String)this.port)) {
                throw new DdlException("Port of MySQL table is null. Please set proper resource or add properties('port'='3306') when create table");
            }
            try {
                Integer.valueOf(this.port);
            }
            catch (Exception e) {
                throw new DdlException("Port of MySQL table must be a number.Please set proper resource or add properties('port'='3306') when create table");
            }
            this.userName = properties.get(MYSQL_USER);
            if (Strings.isNullOrEmpty((String)this.userName)) {
                throw new DdlException("User of MySQL table is null. Please set proper resource or add properties('user'='root') when create table");
            }
            this.passwd = properties.get(MYSQL_PASSWORD);
            if (this.passwd == null) {
                throw new DdlException("Password of MySQL table is null. Please set proper resource or add properties('password'='xxxx') when create table");
            }
        }
        this.mysqlDatabaseName = properties.get(MYSQL_DATABASE);
        if (Strings.isNullOrEmpty((String)this.mysqlDatabaseName)) {
            throw new DdlException("Database of MySQL table is null. Please add properties('database'='xxxx') when create table");
        }
        this.mysqlTableName = properties.get(MYSQL_TABLE);
        if (Strings.isNullOrEmpty((String)this.mysqlTableName)) {
            throw new DdlException("Database of MySQL table is null. Please add properties('table'='xxxx') when create table");
        }
    }

    private String getPropertyFromResource(String propertyName) {
        OdbcCatalogResource odbcCatalogResource = (OdbcCatalogResource)Catalog.getCurrentCatalog().getResourceMgr().getResource(this.odbcCatalogResourceName);
        if (odbcCatalogResource == null) {
            throw new RuntimeException("Resource does not exist. name: " + this.odbcCatalogResourceName);
        }
        String property = odbcCatalogResource.getProperties(propertyName);
        if (property == null) {
            throw new RuntimeException("The property:" + propertyName + " do not set in resource " + this.odbcCatalogResourceName);
        }
        return property;
    }

    public String getOdbcCatalogResourceName() {
        return this.odbcCatalogResourceName;
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        return this.getPropertyFromResource(MYSQL_HOST);
    }

    public String getPort() {
        if (this.port != null) {
            return this.port;
        }
        return this.getPropertyFromResource(MYSQL_PORT);
    }

    public String getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        return this.getPropertyFromResource(MYSQL_USER);
    }

    public String getPasswd() {
        if (this.passwd != null) {
            return this.passwd;
        }
        return this.getPropertyFromResource(MYSQL_PASSWORD);
    }

    public String getMysqlDatabaseName() {
        return this.mysqlDatabaseName;
    }

    public String getMysqlTableName() {
        return this.mysqlTableName;
    }

    @Override
    public TTableDescriptor toThrift() {
        TMySQLTable tMySQLTable = new TMySQLTable(this.getHost(), this.getPort(), this.getUserName(), this.getPasswd(), this.mysqlDatabaseName, this.mysqlTableName);
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.MYSQL_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setMysqlTable(tMySQLTable);
        return tTableDescriptor;
    }

    @Override
    public String getSignature(int signatureVersion) {
        StringBuilder sb = new StringBuilder(signatureVersion);
        sb.append(this.name);
        sb.append(this.type.name());
        sb.append(this.getHost());
        sb.append(this.getPort());
        sb.append(this.getUserName());
        sb.append(this.getPasswd());
        sb.append(this.mysqlDatabaseName);
        sb.append(this.mysqlTableName);
        String md5 = DigestUtils.md5Hex((String)sb.toString());
        LOG.debug("get signature of mysql table {}: {}. signature string: {}", (Object)this.name, (Object)md5, (Object)sb.toString());
        return md5;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        HashMap serializeMap = Maps.newHashMap();
        serializeMap.put(ODBC_CATALOG_RESOURCE, this.odbcCatalogResourceName);
        serializeMap.put(MYSQL_HOST, this.host);
        serializeMap.put(MYSQL_PORT, this.port);
        serializeMap.put(MYSQL_USER, this.userName);
        serializeMap.put(MYSQL_PASSWORD, this.passwd);
        serializeMap.put(MYSQL_DATABASE, this.mysqlDatabaseName);
        serializeMap.put(MYSQL_TABLE, this.mysqlTableName);
        int size = (int)serializeMap.values().stream().filter(v -> v != null).count();
        out.writeInt(size);
        for (Map.Entry kv : serializeMap.entrySet()) {
            if (kv.getValue() == null) continue;
            Text.writeString((DataOutput)out, (String)((String)kv.getKey()));
            Text.writeString((DataOutput)out, (String)((String)kv.getValue()));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        HashMap serializeMap = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            serializeMap.put(key, value);
        }
        this.odbcCatalogResourceName = (String)serializeMap.get(ODBC_CATALOG_RESOURCE);
        this.host = (String)serializeMap.get(MYSQL_HOST);
        this.port = (String)serializeMap.get(MYSQL_PORT);
        this.userName = (String)serializeMap.get(MYSQL_USER);
        this.passwd = (String)serializeMap.get(MYSQL_PASSWORD);
        this.mysqlDatabaseName = (String)serializeMap.get(MYSQL_DATABASE);
        this.mysqlTableName = (String)serializeMap.get(MYSQL_TABLE);
    }
}

