/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.analysis.AdminShowReplicaDistributionStmt;
import org.apache.doris.analysis.AdminShowReplicaStatusStmt;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.ShowDataSkewStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;

public class MetadataViewer {
    public static List<List<String>> getTabletStatus(AdminShowReplicaStatusStmt stmt) throws DdlException {
        return MetadataViewer.getTabletStatus(stmt.getDbName(), stmt.getTblName(), stmt.getPartitions(), stmt.getStatusFilter(), stmt.getOp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<String>> getTabletStatus(String dbName, String tblName, List<String> partitions, Replica.ReplicaStatus statusFilter, BinaryPredicate.Operator op) throws DdlException {
        ArrayList result = Lists.newArrayList();
        Catalog catalog = Catalog.getCurrentCatalog();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        Database db = catalog.getDbOrDdlException(dbName);
        OlapTable olapTable = db.getOlapTableOrDdlException(tblName);
        olapTable.readLock();
        try {
            Partition partition;
            if (partitions.isEmpty()) {
                partitions.addAll(olapTable.getPartitionNames());
            } else {
                for (String partName : partitions) {
                    partition = olapTable.getPartition(partName);
                    if (partition != null) continue;
                    throw new DdlException("Partition does not exist: " + partName);
                }
            }
            for (String partName : partitions) {
                partition = olapTable.getPartition(partName);
                long visibleVersion = partition.getVisibleVersion();
                int replicationNum = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum();
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                    int schemaHash = olapTable.getSchemaHashByIndexId(index.getId());
                    for (Tablet tablet : index.getTablets()) {
                        long tabletId = tablet.getId();
                        int count = replicationNum;
                        for (Replica replica : tablet.getReplicas()) {
                            --count;
                            ArrayList row = Lists.newArrayList();
                            Replica.ReplicaStatus status = Replica.ReplicaStatus.OK;
                            Backend be = infoService.getBackend(replica.getBackendId());
                            if (be == null || !be.isAlive() || replica.isBad()) {
                                status = Replica.ReplicaStatus.DEAD;
                            } else if (replica.getVersion() < visibleVersion || replica.getLastFailedVersion() > 0L) {
                                status = Replica.ReplicaStatus.VERSION_ERROR;
                            } else if (replica.getSchemaHash() != -1 && replica.getSchemaHash() != schemaHash) {
                                status = Replica.ReplicaStatus.SCHEMA_ERROR;
                            }
                            if (MetadataViewer.filterReplica(status, statusFilter, op)) continue;
                            row.add(String.valueOf(tabletId));
                            row.add(String.valueOf(replica.getId()));
                            row.add(String.valueOf(replica.getBackendId()));
                            row.add(String.valueOf(replica.getVersion()));
                            row.add(String.valueOf(replica.getLastFailedVersion()));
                            row.add(String.valueOf(replica.getLastSuccessVersion()));
                            row.add(String.valueOf(visibleVersion));
                            row.add(String.valueOf(replica.getSchemaHash()));
                            row.add(String.valueOf(replica.getVersionCount()));
                            row.add(String.valueOf(replica.isBad()));
                            row.add(replica.getState().name());
                            row.add(status.name());
                            result.add(row);
                        }
                        if (MetadataViewer.filterReplica(Replica.ReplicaStatus.MISSING, statusFilter, op)) continue;
                        for (int i = 0; i < count; ++i) {
                            ArrayList row = Lists.newArrayList();
                            row.add(String.valueOf(tabletId));
                            row.add("-1");
                            row.add("-1");
                            row.add("-1");
                            row.add("-1");
                            row.add("-1");
                            row.add("-1");
                            row.add("-1");
                            row.add(FeConstants.null_string);
                            row.add(FeConstants.null_string);
                            row.add(Replica.ReplicaStatus.MISSING.name());
                            result.add(row);
                        }
                    }
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        return result;
    }

    private static boolean filterReplica(Replica.ReplicaStatus status, Replica.ReplicaStatus statusFilter, BinaryPredicate.Operator op) {
        if (statusFilter == null) {
            return false;
        }
        if (op == BinaryPredicate.Operator.EQ) {
            return status != statusFilter;
        }
        return status == statusFilter;
    }

    public static List<List<String>> getTabletDistribution(AdminShowReplicaDistributionStmt stmt) throws DdlException {
        return MetadataViewer.getTabletDistribution(stmt.getDbName(), stmt.getTblName(), stmt.getPartitionNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<String>> getTabletDistribution(String dbName, String tblName, PartitionNames partitionNames) throws DdlException {
        DecimalFormat df = new DecimalFormat("00.00 %");
        ArrayList result = Lists.newArrayList();
        Catalog catalog = Catalog.getCurrentCatalog();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        Database db = catalog.getDbOrDdlException(dbName);
        OlapTable olapTable = db.getOlapTableOrDdlException(tblName);
        olapTable.readLock();
        try {
            ArrayList partitionIds = Lists.newArrayList();
            if (partitionNames == null) {
                for (Partition partition : olapTable.getPartitions()) {
                    partitionIds.add(partition.getId());
                }
            } else {
                for (String partName : partitionNames.getPartitionNames()) {
                    Partition partition = olapTable.getPartition(partName, partitionNames.isTemp());
                    if (partition == null) {
                        throw new DdlException("Partition does not exist: " + partName);
                    }
                    partitionIds.add(partition.getId());
                }
            }
            HashMap countMap = Maps.newHashMap();
            HashMap sizeMap = Maps.newHashMap();
            List<Long> beIds = infoService.getBackendIds(false);
            for (long beId : beIds) {
                countMap.put(beId, 0);
                sizeMap.put(beId, 0L);
            }
            int totalReplicaNum = 0;
            long totalReplicaSize = 0L;
            Iterator<Object> iterator = partitionIds.iterator();
            while (iterator.hasNext()) {
                long partId = (Long)iterator.next();
                Partition partition = olapTable.getPartition(partId);
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                    for (Tablet tablet : index.getTablets()) {
                        for (Replica replica : tablet.getReplicas()) {
                            if (!countMap.containsKey(replica.getBackendId())) continue;
                            countMap.put(replica.getBackendId(), (Integer)countMap.get(replica.getBackendId()) + 1);
                            sizeMap.put(replica.getBackendId(), (Long)sizeMap.get(replica.getBackendId()) + replica.getDataSize());
                            ++totalReplicaNum;
                            totalReplicaSize += replica.getDataSize();
                        }
                    }
                }
            }
            Collections.sort(beIds);
            for (Long beId : beIds) {
                ArrayList row = Lists.newArrayList();
                row.add(String.valueOf(beId));
                row.add(String.valueOf(countMap.get(beId)));
                row.add(String.valueOf(sizeMap.get(beId)));
                row.add(MetadataViewer.graph(((Integer)countMap.get(beId)).intValue(), totalReplicaNum));
                row.add(totalReplicaNum == (Integer)countMap.get(beId) ? "100.00%" : df.format((double)((Integer)countMap.get(beId)).intValue() / (double)totalReplicaNum));
                row.add(MetadataViewer.graph((Long)sizeMap.get(beId), totalReplicaSize));
                row.add(totalReplicaSize == (Long)sizeMap.get(beId) ? "100.00%" : df.format((double)((Long)sizeMap.get(beId)).longValue() / (double)totalReplicaSize));
                result.add(row);
            }
        }
        finally {
            olapTable.readUnlock();
        }
        return result;
    }

    private static String graph(long num, long totalNum) {
        StringBuilder sb = new StringBuilder();
        long normalized = num == totalNum ? 100L : (long)((int)Math.ceil(num * 100L / totalNum));
        int i = 0;
        while ((long)i < normalized) {
            sb.append(">");
            ++i;
        }
        return sb.toString();
    }

    public static List<List<String>> getDataSkew(ShowDataSkewStmt stmt) throws DdlException {
        return MetadataViewer.getDataSkew(stmt.getDbName(), stmt.getTblName(), stmt.getPartitionNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<String>> getDataSkew(String dbName, String tblName, PartitionNames partitionNames) throws DdlException {
        DecimalFormat df = new DecimalFormat("00.00 %");
        ArrayList result = Lists.newArrayList();
        Catalog catalog = Catalog.getCurrentCatalog();
        if (partitionNames == null || partitionNames.getPartitionNames().size() != 1) {
            throw new DdlException("Should specify one and only one partitions");
        }
        Database db = catalog.getDbOrDdlException(dbName);
        OlapTable olapTable = db.getOlapTableOrDdlException(tblName);
        olapTable.readLock();
        try {
            String partName;
            Partition partition = null;
            Iterator<String> iterator = partitionNames.getPartitionNames().iterator();
            if (iterator.hasNext() && (partition = olapTable.getPartition(partName = iterator.next(), partitionNames.isTemp())) == null) {
                throw new DdlException("Partition does not exist: " + partName);
            }
            DistributionInfo distributionInfo = partition.getDistributionInfo();
            ArrayList tabletInfos = Lists.newArrayListWithCapacity((int)distributionInfo.getBucketNum());
            for (long i = 0L; i < (long)distributionInfo.getBucketNum(); ++i) {
                tabletInfos.add(0L);
            }
            long totalSize = 0L;
            for (MaterializedIndex mIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                List<Long> tabletIds = mIndex.getTabletIdsInOrder();
                for (int i = 0; i < tabletIds.size(); ++i) {
                    Tablet tablet = mIndex.getTablet(tabletIds.get(i));
                    long dataSize = tablet.getDataSize(true);
                    tabletInfos.set(i, (Long)tabletInfos.get(i) + dataSize);
                    totalSize += dataSize;
                }
            }
            for (int i = 0; i < tabletInfos.size(); ++i) {
                ArrayList row = Lists.newArrayList();
                row.add(String.valueOf(i));
                row.add(((Long)tabletInfos.get(i)).toString());
                row.add(MetadataViewer.graph((Long)tabletInfos.get(i), totalSize));
                row.add(totalSize == (Long)tabletInfos.get(i) ? "100.00%" : df.format((double)((Long)tabletInfos.get(i)).longValue() / (double)totalSize));
                result.add(row);
            }
        }
        finally {
            olapTable.readUnlock();
        }
        return result;
    }
}

