/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class MetaReplayState {
    public MetaState state = MetaState.UNKNOWN;
    public long delayTime = -1L;
    public Throwable throwable = null;

    public synchronized void setOk() {
        this.state = MetaState.OK;
        this.delayTime = -1L;
        this.throwable = null;
    }

    public synchronized void setException(Throwable throwable) {
        this.throwable = throwable;
        this.state = MetaState.REPLAY_EXCEPTION;
    }

    public synchronized void setOutOfDate(long currentTime, long synchronizedTime) {
        this.delayTime = currentTime - synchronizedTime;
        this.state = MetaState.OUT_OF_DATE;
    }

    public synchronized void setTransferToUnknown() {
        this.state = MetaState.UNKNOWN;
    }

    public synchronized Map<String, String> getInfo() {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("state", this.state.name());
        resultMap.put("delay_time_s", String.valueOf(this.delayTime / 1000L));
        resultMap.put("exception", this.throwable == null ? "NULL" : this.throwable.getMessage());
        return resultMap;
    }

    public static enum MetaState {
        UNKNOWN,
        OK,
        OUT_OF_DATE,
        REPLAY_EXCEPTION;

    }
}

