/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.persist.gson.GsonPostProcessable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.thrift.TStorageType;

public class MaterializedIndexMeta
implements Writable,
GsonPostProcessable {
    @SerializedName(value="indexId")
    private long indexId;
    @SerializedName(value="schema")
    private List<Column> schema = Lists.newArrayList();
    @SerializedName(value="schemaVersion")
    private int schemaVersion;
    @SerializedName(value="schemaHash")
    private int schemaHash;
    @SerializedName(value="shortKeyColumnCount")
    private short shortKeyColumnCount;
    @SerializedName(value="storageType")
    private TStorageType storageType;
    @SerializedName(value="keysType")
    private KeysType keysType;
    @SerializedName(value="defineStmt")
    private OriginStatement defineStmt;

    public MaterializedIndexMeta(long indexId, List<Column> schema, int schemaVersion, int schemaHash, short shortKeyColumnCount, TStorageType storageType, KeysType keysType, OriginStatement defineStmt) {
        this.indexId = indexId;
        Preconditions.checkState((schema != null ? 1 : 0) != 0);
        Preconditions.checkState((schema.size() != 0 ? 1 : 0) != 0);
        this.schema = schema;
        this.schemaVersion = schemaVersion;
        this.schemaHash = schemaHash;
        this.shortKeyColumnCount = shortKeyColumnCount;
        Preconditions.checkState((storageType != null ? 1 : 0) != 0);
        this.storageType = storageType;
        Preconditions.checkState((keysType != null ? 1 : 0) != 0);
        this.keysType = keysType;
        this.defineStmt = defineStmt;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public KeysType getKeysType() {
        return this.keysType;
    }

    public void setKeysType(KeysType keysType) {
        this.keysType = keysType;
    }

    public TStorageType getStorageType() {
        return this.storageType;
    }

    public List<Column> getSchema() {
        return this.getSchema(true);
    }

    public List<Column> getSchema(boolean full) {
        if (full) {
            return this.schema;
        }
        return this.schema.stream().filter(column -> column.isVisible()).collect(Collectors.toList());
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public short getShortKeyColumnCount() {
        return this.shortKeyColumnCount;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    private void setColumnsDefineExpr(Map<String, Expr> columnNameToDefineExpr) {
        block0: for (Map.Entry<String, Expr> entry : columnNameToDefineExpr.entrySet()) {
            for (Column column : this.schema) {
                if (!column.getName().equals(entry.getKey())) continue;
                column.setDefineExpr(entry.getValue());
                continue block0;
            }
        }
    }

    public Column getColumnByName(String columnName) {
        for (Column column : this.schema) {
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MaterializedIndexMeta)) {
            return false;
        }
        MaterializedIndexMeta indexMeta = (MaterializedIndexMeta)obj;
        if (indexMeta.indexId != this.indexId) {
            return false;
        }
        if (indexMeta.schema.size() != this.schema.size() || !indexMeta.schema.containsAll(this.schema)) {
            return false;
        }
        if (indexMeta.schemaVersion != this.schemaVersion) {
            return false;
        }
        if (indexMeta.schemaHash != this.schemaHash) {
            return false;
        }
        if (indexMeta.shortKeyColumnCount != this.shortKeyColumnCount) {
            return false;
        }
        if (indexMeta.storageType != this.storageType) {
            return false;
        }
        return indexMeta.keysType == this.keysType;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static MaterializedIndexMeta read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (MaterializedIndexMeta)GsonUtils.GSON.fromJson(json, MaterializedIndexMeta.class);
    }

    @Override
    public void gsonPostProcess() throws IOException {
        if (this.defineStmt == null) {
            return;
        }
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(this.defineStmt.originStmt), (Long)0L));
        try {
            CreateMaterializedViewStmt stmt = (CreateMaterializedViewStmt)SqlParserUtils.getStmt(parser, this.defineStmt.idx);
            stmt.setIsReplay(true);
            Map<String, Expr> columnNameToDefineExpr = stmt.parseDefineExprWithoutAnalyze();
            this.setColumnsDefineExpr(columnNameToDefineExpr);
        }
        catch (Exception e) {
            throw new IOException("error happens when parsing create materialized view stmt: " + this.defineStmt, e);
        }
    }
}

