/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.MetaObject;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonPostProcessable;

public class MaterializedIndex
extends MetaObject
implements Writable,
GsonPostProcessable {
    @SerializedName(value="id")
    private long id;
    @SerializedName(value="state")
    private IndexState state;
    @SerializedName(value="rowCount")
    private long rowCount;
    private Map<Long, Tablet> idToTablets;
    @SerializedName(value="tablets")
    private List<Tablet> tablets;
    @SerializedName(value="rollupIndexId")
    private long rollupIndexId;
    @SerializedName(value="rollupFinishedVersion")
    private long rollupFinishedVersion;

    public MaterializedIndex() {
        this.state = IndexState.NORMAL;
        this.idToTablets = new HashMap<Long, Tablet>();
        this.tablets = new ArrayList<Tablet>();
    }

    public MaterializedIndex(long id, IndexState state) {
        this.id = id;
        this.state = state;
        if (this.state == null) {
            this.state = IndexState.NORMAL;
        }
        this.idToTablets = new HashMap<Long, Tablet>();
        this.tablets = new ArrayList<Tablet>();
        this.rowCount = 0L;
        this.rollupIndexId = -1L;
        this.rollupFinishedVersion = -1L;
    }

    public List<Tablet> getTablets() {
        return this.tablets;
    }

    public List<Long> getTabletIdsInOrder() {
        ArrayList tabletIds = Lists.newArrayList();
        for (Tablet tablet : this.tablets) {
            tabletIds.add(tablet.getId());
        }
        return tabletIds;
    }

    public Tablet getTablet(long tabletId) {
        return this.idToTablets.get(tabletId);
    }

    public void clearTabletsForRestore() {
        this.idToTablets.clear();
        this.tablets.clear();
    }

    public void addTablet(Tablet tablet, TabletMeta tabletMeta) {
        this.addTablet(tablet, tabletMeta, false);
    }

    public void addTablet(Tablet tablet, TabletMeta tabletMeta, boolean isRestore) {
        this.idToTablets.put(tablet.getId(), tablet);
        this.tablets.add(tablet);
        if (!isRestore) {
            Catalog.getCurrentInvertedIndex().addTablet(tablet.getId(), tabletMeta);
        }
    }

    public void setIdForRestore(long idxId) {
        this.id = idxId;
    }

    public long getId() {
        return this.id;
    }

    public void setState(IndexState state) {
        this.state = state;
    }

    public IndexState getState() {
        return this.state;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public void setRollupIndexInfo(long rollupIndexId, long rollupFinishedVersion) {
        this.rollupIndexId = rollupIndexId;
        this.rollupFinishedVersion = rollupFinishedVersion;
    }

    public long getRollupIndexId() {
        return this.rollupIndexId;
    }

    public long getRollupFinishedVersion() {
        return this.rollupFinishedVersion;
    }

    public void clearRollupIndexInfo() {
        this.rollupIndexId = -1L;
        this.rollupFinishedVersion = -1L;
    }

    public long getDataSize() {
        long dataSize = 0L;
        for (Tablet tablet : this.getTablets()) {
            dataSize += tablet.getDataSize(false);
        }
        return dataSize;
    }

    public long getReplicaCount() {
        long replicaCount = 0L;
        for (Tablet tablet : this.getTablets()) {
            replicaCount += (long)tablet.getReplicas().size();
        }
        return replicaCount;
    }

    public int getTabletOrderIdx(long tabletId) {
        int idx = 0;
        for (Tablet tablet : this.tablets) {
            if (tablet.getId() == tabletId) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.id);
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeLong(this.rowCount);
        int tabletCount = this.tablets.size();
        out.writeInt(tabletCount);
        for (Tablet tablet : this.tablets) {
            tablet.write(out);
        }
        out.writeLong(this.rollupIndexId);
        out.writeLong(this.rollupFinishedVersion);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.id = in.readLong();
        this.state = IndexState.valueOf(Text.readString((DataInput)in));
        this.rowCount = in.readLong();
        int tabletCount = in.readInt();
        for (int i = 0; i < tabletCount; ++i) {
            Tablet tablet = Tablet.read(in);
            this.tablets.add(tablet);
            this.idToTablets.put(tablet.getId(), tablet);
        }
        this.rollupIndexId = in.readLong();
        this.rollupFinishedVersion = in.readLong();
    }

    public static MaterializedIndex read(DataInput in) throws IOException {
        MaterializedIndex materializedIndex = new MaterializedIndex();
        materializedIndex.readFields(in);
        return materializedIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MaterializedIndex)) {
            return false;
        }
        MaterializedIndex table = (MaterializedIndex)obj;
        if (table.idToTablets == null) {
            return false;
        }
        if (this.idToTablets.size() != table.idToTablets.size()) {
            return false;
        }
        for (Map.Entry<Long, Tablet> entry : this.idToTablets.entrySet()) {
            long key = entry.getKey();
            if (!table.idToTablets.containsKey(key)) {
                return false;
            }
            if (entry.getValue().equals(table.idToTablets.get(key))) continue;
            return false;
        }
        return this.state.equals((Object)table.state) && this.rowCount == table.rowCount;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("index id: ").append(this.id).append("; ");
        buffer.append("index state: ").append(this.state.name()).append("; ");
        buffer.append("row count: ").append(this.rowCount).append("; ");
        buffer.append("tablets size: ").append(this.tablets.size()).append("; ");
        buffer.append("tablets: [");
        for (Tablet tablet : this.tablets) {
            buffer.append("tablet: ").append(tablet.toString()).append(", ");
        }
        buffer.append("]; ");
        buffer.append("rollup index id: ").append(this.rollupIndexId).append("; ");
        buffer.append("rollup finished version: ").append(this.rollupFinishedVersion).append("; ");
        return buffer.toString();
    }

    @Override
    public void gsonPostProcess() {
        for (Tablet tablet : this.tablets) {
            this.idToTablets.put(tablet.getId(), tablet);
        }
    }

    public static enum IndexExtState {
        ALL,
        VISIBLE,
        SHADOW;

    }

    public static enum IndexState {
        NORMAL,
        ROLLUP,
        SCHEMA_CHANGE,
        SHADOW;


        public boolean isVisible() {
            return this == NORMAL;
        }
    }
}

