/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.clearspring.analytics.util.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;

public class ListPartitionItem
extends PartitionItem {
    private List<PartitionKey> partitionKeys;
    public static ListPartitionItem DUMMY_ITEM = new ListPartitionItem(Lists.newArrayList());

    public ListPartitionItem(List<PartitionKey> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public List<PartitionKey> getItems() {
        return this.partitionKeys;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.partitionKeys.size());
        for (PartitionKey partitionKey : this.partitionKeys) {
            partitionKey.write(out);
        }
    }

    public static ListPartitionItem read(DataInput input) throws IOException {
        int counter = input.readInt();
        ArrayList<PartitionKey> partitionKeys = new ArrayList<PartitionKey>();
        for (int i = 0; i < counter; ++i) {
            PartitionKey partitionKey = PartitionKey.read(input);
            partitionKeys.add(partitionKey);
        }
        return new ListPartitionItem(partitionKeys);
    }

    @Override
    public int compareTo(PartitionItem other) {
        int thisKeyLen = this.partitionKeys.size();
        int otherKeyLen = ((ListPartitionItem)other).getItems().size();
        int minLen = Math.min(thisKeyLen, otherKeyLen);
        for (int i = 0; i < minLen; ++i) {
            int ret = ((PartitionKey)this.getItems().get(i)).compareTo((PartitionKey)((ListPartitionItem)other).getItems().get(i));
            if (0 == ret) continue;
            return ret;
        }
        return Integer.compare(thisKeyLen, otherKeyLen);
    }

    @Override
    public PartitionItem getIntersect(PartitionItem newItem) {
        List newKeys = (List)newItem.getItems();
        for (PartitionKey newKey : newKeys) {
            if (!this.partitionKeys.contains(newKey)) continue;
            return newItem;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ListPartitionItem)) {
            return false;
        }
        ListPartitionItem partitionItem = (ListPartitionItem)obj;
        if (this.partitionKeys != partitionItem.getItems()) {
            if (this.partitionKeys.size() != partitionItem.getItems().size()) {
                return false;
            }
            for (int i = 0; i < this.partitionKeys.size(); ++i) {
                if (this.partitionKeys.get(i).equals(partitionItem.getItems().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.partitionKeys.size();
        for (PartitionKey partitionKey : this.partitionKeys) {
            result = 31 * result + partitionKey.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("partitionKeys: [");
        for (PartitionKey partitionKey : this.partitionKeys) {
            builder.append(partitionKey.toString());
        }
        builder.append("]; ");
        return builder.toString();
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        int size = this.partitionKeys.size();
        if (size > 1) {
            sb.append("(");
        }
        int i = 0;
        for (PartitionKey partitionKey : this.partitionKeys) {
            sb.append(partitionKey.toSql());
            if (i < this.partitionKeys.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        if (size > 1) {
            sb.append(")");
        }
        return sb.toString();
    }
}

