/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.analysis.PartitionValue;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.util.ListUtil;

public class ListPartitionInfo
extends PartitionInfo {
    public ListPartitionInfo() {
    }

    public ListPartitionInfo(List<Column> partitionColumns) {
        super(PartitionType.LIST);
        this.partitionColumns = partitionColumns;
        this.isMultiColumnPartition = partitionColumns.size() > 1;
    }

    public static PartitionInfo read(DataInput in) throws IOException {
        ListPartitionInfo partitionInfo = new ListPartitionInfo();
        ((PartitionInfo)partitionInfo).readFields(in);
        return partitionInfo;
    }

    @Override
    public PartitionItem createAndCheckPartitionItem(SinglePartitionDesc desc, boolean isTemp) throws DdlException {
        PartitionKeyDesc partitionKeyDesc = desc.getPartitionKeyDesc();
        for (List<PartitionValue> values : partitionKeyDesc.getInValues()) {
            Preconditions.checkArgument((values.size() == this.partitionColumns.size() ? 1 : 0) != 0, (Object)("partition key desc list size[" + values.size() + "] is not equal to partition column size[" + this.partitionColumns.size() + "]"));
        }
        ArrayList<PartitionKey> partitionKeys = new ArrayList<PartitionKey>();
        try {
            for (List list : partitionKeyDesc.getInValues()) {
                PartitionKey partitionKey = PartitionKey.createListPartitionKey(list, this.partitionColumns);
                this.checkNewPartitionKey(partitionKey, partitionKeyDesc, isTemp);
                if (partitionKeys.contains(partitionKey)) {
                    throw new AnalysisException("The partition key[" + partitionKeyDesc.toSql() + "] has duplicate item [" + partitionKey.toSql() + "].");
                }
                partitionKeys.add(partitionKey);
            }
        }
        catch (AnalysisException e) {
            throw new DdlException("Invalid list value format: " + e.getMessage());
        }
        return new ListPartitionItem(partitionKeys);
    }

    private void checkNewPartitionKey(PartitionKey newKey, PartitionKeyDesc keyDesc, boolean isTemp) throws AnalysisException {
        Map id2Item = this.idToItem;
        if (isTemp) {
            id2Item = this.idToTempItem;
        }
        for (Map.Entry entry : id2Item.entrySet()) {
            if (!((ListPartitionItem)entry.getValue()).getItems().contains(newKey)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("The partition key[").append(newKey.toSql()).append("] in partition item[").append(keyDesc.toSql()).append("] is conflict with current partitionKeys[").append(((ListPartitionItem)entry.getValue()).toSql()).append("]");
            throw new AnalysisException(sb.toString());
        }
    }

    @Override
    public void checkPartitionItemListsMatch(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        ListUtil.checkPartitionKeyListsMatch(list1, list2);
    }

    @Override
    public void checkPartitionItemListsConflict(List<PartitionItem> list1, List<PartitionItem> list2) throws DdlException {
        ListUtil.checkListsConflict(list1, list2);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.partitionColumns.size());
        for (Column column : this.partitionColumns) {
            column.write(out);
        }
        out.writeInt(this.idToItem.size());
        for (Map.Entry entry : this.idToItem.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((PartitionItem)entry.getValue()).write(out);
        }
        out.writeInt(this.idToTempItem.size());
        for (Map.Entry entry : this.idToTempItem.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((PartitionItem)entry.getValue()).write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        ListPartitionItem partitionItem;
        int i;
        super.readFields(in);
        int counter = in.readInt();
        for (i = 0; i < counter; ++i) {
            Column column = Column.read(in);
            this.partitionColumns.add(column);
        }
        this.isMultiColumnPartition = this.partitionColumns.size() > 1;
        counter = in.readInt();
        for (i = 0; i < counter; ++i) {
            long partitionId = in.readLong();
            partitionItem = ListPartitionItem.read(in);
            this.idToItem.put(partitionId, partitionItem);
        }
        counter = in.readInt();
        for (i = 0; i < counter; ++i) {
            long partitionId = in.readLong();
            partitionItem = ListPartitionItem.read(in);
            this.idToTempItem.put(partitionId, partitionItem);
        }
    }

    public static void checkPartitionColumn(Column column) throws AnalysisException {
        PrimitiveType type = column.getDataType();
        if (!(type.isFixedPointType() || type.isDateType() || type.isCharFamily() || type == PrimitiveType.BOOLEAN)) {
            throw new AnalysisException("Column[" + column.getName() + "] type[" + (Object)((Object)type) + "] cannot be a list partition key.");
        }
    }

    @Override
    public String toSql(OlapTable table, List<Long> partitionId) {
        StringBuilder sb = new StringBuilder();
        sb.append("PARTITION BY LIST(");
        int idx = 0;
        for (Column column : this.partitionColumns) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append("`").append(column.getName()).append("`");
            ++idx;
        }
        sb.append(")\n(");
        ArrayList entries = new ArrayList(this.idToItem.entrySet());
        Collections.sort(entries, ListUtil.LIST_MAP_ENTRY_COMPARATOR);
        idx = 0;
        for (Map.Entry entry : entries) {
            Partition partition = table.getPartition((Long)entry.getKey());
            String partitionName = partition.getName();
            List partitionKeys = (List)((PartitionItem)entry.getValue()).getItems();
            sb.append("PARTITION ").append(partitionName).append(" VALUES IN ");
            sb.append("(");
            int idxInternal = 0;
            for (PartitionKey partitionKey : partitionKeys) {
                String partitionKeyStr = partitionKey.toSql();
                if (!this.isMultiColumnPartition) {
                    partitionKeyStr = partitionKeyStr.substring(1, partitionKeyStr.length() - 1);
                }
                sb.append(partitionKeyStr);
                if (partitionKeys.size() > 1 && idxInternal != partitionKeys.size() - 1) {
                    sb.append(",");
                }
                ++idxInternal;
            }
            sb.append(")");
            if (partitionId != null) {
                partitionId.add((Long)entry.getKey());
                break;
            }
            if (idx != entries.size() - 1) {
                sb.append(",\n");
            }
            ++idx;
        }
        sb.append(")");
        return sb.toString();
    }
}

