/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import org.apache.doris.thrift.TKeysType;

public enum KeysType {
    PRIMARY_KEYS,
    DUP_KEYS,
    UNIQUE_KEYS,
    AGG_KEYS;


    public boolean isAggregationFamily() {
        switch (this) {
            case AGG_KEYS: 
            case UNIQUE_KEYS: {
                return true;
            }
        }
        return false;
    }

    public TKeysType toThrift() {
        switch (this) {
            case PRIMARY_KEYS: {
                return TKeysType.PRIMARY_KEYS;
            }
            case DUP_KEYS: {
                return TKeysType.DUP_KEYS;
            }
            case UNIQUE_KEYS: {
                return TKeysType.UNIQUE_KEYS;
            }
            case AGG_KEYS: {
                return TKeysType.AGG_KEYS;
            }
        }
        return null;
    }

    public static KeysType fromThrift(TKeysType tKeysType) {
        switch (tKeysType) {
            case PRIMARY_KEYS: {
                return PRIMARY_KEYS;
            }
            case DUP_KEYS: {
                return DUP_KEYS;
            }
            case UNIQUE_KEYS: {
                return UNIQUE_KEYS;
            }
            case AGG_KEYS: {
                return AGG_KEYS;
            }
        }
        return null;
    }

    public String toSql() {
        switch (this) {
            case PRIMARY_KEYS: {
                return "PRIMARY KEY";
            }
            case DUP_KEYS: {
                return "DUPLICATE KEY";
            }
            case UNIQUE_KEYS: {
                return "UNIQUE KEY";
            }
            case AGG_KEYS: {
                return "AGGREGATE KEY";
            }
        }
        return null;
    }
}

