/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.SchemaTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.Pair;
import org.apache.doris.common.SystemIdGenerator;

public class InfoSchemaDb
extends Database {
    public static final String DATABASE_NAME = "information_schema";

    public InfoSchemaDb() {
        super(SystemIdGenerator.getNextId(), DATABASE_NAME);
        this.initTables();
    }

    public InfoSchemaDb(String cluster) {
        super(SystemIdGenerator.getNextId(), ClusterNamespace.getFullName(cluster, DATABASE_NAME));
        this.initTables();
    }

    @Override
    public Pair<Boolean, Boolean> createTableWithLock(Table table, boolean isReplay, boolean setIfNotExist) {
        return Pair.create(false, false);
    }

    @Override
    public boolean createTable(Table table) {
        return false;
    }

    @Override
    public void dropTable(String name) {
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        throw new IOException("Not support.");
    }

    private void initTables() {
        for (Table table : SchemaTable.TABLE_MAP.values()) {
            super.createTable(table);
        }
    }

    @Override
    public Table getTableNullable(String name) {
        return super.getTableNullable(name.toLowerCase());
    }

    public static String getFullInfoSchemaDbName(String cluster) {
        return ClusterNamespace.getFullName(cluster, DATABASE_NAME);
    }

    public static boolean isInfoSchemaDb(String dbName) {
        if (dbName == null) {
            return false;
        }
        String[] ele = dbName.split(":");
        String newDbName = dbName;
        if (ele.length == 2) {
            newDbName = ele[1];
        }
        return DATABASE_NAME.equalsIgnoreCase(newDbName);
    }
}

