/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.IndexDef;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.thrift.TIndexType;
import org.apache.doris.thrift.TOlapTableIndex;

public class Index
implements Writable {
    @SerializedName(value="indexName")
    private String indexName;
    @SerializedName(value="columns")
    private List<String> columns;
    @SerializedName(value="indexType")
    private IndexDef.IndexType indexType;
    @SerializedName(value="comment")
    private String comment;

    public Index(String indexName, List<String> columns, IndexDef.IndexType indexType, String comment) {
        this.indexName = indexName;
        this.columns = columns;
        this.indexType = indexType;
        this.comment = comment;
    }

    public Index() {
        this.indexName = null;
        this.columns = null;
        this.indexType = null;
        this.comment = null;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public IndexDef.IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexDef.IndexType indexType) {
        this.indexType = indexType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static Index read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (Index)GsonUtils.GSON.fromJson(json, Index.class);
    }

    public int hashCode() {
        return 31 * (this.indexName.hashCode() + this.columns.hashCode() + this.indexType.hashCode());
    }

    public Index clone() {
        return new Index(this.indexName, new ArrayList<String>(this.columns), this.indexType, this.comment);
    }

    public String toString() {
        return this.toSql();
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder("INDEX ");
        sb.append(this.indexName);
        sb.append(" (");
        boolean first = true;
        for (String col : this.columns) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("`" + col + "`");
        }
        sb.append(")");
        if (this.indexType != null) {
            sb.append(" USING ").append(this.indexType.toString());
        }
        if (this.comment != null) {
            sb.append(" COMMENT '" + this.comment + "'");
        }
        return sb.toString();
    }

    public TOlapTableIndex toThrift() {
        TOlapTableIndex tIndex = new TOlapTableIndex();
        tIndex.setIndexName(this.indexName);
        tIndex.setColumns(this.columns);
        tIndex.setIndexType(TIndexType.valueOf((String)this.indexType.toString()));
        if (this.columns != null) {
            tIndex.setComment(this.comment);
        }
        return tIndex;
    }
}

