/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.IcebergProperty;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.external.iceberg.IcebergCatalog;
import org.apache.doris.external.iceberg.IcebergCatalogMgr;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TIcebergTable;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.expressions.Expression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IcebergTable
extends Table {
    private static final Logger LOG = LogManager.getLogger(IcebergTable.class);
    private String icebergDb;
    private String icebergTbl;
    private String location;
    private String fileFormat;
    private StorageBackend.StorageType storageType;
    private String hostUri;
    private boolean isAnalyzed = false;
    private Map<String, String> icebergProperties = Maps.newHashMap();
    private org.apache.iceberg.Table icebergTable;
    private final byte[] loadLock = new byte[0];
    private final AtomicBoolean isLoaded = new AtomicBoolean(false);

    public IcebergTable() {
        super(Table.TableType.ICEBERG);
    }

    public IcebergTable(long id, String tableName, List<Column> fullSchema, IcebergProperty icebergProperty, org.apache.iceberg.Table icebergTable) {
        super(id, tableName, Table.TableType.ICEBERG, fullSchema);
        this.icebergDb = icebergProperty.getDatabase();
        this.icebergTbl = icebergProperty.getTable();
        this.icebergProperties.put("iceberg.hive.metastore.uris", icebergProperty.getHiveMetastoreUris());
        this.icebergProperties.put("iceberg.catalog.type", icebergProperty.getCatalogType());
        this.icebergTable = icebergTable;
    }

    public String getIcebergDbTable() {
        return String.format("%s.%s", this.icebergDb, this.icebergTbl);
    }

    public String getIcebergDb() {
        return this.icebergDb;
    }

    public String getIcebergTbl() {
        return this.icebergTbl;
    }

    public Map<String, String> getIcebergProperties() {
        return this.icebergProperties;
    }

    private void getLocation() throws UserException {
        if (Strings.isNullOrEmpty((String)this.location)) {
            try {
                this.getTable();
            }
            catch (Exception e) {
                throw new UserException("Failed to get table: " + this.name + ",error: " + e.getMessage());
            }
            this.location = this.icebergTable.location();
        }
        this.analyzeLocation();
    }

    private void analyzeLocation() throws UserException {
        if (this.isAnalyzed) {
            return;
        }
        String[] strings = StringUtils.split((String)this.location, (String)"/");
        String storagePrefix = strings[0].split(":")[0];
        if (storagePrefix.equalsIgnoreCase("s3")) {
            this.storageType = StorageBackend.StorageType.S3;
        } else if (storagePrefix.equalsIgnoreCase("hdfs")) {
            this.storageType = StorageBackend.StorageType.HDFS;
        } else {
            throw new UserException("Not supported storage type: " + storagePrefix);
        }
        String host = strings[1];
        this.hostUri = storagePrefix + "://" + host;
        this.isAnalyzed = true;
    }

    public String getHostUri() throws UserException {
        if (!this.isAnalyzed) {
            this.getLocation();
        }
        return this.hostUri;
    }

    public StorageBackend.StorageType getStorageType() throws UserException {
        if (!this.isAnalyzed) {
            this.getLocation();
        }
        return this.storageType;
    }

    public String getFileFormat() throws UserException {
        if (Strings.isNullOrEmpty((String)this.fileFormat)) {
            try {
                this.getTable();
            }
            catch (Exception e) {
                throw new UserException("Failed to get table: " + this.name + ",error: " + e.getMessage());
            }
            this.fileFormat = (String)this.icebergTable.properties().get("write.format.default");
        }
        return this.fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.iceberg.Table getTable() throws Exception {
        if (this.isLoaded.get()) {
            Preconditions.checkNotNull((Object)this.icebergTable);
            return this.icebergTable;
        }
        byte[] byArray = this.loadLock;
        synchronized (this.loadLock) {
            if (this.icebergTable != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.icebergTable;
            }
            IcebergProperty icebergProperty = this.getIcebergProperty();
            IcebergCatalog icebergCatalog = IcebergCatalogMgr.getCatalog(icebergProperty);
            try {
                this.icebergTable = icebergCatalog.loadTable(TableIdentifier.of((String[])new String[]{this.icebergDb, this.icebergTbl}));
                LOG.info("finished to load iceberg table: {}", (Object)this.name);
            }
            catch (Exception e) {
                LOG.warn("failed to load iceberg table {} from {}", (Object)this.name, (Object)icebergProperty.getHiveMetastoreUris(), (Object)e);
                throw e;
            }
            this.isLoaded.set(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.icebergTable;
        }
    }

    private IcebergProperty getIcebergProperty() {
        HashMap properties = Maps.newHashMap(this.icebergProperties);
        properties.put("iceberg.database", this.icebergDb);
        properties.put("iceberg.table", this.icebergTbl);
        return new IcebergProperty(properties);
    }

    public List<TBrokerFileStatus> getIcebergDataFiles(List<Expression> predicates) throws Exception {
        org.apache.iceberg.Table table = this.getTable();
        TableScan scan = table.newScan();
        for (Expression predicate : predicates) {
            scan = scan.filter(predicate);
        }
        ArrayList relatedFiles = Lists.newArrayList();
        for (FileScanTask task : scan.planFiles()) {
            Path path = Paths.get(task.file().path().toString(), new String[0]);
            String relativePath = "/" + path.subpath(2, path.getNameCount());
            relatedFiles.add(new TBrokerFileStatus(relativePath, false, task.file().fileSizeInBytes(), false));
        }
        return relatedFiles;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.icebergDb);
        Text.writeString((DataOutput)out, (String)this.icebergTbl);
        out.writeInt(this.icebergProperties.size());
        for (Map.Entry<String, String> entry : this.icebergProperties.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.icebergDb = Text.readString((DataInput)in);
        this.icebergTbl = Text.readString((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.icebergProperties.put(key, value);
        }
    }

    @Override
    public TTableDescriptor toThrift() {
        TIcebergTable tIcebergTable = new TIcebergTable(this.getIcebergDb(), this.getIcebergTbl(), this.getIcebergProperties());
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.ICEBERG_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setIcebergTable(tIcebergTable);
        return tTableDescriptor;
    }
}

