/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import java.util.Map;

public class IcebergProperty {
    public static final String ICEBERG_DATABASE = "iceberg.database";
    public static final String ICEBERG_TABLE = "iceberg.table";
    public static final String ICEBERG_HIVE_METASTORE_URIS = "iceberg.hive.metastore.uris";
    public static final String ICEBERG_CATALOG_TYPE = "iceberg.catalog.type";
    private boolean exist;
    private String database;
    private String table;
    private String hiveMetastoreUris;
    private String catalogType;

    public IcebergProperty(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.exist = true;
            this.database = properties.get(ICEBERG_DATABASE);
            this.table = properties.get(ICEBERG_TABLE);
            this.hiveMetastoreUris = properties.get(ICEBERG_HIVE_METASTORE_URIS);
            this.catalogType = properties.get(ICEBERG_CATALOG_TYPE);
        } else {
            this.exist = false;
        }
    }

    public IcebergProperty(IcebergProperty otherProperty) {
        this.exist = otherProperty.exist;
        this.database = otherProperty.database;
        this.table = otherProperty.table;
        this.hiveMetastoreUris = otherProperty.hiveMetastoreUris;
        this.catalogType = otherProperty.catalogType;
    }

    public boolean isExist() {
        return this.exist;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getHiveMetastoreUris() {
        return this.hiveMetastoreUris;
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getProperties() {
        return "";
    }

    public void setTable(String table) {
        this.table = table;
    }
}

