/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.AuthType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.thrift.THiveTable;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;

public class HiveTable
extends Table {
    private static final String PROPERTY_MISSING_MSG = "Hive %s is null. Please add properties('%s'='xxx') when create table";
    private static final String PROPERTY_ERROR_MSG = "Hive table properties('%s'='%s') is illegal or not supported. Please check it";
    private String hiveDb;
    private String hiveTable;
    private Map<String, String> hiveProperties = Maps.newHashMap();
    public static final String HIVE_DB = "database";
    public static final String HIVE_TABLE = "table";
    public static final String HIVE_METASTORE_URIS = "hive.metastore.uris";
    public static final String HIVE_HDFS_PREFIX = "dfs";
    public static final String S3_PROPERTIES_PREFIX = "AWS";
    public static final String S3_AK = "AWS_ACCESS_KEY";
    public static final String S3_SK = "AWS_SECRET_KEY";
    public static final String S3_ENDPOINT = "AWS_ENDPOINT";

    public HiveTable() {
        super(Table.TableType.HIVE);
    }

    public HiveTable(long id, String name, List<Column> schema, Map<String, String> properties) throws DdlException {
        super(id, name, Table.TableType.HIVE, schema);
        this.validate(properties);
    }

    public String getHiveDbTable() {
        return String.format("%s.%s", this.hiveDb, this.hiveTable);
    }

    public String getHiveDb() {
        return this.hiveDb;
    }

    public String getHiveTable() {
        return this.hiveTable;
    }

    public Map<String, String> getHiveProperties() {
        return this.hiveProperties;
    }

    private void validate(Map<String, String> properties) throws DdlException {
        String HDFSUserName;
        if (properties == null) {
            throw new DdlException("Please set properties of hive table, they are: database, table and 'hive.metastore.uris'");
        }
        HashMap copiedProps = Maps.newHashMap(properties);
        this.hiveDb = (String)copiedProps.get(HIVE_DB);
        if (Strings.isNullOrEmpty((String)this.hiveDb)) {
            throw new DdlException(String.format(PROPERTY_MISSING_MSG, HIVE_DB, HIVE_DB));
        }
        copiedProps.remove(HIVE_DB);
        this.hiveTable = (String)copiedProps.get(HIVE_TABLE);
        if (Strings.isNullOrEmpty((String)this.hiveTable)) {
            throw new DdlException(String.format(PROPERTY_MISSING_MSG, HIVE_TABLE, HIVE_TABLE));
        }
        copiedProps.remove(HIVE_TABLE);
        String hiveMetaStoreUris = (String)copiedProps.get(HIVE_METASTORE_URIS);
        if (Strings.isNullOrEmpty((String)hiveMetaStoreUris)) {
            throw new DdlException(String.format(PROPERTY_MISSING_MSG, HIVE_METASTORE_URIS, HIVE_METASTORE_URIS));
        }
        copiedProps.remove(HIVE_METASTORE_URIS);
        this.hiveProperties.put(HIVE_METASTORE_URIS, hiveMetaStoreUris);
        String authType = (String)copiedProps.get(BrokerUtil.HADOOP_SECURITY_AUTHENTICATION);
        if (Strings.isNullOrEmpty((String)authType)) {
            authType = AuthType.SIMPLE.getDesc();
        }
        if (!AuthType.isSupportedAuthType(authType)) {
            throw new DdlException(String.format(PROPERTY_ERROR_MSG, BrokerUtil.HADOOP_SECURITY_AUTHENTICATION, authType));
        }
        copiedProps.remove(BrokerUtil.HADOOP_SECURITY_AUTHENTICATION);
        this.hiveProperties.put(BrokerUtil.HADOOP_SECURITY_AUTHENTICATION, authType);
        if (AuthType.KERBEROS.getDesc().equals(authType)) {
            String principal = (String)copiedProps.get(BrokerUtil.HADOOP_KERBEROS_PRINCIPAL);
            if (Strings.isNullOrEmpty((String)principal)) {
                throw new DdlException(String.format(PROPERTY_MISSING_MSG, BrokerUtil.HADOOP_KERBEROS_PRINCIPAL, BrokerUtil.HADOOP_KERBEROS_PRINCIPAL));
            }
            this.hiveProperties.put(BrokerUtil.HADOOP_KERBEROS_PRINCIPAL, principal);
            copiedProps.remove(BrokerUtil.HADOOP_KERBEROS_PRINCIPAL);
            String keytabPath = (String)copiedProps.get(BrokerUtil.HADOOP_KERBEROS_KEYTAB);
            if (Strings.isNullOrEmpty((String)keytabPath)) {
                throw new DdlException(String.format(PROPERTY_MISSING_MSG, BrokerUtil.HADOOP_KERBEROS_KEYTAB, BrokerUtil.HADOOP_KERBEROS_KEYTAB));
            }
            if (!Strings.isNullOrEmpty((String)keytabPath)) {
                this.hiveProperties.put(BrokerUtil.HADOOP_KERBEROS_KEYTAB, keytabPath);
                copiedProps.remove(BrokerUtil.HADOOP_KERBEROS_KEYTAB);
            }
        }
        if (!Strings.isNullOrEmpty((String)(HDFSUserName = (String)copiedProps.get(BrokerUtil.HADOOP_USER_NAME)))) {
            this.hiveProperties.put(BrokerUtil.HADOOP_USER_NAME, HDFSUserName);
            copiedProps.remove(BrokerUtil.HADOOP_USER_NAME);
        }
        if (!copiedProps.isEmpty()) {
            Iterator iter = copiedProps.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(HIVE_HDFS_PREFIX) && !key.startsWith(S3_PROPERTIES_PREFIX)) continue;
                this.hiveProperties.put(key, (String)entry.getValue());
                iter.remove();
            }
        }
        if (!copiedProps.isEmpty()) {
            throw new DdlException("Unknown table properties: " + ((Object)copiedProps).toString());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.hiveDb);
        Text.writeString((DataOutput)out, (String)this.hiveTable);
        out.writeInt(this.hiveProperties.size());
        for (Map.Entry<String, String> entry : this.hiveProperties.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.hiveDb = Text.readString((DataInput)in);
        this.hiveTable = Text.readString((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String val = Text.readString((DataInput)in);
            this.hiveProperties.put(key, val);
        }
    }

    @Override
    public TTableDescriptor toThrift() {
        THiveTable tHiveTable = new THiveTable(this.getHiveDb(), this.getHiveTable(), this.getHiveProperties());
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.HIVE_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setHiveTable(tHiveTable);
        return tTableDescriptor;
    }
}

