/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.AuthType;
import org.apache.doris.catalog.HiveTable;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class HiveMetaStoreClientHelper {
    private static final Logger LOG = LogManager.getLogger(HiveMetaStoreClientHelper.class);

    public static HiveMetaStoreClient getClient(String metaStoreUris) throws DdlException {
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, metaStoreUris);
        HiveMetaStoreClient hivemetastoreclient = null;
        try {
            hivemetastoreclient = new HiveMetaStoreClient(hiveConf);
        }
        catch (MetaException e) {
            LOG.warn("Create HiveMetaStoreClient failed: {}", (Object)e.getMessage());
            throw new DdlException("Create HiveMetaStoreClient failed");
        }
        return hivemetastoreclient;
    }

    public static boolean tableExists(HiveMetaStoreClient client, String dbName, String tblName) throws DdlException {
        try {
            boolean bl = client.tableExists(dbName, tblName);
            return bl;
        }
        catch (TException e) {
            LOG.warn("Hive metastore thrift exception: {}", (Object)e.getMessage());
            throw new DdlException("Connect hive metastore failed.");
        }
        finally {
            HiveMetaStoreClientHelper.dropClient(client);
        }
    }

    public static void dropClient(HiveMetaStoreClient client) {
        client.close();
    }

    public static String getHiveDataFiles(HiveTable hiveTable, ExprNodeGenericFuncDesc hivePartitionPredicate, List<TBrokerFileStatus> fileStatuses, Table remoteHiveTbl, StorageBackend.StorageType type) throws DdlException {
        List<RemoteIterator<LocatedFileStatus>> remoteIterators;
        HiveMetaStoreClient client = HiveMetaStoreClientHelper.getClient(hiveTable.getHiveProperties().get("hive.metastore.uris"));
        Boolean onS3 = type.equals((Object)StorageBackend.StorageType.S3);
        if (remoteHiveTbl.getPartitionKeys().size() > 0) {
            ArrayList<Partition> hivePartitions = new ArrayList<Partition>();
            try {
                client.listPartitionsByExpr(hiveTable.getHiveDb(), hiveTable.getHiveTable(), SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)hivePartitionPredicate), null, (short)-1, hivePartitions);
            }
            catch (TException e) {
                LOG.warn("Hive metastore thrift exception: {}", (Object)e.getMessage());
                throw new DdlException("Connect hive metastore failed.");
            }
            finally {
                client.close();
            }
            remoteIterators = HiveMetaStoreClientHelper.getRemoteIterator(hivePartitions, hiveTable.getHiveProperties(), (boolean)onS3);
        } else {
            remoteIterators = HiveMetaStoreClientHelper.getRemoteIterator(remoteHiveTbl, hiveTable.getHiveProperties(), (boolean)onS3);
        }
        String hdfsUrl = "";
        for (RemoteIterator<LocatedFileStatus> iterator : remoteIterators) {
            try {
                while (iterator.hasNext()) {
                    LocatedFileStatus fileStatus = (LocatedFileStatus)iterator.next();
                    TBrokerFileStatus brokerFileStatus = new TBrokerFileStatus();
                    brokerFileStatus.setIsDir(fileStatus.isDirectory());
                    brokerFileStatus.setIsSplitable(true);
                    brokerFileStatus.setSize(fileStatus.getLen());
                    String path = fileStatus.getPath().toUri().getPath();
                    if (onS3.booleanValue()) {
                        path = fileStatus.getPath().toString();
                    }
                    brokerFileStatus.setPath(path);
                    fileStatuses.add(brokerFileStatus);
                    if (!StringUtils.isEmpty((CharSequence)hdfsUrl)) continue;
                    String fullUri = fileStatus.getPath().toString();
                    hdfsUrl = fullUri.replace(path, "");
                }
            }
            catch (IOException e) {
                LOG.warn("List HDFS file IOException: {}", (Object)e.getMessage());
                throw new DdlException("List HDFS file failed.");
            }
        }
        return hdfsUrl;
    }

    private static void setS3Configuration(Configuration configuration, Map<String, String> properties) {
        if (properties.containsKey("AWS_ACCESS_KEY")) {
            configuration.set("fs.s3a.access.key", properties.get("AWS_ACCESS_KEY"));
        }
        if (properties.containsKey("AWS_SECRET_KEY")) {
            configuration.set("fs.s3a.secret.key", properties.get("AWS_SECRET_KEY"));
        }
        if (properties.containsKey("AWS_ENDPOINT")) {
            configuration.set("fs.s3a.endpoint", properties.get("AWS_ENDPOINT"));
        }
        configuration.set("fs.s3.impl.disable.cache", "true");
        configuration.set("fs.s3.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        configuration.set("fs.s3a.attempts.maximum", "2");
    }

    private static List<RemoteIterator<LocatedFileStatus>> getRemoteIterator(List<Partition> partitions, Map<String, String> properties, boolean onS3) throws DdlException {
        ArrayList<RemoteIterator<LocatedFileStatus>> iterators = new ArrayList<RemoteIterator<LocatedFileStatus>>();
        Configuration configuration = new Configuration(false);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().equals("hive.metastore.uris")) continue;
            configuration.set(entry.getKey(), entry.getValue());
        }
        if (onS3) {
            HiveMetaStoreClientHelper.setS3Configuration(configuration, properties);
        }
        for (Partition p : partitions) {
            String location = p.getSd().getLocation();
            Path path = new Path(location);
            try {
                FileSystem fileSystem = path.getFileSystem(configuration);
                iterators.add((RemoteIterator<LocatedFileStatus>)fileSystem.listLocatedStatus(path));
            }
            catch (IOException e) {
                LOG.warn("Get HDFS file remote iterator failed. {}", (Object)e.getMessage());
                throw new DdlException("Get HDFS file remote iterator failed.");
            }
        }
        return iterators;
    }

    private static List<RemoteIterator<LocatedFileStatus>> getRemoteIterator(Table table, Map<String, String> properties, boolean onS3) throws DdlException {
        ArrayList<RemoteIterator<LocatedFileStatus>> iterators = new ArrayList<RemoteIterator<LocatedFileStatus>>();
        Configuration configuration = new Configuration(false);
        boolean isSecurityEnabled = false;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().equals("hive.metastore.uris")) {
                configuration.set(entry.getKey(), entry.getValue());
            }
            if (!entry.getKey().equals(BrokerUtil.HADOOP_SECURITY_AUTHENTICATION) || !entry.getValue().equals(AuthType.KERBEROS.getDesc())) continue;
            isSecurityEnabled = true;
        }
        if (onS3) {
            HiveMetaStoreClientHelper.setS3Configuration(configuration, properties);
        }
        String location = table.getSd().getLocation();
        Path path = new Path(location);
        try {
            if (isSecurityEnabled) {
                UserGroupInformation.setConfiguration((Configuration)configuration);
                UserGroupInformation.loginUserFromKeytab((String)properties.get(BrokerUtil.HADOOP_KERBEROS_PRINCIPAL), (String)properties.get(BrokerUtil.HADOOP_KERBEROS_KEYTAB));
            }
            FileSystem fileSystem = path.getFileSystem(configuration);
            iterators.add(fileSystem.listLocatedStatus(path));
        }
        catch (IOException e) {
            LOG.warn("Get HDFS file remote iterator failed. {}" + e.getMessage());
            throw new DdlException("Get HDFS file remote iterator failed.");
        }
        return iterators;
    }

    public static List<String> getPartitionNames(HiveTable hiveTable) throws DdlException {
        HiveMetaStoreClient client = HiveMetaStoreClientHelper.getClient(hiveTable.getHiveProperties().get("hive.metastore.uris"));
        ArrayList<String> partitionNames = new ArrayList();
        try {
            partitionNames = client.listPartitionNames(hiveTable.getHiveDb(), hiveTable.getHiveTable(), (short)-1);
        }
        catch (TException e) {
            LOG.warn("Hive metastore thrift exception: {}", (Object)e.getMessage());
            throw new DdlException("Connect hive metastore failed.");
        }
        return partitionNames;
    }

    public static Table getTable(HiveTable hiveTable) throws DdlException {
        Table table;
        HiveMetaStoreClient client = HiveMetaStoreClientHelper.getClient(hiveTable.getHiveProperties().get("hive.metastore.uris"));
        try {
            table = client.getTable(hiveTable.getHiveDb(), hiveTable.getHiveTable());
        }
        catch (TException e) {
            LOG.warn("Hive metastore thrift exception: {}", (Object)e.getMessage());
            throw new DdlException("Connect hive metastore failed.");
        }
        return table;
    }

    public static ExprNodeGenericFuncDesc convertToHivePartitionExpr(Expr dorisExpr, List<String> partitions, String tblName) throws DdlException {
        if (dorisExpr == null) {
            return null;
        }
        if (dorisExpr instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)dorisExpr;
            switch (compoundPredicate.getOp()) {
                case AND: {
                    ExprNodeGenericFuncDesc left = HiveMetaStoreClientHelper.convertToHivePartitionExpr((Expr)compoundPredicate.getChild(0), partitions, tblName);
                    ExprNodeGenericFuncDesc right = HiveMetaStoreClientHelper.convertToHivePartitionExpr((Expr)compoundPredicate.getChild(0), partitions, tblName);
                    if (left != null && right != null) {
                        ArrayList<ExprNodeDesc> andArgs = new ArrayList<ExprNodeDesc>();
                        andArgs.add((ExprNodeDesc)left);
                        andArgs.add((ExprNodeDesc)right);
                        return HiveMetaStoreClientHelper.getCompoundExpr(andArgs, "and");
                    }
                    if (left != null && right == null) {
                        return left;
                    }
                    if (left == null && right != null) {
                        return right;
                    }
                    return null;
                }
                case OR: {
                    ExprNodeGenericFuncDesc left = HiveMetaStoreClientHelper.convertToHivePartitionExpr((Expr)compoundPredicate.getChild(0), partitions, tblName);
                    ExprNodeGenericFuncDesc right = HiveMetaStoreClientHelper.convertToHivePartitionExpr((Expr)compoundPredicate.getChild(0), partitions, tblName);
                    if (left != null && right != null) {
                        ArrayList<ExprNodeDesc> orArgs = new ArrayList<ExprNodeDesc>();
                        orArgs.add((ExprNodeDesc)left);
                        orArgs.add((ExprNodeDesc)right);
                        return HiveMetaStoreClientHelper.getCompoundExpr(orArgs, "or");
                    }
                    if (left != null && right == null) {
                        return left;
                    }
                    if (left == null && right != null) {
                        return right;
                    }
                    return null;
                }
            }
            return null;
        }
        TExprOpcode opcode = dorisExpr.getOpcode();
        switch (opcode) {
            case EQ: 
            case EQ_FOR_NULL: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                BinaryPredicate eq = (BinaryPredicate)dorisExpr;
                SlotRef slotRef = HiveMetaStoreClientHelper.convertDorisExprToSlotRef((Expr)eq.getChild(0));
                LiteralExpr literalExpr = null;
                if (slotRef == null && ((Expr)eq.getChild(0)).isLiteral()) {
                    literalExpr = (LiteralExpr)eq.getChild(0);
                    slotRef = HiveMetaStoreClientHelper.convertDorisExprToSlotRef((Expr)eq.getChild(1));
                } else if (((Expr)eq.getChild(1)).isLiteral()) {
                    literalExpr = (LiteralExpr)eq.getChild(1);
                }
                if (slotRef == null || literalExpr == null) {
                    return null;
                }
                String colName = slotRef.getColumnName();
                if (!partitions.contains(colName)) {
                    return null;
                }
                PrimitiveType dorisPrimitiveType = slotRef.getType().getPrimitiveType();
                PrimitiveTypeInfo hivePrimitiveType = HiveMetaStoreClientHelper.convertToHiveColType(dorisPrimitiveType);
                Object value = HiveMetaStoreClientHelper.extractDorisLiteral(literalExpr);
                ExprBuilder exprBuilder = new ExprBuilder(tblName);
                if (value == null) {
                    if (opcode == TExprOpcode.EQ_FOR_NULL && literalExpr instanceof NullLiteral) {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, "NULL").pred("=", 2).build();
                    }
                    return null;
                }
                switch (opcode) {
                    case EQ: 
                    case EQ_FOR_NULL: {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, value).pred("=", 2).build();
                    }
                    case NE: {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, value).pred("!=", 2).build();
                    }
                    case GE: {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, value).pred(">=", 2).build();
                    }
                    case GT: {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, value).pred(">", 2).build();
                    }
                    case LE: {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, value).pred("<=", 2).build();
                    }
                    case LT: {
                        return exprBuilder.col((TypeInfo)hivePrimitiveType, colName).val((TypeInfo)hivePrimitiveType, value).pred("<", 2).build();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static ExprNodeGenericFuncDesc getCompoundExpr(List<ExprNodeDesc> args, String op) throws DdlException {
        ExprNodeGenericFuncDesc compoundExpr;
        try {
            compoundExpr = ExprNodeGenericFuncDesc.newInstance((GenericUDF)FunctionRegistry.getFunctionInfo((String)op).getGenericUDF(), args);
        }
        catch (SemanticException e) {
            LOG.warn("Convert to Hive expr failed: {}", (Object)e.getMessage());
            throw new DdlException("Convert to Hive expr failed.");
        }
        return compoundExpr;
    }

    private static SlotRef convertDorisExprToSlotRef(Expr expr) {
        SlotRef slotRef = null;
        if (expr instanceof SlotRef) {
            slotRef = (SlotRef)expr;
        } else if (expr instanceof CastExpr && expr.getChild(0) instanceof SlotRef) {
            slotRef = (SlotRef)expr.getChild(0);
        }
        return slotRef;
    }

    private static Object extractDorisLiteral(Expr expr) {
        if (!expr.isLiteral()) {
            return null;
        }
        if (expr instanceof BoolLiteral) {
            BoolLiteral boolLiteral = (BoolLiteral)expr;
            return boolLiteral.getValue();
        }
        if (expr instanceof DateLiteral) {
            Date date;
            DateLiteral dateLiteral = (DateLiteral)expr;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            StringBuilder sb = new StringBuilder();
            sb.append(dateLiteral.getYear()).append(dateLiteral.getMonth()).append(dateLiteral.getDay()).append(dateLiteral.getHour()).append(dateLiteral.getMinute()).append(dateLiteral.getSecond());
            try {
                date = formatter.parse(sb.toString());
            }
            catch (ParseException e) {
                return null;
            }
            return date.getTime();
        }
        if (expr instanceof DecimalLiteral) {
            DecimalLiteral decimalLiteral = (DecimalLiteral)expr;
            return decimalLiteral.getValue();
        }
        if (expr instanceof FloatLiteral) {
            FloatLiteral floatLiteral = (FloatLiteral)expr;
            return floatLiteral.getValue();
        }
        if (expr instanceof IntLiteral) {
            IntLiteral intLiteral = (IntLiteral)expr;
            return intLiteral.getValue();
        }
        if (expr instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expr;
            return stringLiteral.getStringValue();
        }
        return null;
    }

    private static PrimitiveTypeInfo convertToHiveColType(PrimitiveType dorisType) throws DdlException {
        switch (dorisType) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INT: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DECIMALV2: {
                return TypeInfoFactory.decimalTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case DATETIME: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case CHAR: {
                return TypeInfoFactory.charTypeInfo;
            }
            case VARCHAR: {
                return TypeInfoFactory.varcharTypeInfo;
            }
        }
        throw new DdlException("Unsupported column type: " + (Object)((Object)dorisType));
    }

    public static class ExprBuilder {
        private final String tblName;
        private final Stack<ExprNodeDesc> stack = new Stack();

        public ExprBuilder(String tblName) {
            this.tblName = tblName;
        }

        public ExprNodeGenericFuncDesc build() throws DdlException {
            if (this.stack.size() != 1) {
                throw new DdlException("Build Hive expression Failed: " + this.stack.size());
            }
            return (ExprNodeGenericFuncDesc)this.stack.pop();
        }

        public ExprBuilder pred(String name, int args) throws DdlException {
            return this.fn(name, (TypeInfo)TypeInfoFactory.booleanTypeInfo, args);
        }

        private ExprBuilder fn(String name, TypeInfo ti, int args) throws DdlException {
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < args; ++i) {
                children.add(this.stack.pop());
            }
            try {
                this.stack.push((ExprNodeDesc)new ExprNodeGenericFuncDesc(ti, FunctionRegistry.getFunctionInfo((String)name).getGenericUDF(), children));
            }
            catch (SemanticException e) {
                LOG.warn("Build Hive expression failed: semantic analyze exception: {}", (Object)e.getMessage());
                throw new DdlException("Build Hive expression Failed");
            }
            return this;
        }

        public ExprBuilder col(TypeInfo ti, String col) {
            this.stack.push((ExprNodeDesc)new ExprNodeColumnDesc(ti, col, this.tblName, true));
            return this;
        }

        public ExprBuilder val(TypeInfo ti, Object val) {
            this.stack.push((ExprNodeDesc)new ExprNodeConstantDesc(ti, val));
            return this;
        }
    }

    public static enum HiveFileFormat {
        TEXT_FILE(0, "text"),
        PARQUET(1, "parquet"),
        ORC(2, "orc");

        private int index;
        private String desc;

        private HiveFileFormat(int index, String desc) {
            this.index = index;
            this.desc = desc;
        }

        public int getIndex() {
            return this.index;
        }

        public String getDesc() {
            return this.desc;
        }

        public static String getFormat(String input) throws DdlException {
            String formatDesc = "";
            for (HiveFileFormat format : HiveFileFormat.values()) {
                String lowerCaseInput = input.toLowerCase();
                if (!lowerCaseInput.contains(format.getDesc())) continue;
                formatDesc = format.getDesc();
                break;
            }
            if (Strings.isNullOrEmpty((String)formatDesc)) {
                LOG.warn("Not supported Hive file format [{}].", (Object)input);
                throw new DdlException("Not supported Hive file format " + input);
            }
            return formatDesc;
        }
    }
}

