/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.HashDistributionDesc;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.RandomDistributionInfo;

public class HashDistributionInfo
extends DistributionInfo {
    @SerializedName(value="distributionColumns")
    private List<Column> distributionColumns;
    @SerializedName(value="bucketNum")
    private int bucketNum;

    public HashDistributionInfo() {
        this.distributionColumns = new ArrayList<Column>();
    }

    public HashDistributionInfo(int bucketNum, List<Column> distributionColumns) {
        super(DistributionInfo.DistributionInfoType.HASH);
        this.distributionColumns = distributionColumns;
        this.bucketNum = bucketNum;
    }

    public List<Column> getDistributionColumns() {
        return this.distributionColumns;
    }

    @Override
    public int getBucketNum() {
        return this.bucketNum;
    }

    @Override
    public void setBucketNum(int bucketNum) {
        this.bucketNum = bucketNum;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        int columnCount = this.distributionColumns.size();
        out.writeInt(columnCount);
        for (Column column : this.distributionColumns) {
            column.write(out);
        }
        out.writeInt(this.bucketNum);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int columnCount = in.readInt();
        for (int i = 0; i < columnCount; ++i) {
            Column column = Column.read(in);
            this.distributionColumns.add(column);
        }
        this.bucketNum = in.readInt();
    }

    public static DistributionInfo read(DataInput in) throws IOException {
        HashDistributionInfo distributionInfo = new HashDistributionInfo();
        ((DistributionInfo)distributionInfo).readFields(in);
        return distributionInfo;
    }

    @Override
    public boolean equals(DistributionInfo info) {
        if (this == info) {
            return true;
        }
        if (!(info instanceof HashDistributionInfo)) {
            return false;
        }
        HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)info;
        return this.type == hashDistributionInfo.type && this.bucketNum == hashDistributionInfo.bucketNum && this.distributionColumns.equals(hashDistributionInfo.distributionColumns);
    }

    @Override
    public DistributionDesc toDistributionDesc() {
        ArrayList distriColNames = Lists.newArrayList();
        for (Column col : this.distributionColumns) {
            distriColNames.add(col.getName());
        }
        HashDistributionDesc distributionDesc = new HashDistributionDesc(this.bucketNum, distriColNames);
        return distributionDesc;
    }

    @Override
    public String toSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("DISTRIBUTED BY HASH(");
        ArrayList colNames = Lists.newArrayList();
        for (Column column : this.distributionColumns) {
            colNames.add("`" + column.getName() + "`");
        }
        String colList = Joiner.on((String)", ").join((Iterable)colNames);
        builder.append(colList);
        builder.append(") BUCKETS ").append(this.bucketNum);
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type: ").append((Object)this.type).append("; ");
        builder.append("distribution columns: [");
        for (Column column : this.distributionColumns) {
            builder.append(column.getName()).append(",");
        }
        builder.append("]; ");
        builder.append("bucket num: ").append(this.bucketNum).append("; ");
        return builder.toString();
    }

    public RandomDistributionInfo toRandomDistributionInfo() {
        return new RandomDistributionInfo(this.bucketNum);
    }
}

