/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.catalog.ColumnType;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.io.Writable;

public class FunctionSearchDesc
implements Writable {
    private FunctionName name;
    private Type[] argTypes;
    private boolean isVariadic;

    private FunctionSearchDesc() {
    }

    public FunctionSearchDesc(FunctionName name, Type[] argTypes, boolean isVariadic) {
        this.name = name;
        this.argTypes = argTypes;
        this.isVariadic = isVariadic;
    }

    public FunctionName getName() {
        return this.name;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public boolean isIdentical(Function function) {
        if (!this.name.equals(function.getFunctionName())) {
            return false;
        }
        if (this.argTypes.length != function.getArgs().length) {
            return false;
        }
        if (this.isVariadic != function.hasVarArgs()) {
            return false;
        }
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (this.argTypes[i].matchesType(function.getArgs()[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name.toString()).append("(");
        int i = 0;
        for (Type type : this.argTypes) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(type.toString());
            ++i;
        }
        if (this.isVariadic) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        this.name.write(out);
        out.writeShort(this.argTypes.length);
        for (Type type : this.argTypes) {
            ColumnType.write(out, type);
        }
        out.writeBoolean(this.isVariadic);
    }

    public void readFields(DataInput in) throws IOException {
        this.name = FunctionName.read(in);
        this.argTypes = new Type[in.readShort()];
        for (int i = 0; i < this.argTypes.length; ++i) {
            this.argTypes[i] = ColumnType.read(in);
        }
        this.isVariadic = in.readBoolean();
    }

    public static FunctionSearchDesc read(DataInput input) throws IOException {
        FunctionSearchDesc function = new FunctionSearchDesc();
        function.readFields(input);
        return function;
    }
}

