/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.catalog.AggregateFunction;
import org.apache.doris.catalog.AliasFunction;
import org.apache.doris.catalog.ColumnType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.IOUtils;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.URI;
import org.apache.doris.thrift.TFunction;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Function
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Function.class);
    public static final long UNIQUE_FUNCTION_ID = 0L;
    private long id = 0L;
    private FunctionName name;
    private Type retType;
    private Type[] argTypes;
    private boolean hasVarArgs;
    private boolean userVisible;
    private URI location;
    private TFunctionBinaryType binaryType;
    protected NullableMode nullableMode = NullableMode.DEPEND_ON_ARGUMENT;
    protected boolean vectorized = false;
    protected String checksum = "";

    protected Function() {
    }

    public Function(FunctionName name, List<Type> args, Type retType, boolean varArgs) {
        this(0L, name, args, retType, varArgs, false, NullableMode.DEPEND_ON_ARGUMENT);
    }

    public Function(FunctionName name, List<Type> args, Type retType, boolean varArgs, boolean vectorized) {
        this(0L, name, args, retType, varArgs, vectorized, NullableMode.DEPEND_ON_ARGUMENT);
    }

    public Function(FunctionName name, List<Type> args, Type retType, boolean varArgs, boolean vectorized, NullableMode mode) {
        this(0L, name, args, retType, varArgs, vectorized, mode);
    }

    public Function(long id, FunctionName name, List<Type> argTypes, Type retType, boolean hasVarArgs, TFunctionBinaryType binaryType, boolean userVisible, boolean vectorized, NullableMode mode) {
        this.id = id;
        this.name = name;
        this.hasVarArgs = hasVarArgs;
        this.argTypes = argTypes.size() > 0 ? argTypes.toArray(new Type[argTypes.size()]) : new Type[0];
        this.retType = retType;
        this.binaryType = binaryType;
        this.userVisible = userVisible;
        this.vectorized = vectorized;
        this.nullableMode = mode;
    }

    public Function(long id, FunctionName name, List<Type> argTypes, Type retType, boolean hasVarArgs, boolean vectorized, NullableMode mode) {
        this(id, name, argTypes, retType, hasVarArgs, TFunctionBinaryType.BUILTIN, true, vectorized, mode);
    }

    public FunctionName getFunctionName() {
        return this.name;
    }

    public String functionName() {
        return this.name.getFunction();
    }

    public String dbName() {
        return this.name.getDb();
    }

    public Type getReturnType() {
        return this.retType;
    }

    public void setReturnType(Type type) {
        this.retType = type;
    }

    public Type[] getArgs() {
        return this.argTypes;
    }

    public int getNumArgs() {
        return this.argTypes.length;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI loc) {
        this.location = loc;
    }

    public TFunctionBinaryType getBinaryType() {
        return this.binaryType;
    }

    public void setBinaryType(TFunctionBinaryType type) {
        this.binaryType = type;
    }

    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    public boolean isUserVisible() {
        return this.userVisible;
    }

    public void setUserVisible(boolean userVisible) {
        this.userVisible = userVisible;
    }

    public Type getVarArgsType() {
        if (!this.hasVarArgs) {
            return Type.INVALID;
        }
        Preconditions.checkState((this.argTypes.length > 0 ? 1 : 0) != 0);
        return this.argTypes[this.argTypes.length - 1];
    }

    public void setHasVarArgs(boolean v) {
        this.hasVarArgs = v;
    }

    public void setId(long functionId) {
        this.id = functionId;
    }

    public long getId() {
        return this.id;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isUdf() {
        return this.location != null;
    }

    public String signatureString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name.getFunction()).append("(").append(Joiner.on((String)", ").join((Object[])this.argTypes));
        if (this.hasVarArgs) {
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean compare(Function other, CompareMode mode) {
        switch (mode) {
            case IS_IDENTICAL: {
                return this.isIdentical(other);
            }
            case IS_INDISTINGUISHABLE: {
                return this.isIndistinguishable(other);
            }
            case IS_SUPERTYPE_OF: {
                return this.isSubtype(other);
            }
            case IS_NONSTRICT_SUPERTYPE_OF: {
                return this.isAssignCompatible(other);
            }
            case IS_MATCHABLE: {
                return this.isMatchable(other);
            }
        }
        Preconditions.checkState((boolean)false);
        return false;
    }

    private boolean isSubtype(Function other) {
        int i;
        if (!this.hasVarArgs && other.argTypes.length != this.argTypes.length) {
            return false;
        }
        if (this.hasVarArgs && other.argTypes.length < this.argTypes.length) {
            return false;
        }
        for (i = 0; i < this.argTypes.length; ++i) {
            if (Type.isImplicitlyCastable(other.argTypes[i], this.argTypes[i], true)) continue;
            return false;
        }
        if (this.hasVarArgs) {
            for (i = this.argTypes.length; i < other.argTypes.length; ++i) {
                if (Type.isImplicitlyCastable(other.argTypes[i], this.getVarArgsType(), true)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAssignCompatible(Function other) {
        int i;
        if (!this.hasVarArgs && other.argTypes.length != this.argTypes.length) {
            return false;
        }
        if (this.hasVarArgs && other.argTypes.length < this.argTypes.length) {
            return false;
        }
        for (i = 0; i < this.argTypes.length; ++i) {
            if (Type.canCastTo(other.argTypes[i], this.argTypes[i])) continue;
            return false;
        }
        if (this.hasVarArgs) {
            for (i = this.argTypes.length; i < other.argTypes.length; ++i) {
                if (Type.canCastTo(other.argTypes[i], this.getVarArgsType())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isMatchable(Function o) {
        if (!o.name.equals(this.name)) {
            return false;
        }
        if (this.argTypes != null) {
            if (o.argTypes.length != this.argTypes.length) {
                return false;
            }
            if (o.hasVarArgs != this.hasVarArgs) {
                return false;
            }
            for (int i = 0; i < this.argTypes.length; ++i) {
                if (o.argTypes[i].matchesType(this.argTypes[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isIdentical(Function o) {
        if (!o.name.equals(this.name)) {
            return false;
        }
        if (o.argTypes.length != this.argTypes.length) {
            return false;
        }
        if (o.hasVarArgs != this.hasVarArgs) {
            return false;
        }
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (o.argTypes[i].matchesType(this.argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isIndistinguishable(Function o) {
        int i;
        if (!o.name.equals(this.name)) {
            return false;
        }
        int minArgs = Math.min(o.argTypes.length, this.argTypes.length);
        for (i = 0; i < minArgs; ++i) {
            if (o.argTypes[i].isNull() || this.argTypes[i].isNull() || o.argTypes[i].matchesType(this.argTypes[i])) continue;
            return false;
        }
        if (o.argTypes.length == this.argTypes.length) {
            return true;
        }
        if (o.hasVarArgs && this.hasVarArgs) {
            if (!o.getVarArgsType().matchesType(this.getVarArgsType())) {
                return false;
            }
            if (this.getNumArgs() > o.getNumArgs()) {
                for (i = minArgs; i < this.getNumArgs(); ++i) {
                    if (this.argTypes[i].isNull() || this.argTypes[i].matchesType(o.getVarArgsType())) continue;
                    return false;
                }
            } else {
                for (i = minArgs; i < o.getNumArgs(); ++i) {
                    if (o.argTypes[i].isNull() || o.argTypes[i].matchesType(this.getVarArgsType())) continue;
                    return false;
                }
            }
            return true;
        }
        if (o.hasVarArgs) {
            if (o.getNumArgs() > minArgs) {
                return false;
            }
            for (i = minArgs; i < this.getNumArgs(); ++i) {
                if (this.argTypes[i].isNull() || this.argTypes[i].matchesType(o.getVarArgsType())) continue;
                return false;
            }
            return true;
        }
        if (this.hasVarArgs) {
            if (this.getNumArgs() > minArgs) {
                return false;
            }
            for (i = minArgs; i < o.getNumArgs(); ++i) {
                if (o.argTypes[i].isNull() || o.argTypes[i].matchesType(this.getVarArgsType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TFunction toThrift() {
        TFunction fn = new TFunction();
        fn.setSignature(this.signatureString());
        fn.setName(this.name.toThrift());
        fn.setBinaryType(this.binaryType);
        if (this.location != null) {
            fn.setHdfsLocation(this.location.getLocation());
        }
        fn.setArgTypes(Type.toThrift(this.argTypes));
        fn.setRetType(this.getReturnType().toThrift());
        fn.setHasVarArgs(this.hasVarArgs);
        fn.setId(this.id);
        if (!this.checksum.isEmpty()) {
            fn.setChecksum(this.checksum);
        }
        fn.setVectorized(this.vectorized);
        return fn;
    }

    public String toSql(boolean ifNotExists) {
        return "";
    }

    public static String getUdfTypeName(PrimitiveType t) {
        switch (t) {
            case BOOLEAN: {
                return "boolean_val";
            }
            case TINYINT: {
                return "tiny_int_val";
            }
            case SMALLINT: {
                return "small_int_val";
            }
            case INT: {
                return "int_val";
            }
            case BIGINT: {
                return "big_int_val";
            }
            case LARGEINT: {
                return "large_int_val";
            }
            case FLOAT: {
                return "float_val";
            }
            case DOUBLE: 
            case TIME: {
                return "double_val";
            }
            case VARCHAR: 
            case CHAR: 
            case HLL: 
            case BITMAP: 
            case STRING: {
                return "string_val";
            }
            case DATE: 
            case DATETIME: {
                return "datetime_val";
            }
            case DECIMALV2: {
                return "decimalv2_val";
            }
        }
        Preconditions.checkState((boolean)false, (Object)t.toString());
        return "";
    }

    public static String getUdfType(PrimitiveType t) {
        switch (t) {
            case NULL_TYPE: {
                return "AnyVal";
            }
            case BOOLEAN: {
                return "BooleanVal";
            }
            case TINYINT: {
                return "TinyIntVal";
            }
            case SMALLINT: {
                return "SmallIntVal";
            }
            case INT: {
                return "IntVal";
            }
            case BIGINT: {
                return "BigIntVal";
            }
            case LARGEINT: {
                return "LargeIntVal";
            }
            case FLOAT: {
                return "FloatVal";
            }
            case DOUBLE: 
            case TIME: {
                return "DoubleVal";
            }
            case VARCHAR: 
            case CHAR: 
            case HLL: 
            case BITMAP: 
            case STRING: {
                return "StringVal";
            }
            case DATE: 
            case DATETIME: {
                return "DateTimeVal";
            }
            case DECIMALV2: {
                return "DecimalV2Val";
            }
        }
        Preconditions.checkState((boolean)false, (Object)t.toString());
        return "";
    }

    public static Function getFunction(List<Function> fns, Function desc, CompareMode mode) {
        if (fns == null) {
            return null;
        }
        for (Function f : fns) {
            if (!f.compare(desc, CompareMode.IS_IDENTICAL)) continue;
            return f;
        }
        if (mode == CompareMode.IS_IDENTICAL) {
            return null;
        }
        for (Function f : fns) {
            if (!f.compare(desc, CompareMode.IS_INDISTINGUISHABLE)) continue;
            return f;
        }
        if (mode == CompareMode.IS_INDISTINGUISHABLE) {
            return null;
        }
        for (Function f : fns) {
            if (!f.compare(desc, CompareMode.IS_SUPERTYPE_OF)) continue;
            return f;
        }
        if (mode == CompareMode.IS_SUPERTYPE_OF) {
            return null;
        }
        for (Function f : fns) {
            if (!f.compare(desc, CompareMode.IS_NONSTRICT_SUPERTYPE_OF)) continue;
            return f;
        }
        return null;
    }

    protected void writeFields(DataOutput output) throws IOException {
        output.writeLong(this.id);
        this.name.write(output);
        ColumnType.write(output, this.retType);
        output.writeInt(this.argTypes.length);
        for (Type type : this.argTypes) {
            ColumnType.write(output, type);
        }
        output.writeBoolean(this.hasVarArgs);
        output.writeBoolean(this.userVisible);
        output.writeInt(this.binaryType.getValue());
        String libUrl = "";
        if (this.location != null) {
            libUrl = this.location.getLocation();
        }
        IOUtils.writeOptionString((DataOutput)output, (String)libUrl);
        IOUtils.writeOptionString((DataOutput)output, (String)this.checksum);
    }

    public void write(DataOutput output) throws IOException {
        throw new Error("Origin function cannot be serialized");
    }

    public void readFields(DataInput input) throws IOException {
        boolean hasChecksum;
        this.id = input.readLong();
        this.name = FunctionName.read(input);
        this.retType = ColumnType.read(input);
        int numArgs = input.readInt();
        this.argTypes = new Type[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            this.argTypes[i] = ColumnType.read(input);
        }
        this.hasVarArgs = input.readBoolean();
        this.userVisible = input.readBoolean();
        this.binaryType = TFunctionBinaryType.findByValue((int)input.readInt());
        boolean hasLocation = input.readBoolean();
        if (hasLocation) {
            String locationStr = Text.readString((DataInput)input);
            try {
                this.location = URI.create(locationStr);
            }
            catch (AnalysisException e) {
                LOG.warn("failed to parse location:" + locationStr);
            }
        }
        if (hasChecksum = input.readBoolean()) {
            this.checksum = Text.readString((DataInput)input);
        }
    }

    public static Function read(DataInput input) throws IOException {
        Function function;
        FunctionType functionType = FunctionType.read(input);
        switch (functionType) {
            case SCALAR: {
                function = new ScalarFunction();
                break;
            }
            case AGGREGATE: {
                function = new AggregateFunction();
                break;
            }
            case ALIAS: {
                function = new AliasFunction();
                break;
            }
            default: {
                throw new Error("Unsupported function type, type=" + (Object)((Object)functionType));
            }
        }
        function.readFields(input);
        return function;
    }

    public String getProperties() {
        return "";
    }

    public List<Comparable> getInfo(boolean isVerbose) {
        ArrayList row = Lists.newArrayList();
        if (isVerbose) {
            row.add(this.signatureString());
            row.add(this.getReturnType().getPrimitiveType().toString());
            if (this instanceof ScalarFunction) {
                row.add("Scalar");
                row.add("NULL");
            } else if (this instanceof AliasFunction) {
                row.add("Alias");
                row.add("NULL");
            } else {
                row.add("Aggregate");
                AggregateFunction aggFunc = (AggregateFunction)this;
                Type intermediateType = aggFunc.getIntermediateType();
                if (intermediateType != null) {
                    row.add(intermediateType.getPrimitiveType().toString());
                } else {
                    row.add("NULL");
                }
            }
            row.add(this.getProperties());
        } else {
            row.add(this.functionName());
        }
        return row;
    }

    boolean isVectorized() {
        return this.vectorized;
    }

    public NullableMode getNullableMode() {
        return this.nullableMode;
    }

    static enum FunctionType {
        ORIGIN(0),
        SCALAR(1),
        AGGREGATE(2),
        ALIAS(3);

        private int code;

        private FunctionType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static FunctionType fromCode(int code) {
            switch (code) {
                case 0: {
                    return ORIGIN;
                }
                case 1: {
                    return SCALAR;
                }
                case 2: {
                    return AGGREGATE;
                }
                case 3: {
                    return ALIAS;
                }
            }
            return null;
        }

        public void write(DataOutput output) throws IOException {
            output.writeInt(this.code);
        }

        public static FunctionType read(DataInput input) throws IOException {
            return FunctionType.fromCode(input.readInt());
        }
    }

    public static enum NullableMode {
        DEPEND_ON_ARGUMENT,
        ALWAYS_NULLABLE,
        ALWAYS_NOT_NULLABLE,
        CUSTOM;

    }

    public static enum CompareMode {
        IS_IDENTICAL,
        IS_INDISTINGUISHABLE,
        IS_SUPERTYPE_OF,
        IS_NONSTRICT_SUPERTYPE_OF,
        IS_MATCHABLE;

    }
}

