/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.system.BrokerHbResponse;
import org.apache.doris.system.HeartbeatResponse;

public class FsBroker
implements Writable,
Comparable<FsBroker> {
    @SerializedName(value="ip")
    public String ip;
    @SerializedName(value="port")
    public int port;
    public String heartbeatErrMsg = "";
    public long lastUpdateTime = -1L;
    @SerializedName(value="lastStartTime")
    public long lastStartTime = -1L;
    @SerializedName(value="isAlive")
    public boolean isAlive;

    public FsBroker() {
    }

    public FsBroker(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public boolean handleHbResponse(BrokerHbResponse hbResponse) {
        boolean isChanged = false;
        if (hbResponse.getStatus() == HeartbeatResponse.HbStatus.OK) {
            if (!this.isAlive) {
                this.isAlive = true;
                isChanged = true;
                this.lastStartTime = hbResponse.getHbTime();
            } else if (this.lastStartTime <= 0L) {
                this.lastStartTime = hbResponse.getHbTime();
            }
            this.lastUpdateTime = hbResponse.getHbTime();
            this.heartbeatErrMsg = "";
        } else {
            if (this.isAlive) {
                this.isAlive = false;
                isChanged = true;
            }
            this.heartbeatErrMsg = hbResponse.getMsg() == null ? "Unknown error" : hbResponse.getMsg();
        }
        return isChanged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FsBroker)) {
            return false;
        }
        FsBroker that = (FsBroker)o;
        if (this.port != that.port) {
            return false;
        }
        return this.ip.equals(that.ip);
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(FsBroker o) {
        int ret = this.ip.compareTo(o.ip);
        if (ret != 0) {
            return ret;
        }
        return this.port - o.port;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.ip = Text.readString((DataInput)in);
        this.port = in.readInt();
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }

    public static FsBroker readIn(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (FsBroker)GsonUtils.GSON.fromJson(json, FsBroker.class);
    }
}

