/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.SinglePartitionInfo;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.external.elasticsearch.EsMajorVersion;
import org.apache.doris.external.elasticsearch.EsMetaStateTracker;
import org.apache.doris.external.elasticsearch.EsRestClient;
import org.apache.doris.external.elasticsearch.EsTablePartitions;
import org.apache.doris.external.elasticsearch.EsUtil;
import org.apache.doris.thrift.TEsTable;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsTable
extends Table {
    private static final Logger LOG = LogManager.getLogger(EsTable.class);
    public static final Set<String> DEFAULT_DOCVALUE_DISABLED_FIELDS = new HashSet<String>(Arrays.asList("text"));
    public static final String HOSTS = "hosts";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String INDEX = "index";
    public static final String TYPE = "type";
    public static final String TRANSPORT = "transport";
    public static final String VERSION = "version";
    public static final String DOC_VALUES_MODE = "doc_values_mode";
    public static final String TRANSPORT_HTTP = "http";
    public static final String TRANSPORT_THRIFT = "thrift";
    public static final String DOC_VALUE_SCAN = "enable_docvalue_scan";
    public static final String KEYWORD_SNIFF = "enable_keyword_sniff";
    public static final String MAX_DOCVALUE_FIELDS = "max_docvalue_fields";
    public static final String NODES_DISCOVERY = "nodes_discovery";
    public static final String HTTP_SSL_ENABLED = "http_ssl_enabled";
    private String hosts;
    private String[] seeds;
    private String userName = "";
    private String passwd = "";
    private String indexName;
    private String mappingType = null;
    private String transport = "http";
    private PartitionInfo partitionInfo;
    private EsTablePartitions esTablePartitions;
    private boolean enableDocValueScan = true;
    private boolean enableKeywordSniff = true;
    private int maxDocValueFields = 20;
    private boolean nodesDiscovery = true;
    private boolean httpSslEnabled = false;
    private static final int DEFAULT_MAX_DOCVALUE_FIELDS = 20;
    public EsMajorVersion majorVersion = null;
    private Map<String, String> tableContext = new HashMap<String, String>();
    private Throwable lastMetaDataSyncException = null;
    private EsMetaStateTracker esMetaStateTracker;

    public EsTable() {
        super(Table.TableType.ELASTICSEARCH);
    }

    public EsTable(long id, String name, List<Column> schema, Map<String, String> properties, PartitionInfo partitionInfo) throws DdlException {
        super(id, name, Table.TableType.ELASTICSEARCH, schema);
        this.partitionInfo = partitionInfo;
        this.validate(properties);
    }

    public Map<String, String> fieldsContext() {
        return this.esMetaStateTracker.searchContext().fetchFieldsContext();
    }

    public Map<String, String> docValueContext() {
        return this.esMetaStateTracker.searchContext().docValueFieldsContext();
    }

    public int maxDocValueFields() {
        return this.maxDocValueFields;
    }

    public boolean isDocValueScanEnable() {
        return this.enableDocValueScan;
    }

    public boolean isKeywordSniffEnable() {
        return this.enableKeywordSniff;
    }

    public boolean isNodesDiscovery() {
        return this.nodesDiscovery;
    }

    public boolean isHttpSslEnabled() {
        return this.httpSslEnabled;
    }

    private void validate(Map<String, String> properties) throws DdlException {
        if (properties == null) {
            throw new DdlException("Please set properties of elasticsearch table, they are: hosts, user, password, index");
        }
        if (Strings.isNullOrEmpty((String)properties.get(HOSTS)) || Strings.isNullOrEmpty((String)properties.get(HOSTS).trim())) {
            throw new DdlException("Hosts of ES table is null. Please add properties('hosts'='xxx.xxx.xxx.xxx,xxx.xxx.xxx.xxx') when create table");
        }
        this.hosts = properties.get(HOSTS).trim();
        this.seeds = this.hosts.split(",");
        if (!Strings.isNullOrEmpty((String)properties.get(USER)) && !Strings.isNullOrEmpty((String)properties.get(USER).trim())) {
            this.userName = properties.get(USER).trim();
        }
        if (!Strings.isNullOrEmpty((String)properties.get(PASSWORD)) && !Strings.isNullOrEmpty((String)properties.get(PASSWORD).trim())) {
            this.passwd = properties.get(PASSWORD).trim();
        }
        if (Strings.isNullOrEmpty((String)properties.get(INDEX)) || Strings.isNullOrEmpty((String)properties.get(INDEX).trim())) {
            throw new DdlException("Index of ES table is null. Please add properties('index'='xxxx') when create table");
        }
        this.indexName = properties.get(INDEX).trim();
        if (properties.containsKey(VERSION)) {
            try {
                this.majorVersion = EsMajorVersion.parse(properties.get(VERSION).trim());
                if (this.majorVersion.before(EsMajorVersion.V_5_X)) {
                    throw new DdlException("Unsupported/Unknown ES Cluster version [" + properties.get(VERSION) + "] ");
                }
            }
            catch (Exception e) {
                throw new DdlException("fail to parse ES major version, version= " + properties.get(VERSION).trim() + ", should be like '6.5.3' ");
            }
        }
        if (properties.containsKey(DOC_VALUE_SCAN)) {
            this.enableDocValueScan = EsUtil.getBoolean(properties, DOC_VALUE_SCAN);
        }
        if (properties.containsKey(KEYWORD_SNIFF)) {
            this.enableKeywordSniff = EsUtil.getBoolean(properties, KEYWORD_SNIFF);
        }
        if (properties.containsKey(NODES_DISCOVERY)) {
            this.nodesDiscovery = EsUtil.getBoolean(properties, NODES_DISCOVERY);
        }
        if (properties.containsKey(HTTP_SSL_ENABLED)) {
            this.httpSslEnabled = EsUtil.getBoolean(properties, HTTP_SSL_ENABLED);
            for (String seed : this.seeds) {
                if (this.httpSslEnabled && seed.startsWith("http://")) {
                    throw new DdlException("if http_ssl_enabled is true, the https protocol must be used");
                }
                if (this.httpSslEnabled || !seed.startsWith("https://")) continue;
                throw new DdlException("if http_ssl_enabled is false, the http protocol must be used");
            }
        }
        if (!Strings.isNullOrEmpty((String)properties.get(TYPE)) && !Strings.isNullOrEmpty((String)properties.get(TYPE).trim())) {
            this.mappingType = properties.get(TYPE).trim();
        }
        if (!Strings.isNullOrEmpty((String)properties.get(TRANSPORT)) && !Strings.isNullOrEmpty((String)properties.get(TRANSPORT).trim())) {
            this.transport = properties.get(TRANSPORT).trim();
            if (!TRANSPORT_HTTP.equals(this.transport) && !TRANSPORT_THRIFT.equals(this.transport)) {
                throw new DdlException("transport of ES table must be http/https(recommend) or thrift(reserved inner usage), but value is " + this.transport);
            }
        }
        if (properties.containsKey(MAX_DOCVALUE_FIELDS)) {
            try {
                this.maxDocValueFields = Integer.parseInt(properties.get(MAX_DOCVALUE_FIELDS).trim());
                if (this.maxDocValueFields < 0) {
                    this.maxDocValueFields = 0;
                }
            }
            catch (Exception e) {
                this.maxDocValueFields = 20;
            }
        }
        this.tableContext.put(HOSTS, this.hosts);
        this.tableContext.put("userName", this.userName);
        this.tableContext.put("passwd", this.passwd);
        this.tableContext.put("indexName", this.indexName);
        if (this.mappingType != null) {
            this.tableContext.put("mappingType", this.mappingType);
        }
        this.tableContext.put(TRANSPORT, this.transport);
        if (this.majorVersion != null) {
            this.tableContext.put("majorVersion", this.majorVersion.toString());
        }
        this.tableContext.put("enableDocValueScan", String.valueOf(this.enableDocValueScan));
        this.tableContext.put("enableKeywordSniff", String.valueOf(this.enableKeywordSniff));
        this.tableContext.put("maxDocValueFields", String.valueOf(this.maxDocValueFields));
        this.tableContext.put(NODES_DISCOVERY, String.valueOf(this.nodesDiscovery));
        this.tableContext.put(HTTP_SSL_ENABLED, String.valueOf(this.httpSslEnabled));
    }

    @Override
    public TTableDescriptor toThrift() {
        TEsTable tEsTable = new TEsTable();
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.ES_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setEsTable(tEsTable);
        return tTableDescriptor;
    }

    @Override
    public String getSignature(int signatureVersion) {
        StringBuilder sb = new StringBuilder(signatureVersion);
        sb.append(this.name);
        sb.append(this.type.name());
        if (this.tableContext.isEmpty()) {
            sb.append(this.hosts);
            sb.append(this.userName);
            sb.append(this.passwd);
            sb.append(this.indexName);
            if (this.mappingType != null) {
                sb.append(this.mappingType);
            }
            sb.append(this.transport);
        } else {
            for (Map.Entry<String, String> entry : this.tableContext.entrySet()) {
                sb.append(entry.getKey());
                sb.append(entry.getValue());
            }
        }
        String md5 = DigestUtils.md5Hex((String)sb.toString());
        LOG.debug("get signature of es table {}: {}. signature string: {}", (Object)this.name, (Object)md5, (Object)sb.toString());
        return md5;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.tableContext.size());
        for (Map.Entry<String, String> entry : this.tableContext.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
        Text.writeString((DataOutput)out, (String)this.partitionInfo.getType().name());
        this.partitionInfo.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.tableContext.put(key, value);
        }
        this.hosts = this.tableContext.get(HOSTS);
        this.seeds = this.hosts.split(",");
        this.userName = this.tableContext.get("userName");
        this.passwd = this.tableContext.get("passwd");
        this.indexName = this.tableContext.get("indexName");
        this.mappingType = this.tableContext.get("mappingType");
        this.transport = this.tableContext.get(TRANSPORT);
        if (this.tableContext.containsKey("majorVersion")) {
            try {
                this.majorVersion = EsMajorVersion.parse(this.tableContext.get("majorVersion"));
            }
            catch (Exception e) {
                this.majorVersion = EsMajorVersion.V_5_X;
            }
        }
        this.enableDocValueScan = Boolean.parseBoolean(this.tableContext.get("enableDocValueScan"));
        this.enableKeywordSniff = this.tableContext.containsKey("enableKeywordSniff") ? Boolean.parseBoolean(this.tableContext.get("enableKeywordSniff")) : true;
        if (this.tableContext.containsKey("maxDocValueFields")) {
            try {
                this.maxDocValueFields = Integer.parseInt(this.tableContext.get("maxDocValueFields"));
            }
            catch (Exception e) {
                this.maxDocValueFields = 20;
            }
        }
        this.nodesDiscovery = this.tableContext.containsKey(NODES_DISCOVERY) ? Boolean.parseBoolean(this.tableContext.get(NODES_DISCOVERY)) : true;
        this.httpSslEnabled = this.tableContext.containsKey(HTTP_SSL_ENABLED) ? Boolean.parseBoolean(this.tableContext.get(HTTP_SSL_ENABLED)) : false;
        PartitionType partType = PartitionType.valueOf(Text.readString((DataInput)in));
        if (partType == PartitionType.UNPARTITIONED) {
            this.partitionInfo = SinglePartitionInfo.read(in);
        } else if (partType == PartitionType.RANGE) {
            this.partitionInfo = RangePartitionInfo.read(in);
        } else {
            throw new IOException("invalid partition type: " + (Object)((Object)partType));
        }
    }

    public String getHosts() {
        return this.hosts;
    }

    public String[] getSeeds() {
        return this.seeds;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getMappingType() {
        return this.mappingType;
    }

    public String getTransport() {
        return this.transport;
    }

    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public EsTablePartitions getEsTablePartitions() {
        return this.esTablePartitions;
    }

    public void setEsTablePartitions(EsTablePartitions esTablePartitions) {
        this.esTablePartitions = esTablePartitions;
    }

    public EsMajorVersion esVersion() {
        return this.majorVersion;
    }

    public Throwable getLastMetaDataSyncException() {
        return this.lastMetaDataSyncException;
    }

    public void setLastMetaDataSyncException(Throwable lastMetaDataSyncException) {
        this.lastMetaDataSyncException = lastMetaDataSyncException;
    }

    public void syncTableMetaData(EsRestClient client) {
        if (this.esMetaStateTracker == null) {
            this.esMetaStateTracker = new EsMetaStateTracker(client, this);
        }
        try {
            this.esMetaStateTracker.run();
            this.esTablePartitions = this.esMetaStateTracker.searchContext().tablePartitions();
        }
        catch (Throwable e) {
            LOG.warn("Exception happens when fetch index [{}] meta data from remote es cluster.table id: {}, err: {}", (Object)this.name, (Object)this.id, (Object)e.getMessage());
            this.esTablePartitions = null;
            this.lastMetaDataSyncException = e;
        }
    }
}

