/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import org.apache.doris.analysis.CreateEncryptKeyStmt;
import org.apache.doris.analysis.DropEncryptKeyStmt;
import org.apache.doris.analysis.EncryptKeyName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.catalog.EncryptKeySearchDesc;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptKeyHelper {
    private static final Logger LOG = LogManager.getLogger(EncryptKeyHelper.class);

    public static void createEncryptKey(CreateEncryptKeyStmt stmt) throws UserException {
        EncryptKeyName name = stmt.getEncryptKeyName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(name.getDb());
        db.addEncryptKey(stmt.getEncryptKey());
    }

    public static void replayCreateEncryptKey(EncryptKey encryptKey) throws MetaNotFoundException {
        String dbName = encryptKey.getEncryptKeyName().getDb();
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbName);
        db.replayAddEncryptKey(encryptKey);
    }

    public static void dropEncryptKey(DropEncryptKeyStmt stmt) throws UserException {
        EncryptKeyName name = stmt.getEncryptKeyName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(name.getDb());
        db.dropEncryptKey(stmt.getEncryptKeysSearchDesc());
    }

    public static void replayDropEncryptKey(EncryptKeySearchDesc encryptKeySearchDesc) throws MetaNotFoundException {
        String dbName = encryptKeySearchDesc.getKeyEncryptKeyName().getDb();
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbName);
        db.replayDropEncryptKey(encryptKeySearchDesc);
    }
}

